/*
 * Decompiled with CFR 0.152.
 */
package hbci4java;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import domain.BankAccess;
import domain.BankAccount;
import domain.BankApi;
import domain.BankApiUser;
import domain.Booking;
import domain.LoadBookingsResponse;
import domain.Payment;
import domain.PaymentChallenge;
import domain.StandingOrder;
import domain.TanTransportType;
import exception.InvalidPinException;
import exception.PaymentException;
import hbci4java.HbciCallback;
import hbci4java.HbciMapping;
import hbci4java.HbciPassport;
import hbci4java.HbciTanSubmit;
import java.io.InputStream;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.TreeSet;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.kapott.hbci.GV.AbstractHBCIJob;
import org.kapott.hbci.GV.GVTAN2Step;
import org.kapott.hbci.GV_Result.GVRDauerList;
import org.kapott.hbci.GV_Result.GVRKUms;
import org.kapott.hbci.GV_Result.GVRSaldoReq;
import org.kapott.hbci.exceptions.HBCI_Exception;
import org.kapott.hbci.manager.BankInfo;
import org.kapott.hbci.manager.HBCIDialog;
import org.kapott.hbci.manager.HBCIJobFactory;
import org.kapott.hbci.manager.HBCITwoStepMechanism;
import org.kapott.hbci.manager.HBCIUtils;
import org.kapott.hbci.passport.HBCIPassportInternal;
import org.kapott.hbci.passport.PinTanPassport;
import org.kapott.hbci.status.HBCIExecStatus;
import org.kapott.hbci.structures.Konto;
import org.kapott.hbci.structures.Value;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import spi.OnlineBankingService;

public class Hbci4JavaBanking
implements OnlineBankingService {
    private static final Logger log = LoggerFactory.getLogger(Hbci4JavaBanking.class);
    private static final Logger LOG = LoggerFactory.getLogger(Hbci4JavaBanking.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    public Hbci4JavaBanking() {
        try (InputStream inputStream = HBCIUtils.class.getClassLoader().getResource("blz.properties").openStream();){
            HBCIUtils.refreshBLZList((InputStream)inputStream);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        OBJECT_MAPPER.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        OBJECT_MAPPER.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        OBJECT_MAPPER.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        OBJECT_MAPPER.registerModule((Module)new Jdk8Module());
    }

    public BankApi bankApi() {
        return BankApi.HBCI;
    }

    public boolean externalBankAccountRequired() {
        return false;
    }

    public boolean userRegistrationRequired() {
        return false;
    }

    public BankApiUser registerUser(String uid) {
        return null;
    }

    public void removeUser(BankApiUser bankApiUser) {
    }

    public boolean bookingsCategorized() {
        return false;
    }

    public List<BankAccount> loadBankAccounts(BankApiUser bankApiUser, BankAccess bankAccess, String bankCode, String pin, boolean storePin) {
        LOG.info("Loading Account list for access {}", (Object)bankAccess.getBankCode());
        try {
            HBCIDialog dialog = this.createDialog(bankAccess, bankCode, null, pin);
            if (!dialog.getPassport().jobSupported("SEPAInfo")) {
                throw new RuntimeException("SEPAInfo job not supported");
            }
            log.info("fetching SEPA information");
            dialog.addTask(HBCIJobFactory.newJob((String)"SEPAInfo", (HBCIPassportInternal)dialog.getPassport()));
            if (dialog.getPassport().jobSupported("TANMediaList")) {
                log.info("fetching TAN media list");
                dialog.addTask(HBCIJobFactory.newJob((String)"TANMediaList", (HBCIPassportInternal)dialog.getPassport()));
            }
            dialog.execute(true);
            bankAccess.setBankName(dialog.getPassport().getInstName());
            ArrayList<BankAccount> hbciAccounts = new ArrayList<BankAccount>();
            for (Konto konto : dialog.getPassport().getAccounts()) {
                BankAccount bankAccount = HbciMapping.toBankAccount(konto);
                bankAccount.externalId(this.bankApi(), UUID.randomUUID().toString());
                bankAccount.bankName(bankAccess.getBankName());
                hbciAccounts.add(bankAccount);
            }
            this.updateTanTransportTypes(bankAccess, (HbciPassport)dialog.getPassport());
            bankAccess.setHbciPassportState(new HbciPassport.State(dialog.getPassport()).toJson());
            return hbciAccounts;
        }
        catch (HBCI_Exception e) {
            throw this.handleHbciException(e);
        }
    }

    public void removeBankAccount(BankAccount bankAccount, BankApiUser bankApiUser) {
    }

    public LoadBookingsResponse loadBookings(BankApiUser bankApiUser, BankAccess bankAccess, String bankCode, BankAccount bankAccount, String pin) {
        HBCIDialog dialog = this.createDialog(bankAccess, bankCode, null, pin);
        try {
            HBCIExecStatus status;
            Konto account = dialog.getPassport().getAccount(bankAccount.getAccountNumber());
            account.iban = bankAccount.getIban();
            account.bic = bankAccount.getBic();
            AbstractHBCIJob balanceJob = HBCIJobFactory.newJob((String)"SaldoReq", (HBCIPassportInternal)dialog.getPassport());
            balanceJob.setParam("my", account);
            dialog.addTask(balanceJob);
            AbstractHBCIJob bookingsJob = HBCIJobFactory.newJob((String)"KUmsAll", (HBCIPassportInternal)dialog.getPassport());
            bookingsJob.setParam("my", account);
            if (bankAccount.getLastSync() != null) {
                bookingsJob.setParam("startdate", Date.from(bankAccount.getLastSync().atZone(ZoneId.systemDefault()).toInstant()));
            }
            dialog.addTask(bookingsJob);
            AbstractHBCIJob standingOrdersJob = null;
            if (dialog.getPassport().jobSupported("DauerSEPAList")) {
                standingOrdersJob = HBCIJobFactory.newJob((String)"DauerSEPAList", (HBCIPassportInternal)dialog.getPassport());
                standingOrdersJob.setParam("src", account);
                dialog.addTask(standingOrdersJob);
            }
            if (!(status = dialog.execute(true)).isOK()) {
                LOG.error("Status of SaldoReq+KUmsAll+DauerSEPAList batch job not OK " + status);
            }
            if (bookingsJob.getJobResult().getJobStatus().hasErrors()) {
                LOG.error("Bookings job not OK");
                throw new HBCI_Exception(bookingsJob.getJobResult().getJobStatus().getErrorString());
            }
            bankAccess.setHbciPassportState(new HbciPassport.State(dialog.getPassport()).toJson());
            List<StandingOrder> standingOrders = null;
            if (standingOrdersJob != null) {
                standingOrders = HbciMapping.createStandingOrders((GVRDauerList)standingOrdersJob.getJobResult());
            }
            List<Booking> bookings = HbciMapping.createBookings((GVRKUms)bookingsJob.getJobResult());
            ArrayList bookingList = bookings.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<Booking>(Comparator.comparing(Booking::getExternalId))), ArrayList::new));
            this.updateTanTransportTypes(bankAccess, (HbciPassport)dialog.getPassport());
            return LoadBookingsResponse.builder().bookings((List)bookingList).bankAccountBalance(HbciMapping.createBalance((GVRSaldoReq)balanceJob.getJobResult())).standingOrders(standingOrders).build();
        }
        catch (HBCI_Exception e) {
            throw this.handleHbciException(e);
        }
    }

    public void createPayment(BankApiUser bankApiUser, BankAccess bankAccess, String bankCode, BankAccount bankAccount, String pin, final Payment payment) {
        final HbciTanSubmit hbciTanSubmit = new HbciTanSubmit();
        hbciTanSubmit.setOriginJobName("UebSEPA");
        HBCIDialog dialog = this.createDialog(bankAccess, bankCode, new HbciCallback(){

            @Override
            public void tanChallengeCallback(String orderRef, String challenge) {
                hbciTanSubmit.setOrderRef(orderRef);
                if (challenge != null) {
                    payment.setPaymentChallenge(PaymentChallenge.builder().title(challenge).build());
                }
            }
        }, pin);
        HBCITwoStepMechanism hbciTwoStepMechanism = (HBCITwoStepMechanism)dialog.getPassport().getTwostepMechanisms().get(payment.getTanMedia().getId());
        if (hbciTwoStepMechanism == null) {
            throw new PaymentException("inavalid two stem mechanism: " + payment.getTanMedia().getId());
        }
        dialog.getPassport().setCurrentSecMechInfo(hbciTwoStepMechanism);
        try {
            Konto src = dialog.getPassport().getAccount(bankAccount.getAccountNumber());
            src.iban = bankAccount.getIban();
            src.bic = bankAccount.getBic();
            Konto dst = new Konto();
            dst.name = payment.getReceiver();
            dst.iban = payment.getReceiverIban();
            dst.bic = payment.getReceiverBic();
            AbstractHBCIJob uebSEPA = HBCIJobFactory.newJob((String)"UebSEPA", (HBCIPassportInternal)dialog.getPassport());
            uebSEPA.setParam("src", src);
            uebSEPA.setParam("dst", dst);
            uebSEPA.setParam("btg", new Value(payment.getAmount()));
            uebSEPA.setParam("usage", payment.getPurpose());
            List messageJobs = dialog.addTask(uebSEPA);
            GVTAN2Step hktan = (GVTAN2Step)HBCIJobFactory.newJob((String)"TAN2Step", (HBCIPassportInternal)dialog.getPassport());
            hktan.setSegVersion(hbciTwoStepMechanism.getSegversion());
            hktan.setParam("orderaccount", src);
            hktan.setParam("process", "4");
            if (dialog.getPassport().tanMediaNeeded()) {
                hktan.setParam("tanmedia", payment.getTanMedia().getMedium());
            }
            messageJobs.add(hktan);
            HBCIExecStatus status = dialog.execute(false);
            if (!status.isOK()) {
                throw new PaymentException(status.getDialogStatus().getErrorString());
            }
            hbciTanSubmit.setPassportState(bankAccess.getHbciPassportState());
            hbciTanSubmit.setDialogId(dialog.getDialogID());
            hbciTanSubmit.setMsgNum(dialog.getMsgnum());
            hbciTanSubmit.setOriginSegVersion(uebSEPA.getSegVersion());
            payment.setTanSubmitExternal((Object)hbciTanSubmit);
        }
        catch (HBCI_Exception e) {
            throw this.handleHbciException(e);
        }
    }

    public void submitPayment(Payment payment, String pin, final String tan) {
        HbciTanSubmit hbciTanSubmit = (HbciTanSubmit)payment.getTanSubmitExternal();
        HbciPassport.State state = HbciPassport.State.readJson(hbciTanSubmit.getPassportState());
        HbciPassport hbciPassport = this.createPassport(state.hbciVersion, state.blz, state.customerId, state.userId, new HbciCallback(){

            @Override
            public String needTAN() {
                return tan;
            }
        });
        state.apply(hbciPassport);
        hbciPassport.setPIN(pin);
        HBCIDialog hbciDialog = new HBCIDialog((PinTanPassport)hbciPassport, hbciTanSubmit.getDialogId(), hbciTanSubmit.getMsgNum());
        try {
            AbstractHBCIJob originJob = HBCIJobFactory.newJob((String)hbciTanSubmit.getOriginJobName(), (HBCIPassportInternal)hbciDialog.getPassport());
            originJob.setSegVersion(hbciTanSubmit.getOriginSegVersion());
            GVTAN2Step hktan = (GVTAN2Step)HBCIJobFactory.newJob((String)"TAN2Step", (HBCIPassportInternal)hbciDialog.getPassport());
            hktan.setOriginJob(originJob);
            hktan.setParam("orderref", hbciTanSubmit.getOrderRef());
            hktan.setParam("process", "2");
            hktan.setParam("notlasttan", "N");
            hbciDialog.addTask((AbstractHBCIJob)hktan, false);
            HBCIExecStatus status = hbciDialog.execute(true);
            if (!status.isOK()) {
                throw new PaymentException(status.getDialogStatus().getErrorString());
            }
        }
        catch (HBCI_Exception e) {
            throw this.handleHbciException(e);
        }
    }

    public boolean bankSupported(String bankCode) {
        BankInfo bankInfo = HBCIUtils.getBankInfo((String)bankCode);
        return bankInfo != null && bankInfo.getPinTanVersion() != null;
    }

    private void updateTanTransportTypes(BankAccess bankAccess, HbciPassport hbciPassport) {
        if (bankAccess.getTanTransportTypes() == null) {
            bankAccess.setTanTransportTypes(new HashMap());
        }
        bankAccess.getTanTransportTypes().put(this.bankApi(), new ArrayList());
        if (hbciPassport.getUPD() != null) {
            hbciPassport.getAllowedTwostepMechanisms().forEach(id -> {
                HBCITwoStepMechanism properties = (HBCITwoStepMechanism)hbciPassport.getTwostepMechanisms().get(id);
                if (properties != null) {
                    String name = properties.getName();
                    ((List)bankAccess.getTanTransportTypes().get(this.bankApi())).add(TanTransportType.builder().id(id).name(name).inputInfo(properties.getInputinfo()).medium(hbciPassport.getTanMedia(name) != null ? hbciPassport.getTanMedia((String)name).mediaName : null).build());
                } else {
                    LOG.warn("unable find transport type {} for bank code {}", id, (Object)bankAccess.getBankCode());
                }
            });
        } else {
            LOG.warn("missing passport upd, unable find transport types or bank code {}", (Object)bankAccess.getBankCode());
        }
    }

    private HBCIDialog createDialog(BankAccess bankAccess, String bankCode, HbciCallback callback, String pin) {
        return this.createDialog(null, bankAccess, bankCode, callback, pin);
    }

    private HBCIDialog createDialog(HbciPassport passport, BankAccess bankAccess, String bankCode, HbciCallback callback, String pin) {
        BankInfo bankInfo = HBCIUtils.getBankInfo((String)(bankCode != null ? bankCode : bankAccess.getBankCode()));
        String string = bankCode = bankCode != null ? bankCode : bankAccess.getBankCode();
        if (passport == null) {
            passport = this.createPassport(bankInfo.getPinTanVersion().getId(), bankCode, bankAccess.getBankLogin(), bankAccess.getBankLogin2(), callback);
            if (bankAccess.getHbciPassportState() != null) {
                HbciPassport.State.readJson(bankAccess.getHbciPassportState()).apply(passport);
            }
        }
        passport.setPIN(pin);
        String url = bankInfo.getPinTanAddress();
        String proxyPrefix = System.getProperty("proxyPrefix", null);
        if (proxyPrefix != null) {
            url = proxyPrefix + url;
        }
        passport.setHost(url);
        return new HBCIDialog((PinTanPassport)passport);
    }

    private HbciPassport createPassport(String hbciVersion, String bankCode, String login, String login2, HbciCallback callback) {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("kernel.rewriter", "InvalidSegment,WrongStatusSegOrder,WrongSequenceNumbers,MissingMsgRef,HBCIVersion,SigIdLeadingZero,InvalidSuppHBCIVersion,SecTypeTAN,KUmsDelimiters,KUmsEmptyBDateSets");
        properties.put("log.loglevel.default", "2");
        properties.put("default.hbciversion", "FinTS3");
        properties.put("client.passport.PinTan.checkcert", "1");
        properties.put("client.passport.PinTan.init", "1");
        properties.put("client.errors.ignoreJobNotSupported", "yes");
        properties.put("client.passport.country", "DE");
        properties.put("client.passport.blz", bankCode);
        properties.put("client.passport.customerId", login);
        properties.put("client.errors.ignoreCryptErrors", "yes");
        if (StringUtils.isNotBlank((CharSequence)login2)) {
            properties.put("client.passport.userId", login2);
        }
        return new HbciPassport(hbciVersion, properties, callback);
    }

    private RuntimeException handleHbciException(HBCI_Exception e) {
        Throwable processException = e;
        while (processException.getCause() != null && !(processException.getCause() instanceof InvalidPinException)) {
            processException = processException.getCause();
        }
        if (processException.getCause() != null && processException.getCause() instanceof InvalidPinException) {
            return (InvalidPinException)processException.getCause();
        }
        return e;
    }
}

