/*
 * Decompiled with CFR 0.152.
 */
package hbci4java;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import domain.BankAccess;
import domain.BankAccount;
import domain.BankApi;
import domain.BankApiUser;
import domain.Booking;
import domain.LoadBookingsResponse;
import domain.Payment;
import domain.PaymentChallenge;
import domain.StandingOrder;
import domain.TanTransportType;
import exception.InvalidPinException;
import exception.PaymentException;
import hbci4java.HbciCallback;
import hbci4java.HbciGVTanSubmit;
import hbci4java.HbciMapping;
import hbci4java.HbciPassport;
import hbci4java.HbciTanSubmit;
import java.io.IOException;
import java.io.InputStream;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.TreeSet;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.kapott.hbci.GV.AbstractHBCIJob;
import org.kapott.hbci.GV.GVTAN2Step;
import org.kapott.hbci.GV_Result.GVRDauerList;
import org.kapott.hbci.GV_Result.GVRKUms;
import org.kapott.hbci.GV_Result.GVRSaldoReq;
import org.kapott.hbci.exceptions.HBCI_Exception;
import org.kapott.hbci.manager.BankInfo;
import org.kapott.hbci.manager.HBCIDialog;
import org.kapott.hbci.manager.HBCIJobFactory;
import org.kapott.hbci.manager.HBCIUtils;
import org.kapott.hbci.manager.MsgGen;
import org.kapott.hbci.passport.HBCIPassport;
import org.kapott.hbci.passport.HBCIPassportInternal;
import org.kapott.hbci.status.HBCIExecStatus;
import org.kapott.hbci.structures.Konto;
import org.kapott.hbci.structures.Value;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import spi.OnlineBankingService;
import utils.Utils;

public class Hbci4JavaBanking
implements OnlineBankingService {
    private static final Logger LOG = LoggerFactory.getLogger(Hbci4JavaBanking.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    public Hbci4JavaBanking() {
        try (InputStream inputStream = HBCIUtils.class.getClassLoader().getResource("blz.properties").openStream();){
            HBCIUtils.refreshBLZList((InputStream)inputStream);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        OBJECT_MAPPER.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        OBJECT_MAPPER.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        OBJECT_MAPPER.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        OBJECT_MAPPER.registerModule((Module)new Jdk8Module());
    }

    public BankApi bankApi() {
        return BankApi.HBCI;
    }

    public boolean externalBankAccountRequired() {
        return false;
    }

    public boolean userRegistrationRequired() {
        return false;
    }

    public BankApiUser registerUser(String uid) {
        return null;
    }

    public void removeUser(BankApiUser bankApiUser) {
    }

    public boolean bookingsCategorized() {
        return false;
    }

    public List<BankAccount> loadBankAccounts(BankApiUser bankApiUser, BankAccess bankAccess, String bankCode, String pin, boolean storePin) {
        LOG.info("Loading Account list for access {}", (Object)bankAccess.getBankCode());
        HBCIDialog dialog = this.createDialog(bankAccess, bankCode, null, pin);
        try {
            bankAccess.setBankName(dialog.getPassport().getInstName());
            ArrayList<BankAccount> hbciAccounts = new ArrayList<BankAccount>();
            for (Konto konto : dialog.getPassport().getAccounts()) {
                BankAccount bankAccount = HbciMapping.toBankAccount(konto);
                bankAccount.externalId(this.bankApi(), UUID.randomUUID().toString());
                bankAccount.bankName(bankAccess.getBankName());
                hbciAccounts.add(bankAccount);
            }
            if (((HbciPassport)dialog.getPassport()).getState().isPresent()) {
                bankAccess.setHbciPassportState(((HbciPassport)dialog.getPassport()).getState().get().toJson());
            }
            this.updateTanTransportTypes(bankAccess, (HbciPassport)dialog.getPassport());
            return hbciAccounts;
        }
        catch (HBCI_Exception e) {
            this.handleHbciException(e);
            return null;
        }
    }

    public void removeBankAccount(BankAccount bankAccount, BankApiUser bankApiUser) {
    }

    public LoadBookingsResponse loadBookings(BankApiUser bankApiUser, BankAccess bankAccess, String bankCode, BankAccount bankAccount, String pin) {
        HBCIDialog dialog = this.createDialog(bankAccess, bankCode, null, pin);
        try {
            Konto account = dialog.getPassport().getAccount(bankAccount.getAccountNumber());
            AbstractHBCIJob balanceJob = HBCIJobFactory.newJob((String)"SaldoReq", (HBCIPassportInternal)dialog.getPassport(), (MsgGen)dialog.getKernel().getMsgGen());
            balanceJob.setParam("my", account);
            dialog.addTask(balanceJob);
            AbstractHBCIJob bookingsJob = HBCIJobFactory.newJob((String)"KUmsAll", (HBCIPassportInternal)dialog.getPassport(), (MsgGen)dialog.getKernel().getMsgGen());
            bookingsJob.setParam("my", account);
            if (bankAccount.getLastSync() != null) {
                bookingsJob.setParam("startdate", Date.from(bankAccount.getLastSync().atZone(ZoneId.systemDefault()).toInstant()));
            }
            dialog.addTask(bookingsJob);
            AbstractHBCIJob standingOrdersJob = HBCIJobFactory.newJob((String)"DauerSEPAList", (HBCIPassportInternal)dialog.getPassport(), (MsgGen)dialog.getKernel().getMsgGen());
            standingOrdersJob.setParam("src", account);
            if (standingOrdersJob.getHBCICode() == null) {
                LOG.warn("GV DauerSEPAList not supported");
            } else {
                dialog.addTask(standingOrdersJob);
            }
            HBCIExecStatus status = dialog.execute(true);
            if (!status.isOK()) {
                LOG.error("Status of SaldoReq+KUmsAll+DauerSEPAList batch job not OK " + status);
            }
            if (bookingsJob.getJobResult().getJobStatus().hasErrors()) {
                LOG.error("Bookings job not OK ");
                throw new HBCI_Exception(bookingsJob.getJobResult().getJobStatus().getErrorString());
            }
            if (((HbciPassport)dialog.getPassport()).getState().isPresent()) {
                bankAccess.setHbciPassportState(((HbciPassport)dialog.getPassport()).getState().get().toJson());
            }
            List<Booking> bookings = HbciMapping.createBookings((GVRKUms)bookingsJob.getJobResult());
            List<StandingOrder> standingOrders = HbciMapping.createStandingOrders((GVRDauerList)standingOrdersJob.getJobResult());
            ArrayList bookingList = bookings.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<Booking>(Comparator.comparing(Booking::getExternalId))), ArrayList::new));
            bookingList.forEach(booking -> {
                booking.setCreditorId(Utils.extractCreditorId((String)booking.getUsage()));
                booking.setMandateReference(Utils.extractMandateReference((String)booking.getUsage()));
            });
            this.updateTanTransportTypes(bankAccess, (HbciPassport)dialog.getPassport());
            return LoadBookingsResponse.builder().bookings((List)bookingList).bankAccountBalance(HbciMapping.createBalance((GVRSaldoReq)balanceJob.getJobResult())).standingOrders(standingOrders).build();
        }
        catch (HBCI_Exception e) {
            this.handleHbciException(e);
            return null;
        }
    }

    public void createPayment(BankApiUser bankApiUser, BankAccess bankAccess, String bankCode, BankAccount bankAccount, String pin, final Payment payment) {
        final HbciTanSubmit hbciTanSubmit = HbciTanSubmit.builder().build();
        HBCIDialog dialog = this.createDialog(bankAccess, bankCode, new HbciCallback(){

            @Override
            public boolean tanCallback(HBCIPassport passport, GVTAN2Step hktan) {
                return Hbci4JavaBanking.this.updateTanSubmit((HbciPassport)passport, hktan, hbciTanSubmit, payment);
            }
        }, pin);
        try {
            Konto src = dialog.getPassport().getAccount(bankAccount.getAccountNumber());
            Konto dst = new Konto();
            dst.name = payment.getReceiver();
            dst.bic = payment.getReceiverBic();
            dst.iban = payment.getReceiverIban();
            Value value = new Value(payment.getAmount());
            AbstractHBCIJob uebSEPA = HBCIJobFactory.newJob((String)"UebSEPA", (HBCIPassportInternal)dialog.getPassport(), (MsgGen)dialog.getKernel().getMsgGen());
            uebSEPA.setParam("src", src);
            uebSEPA.setParam("dst", dst);
            uebSEPA.setParam("btg", value);
            uebSEPA.setParam("usage", payment.getPurpose());
            dialog.addTask(uebSEPA);
            HBCIExecStatus status = dialog.execute(true);
            if (!status.isOK()) {
                throw new PaymentException(status.getDialogStatus().getErrorString());
            }
            if (((HbciPassport)dialog.getPassport()).getState().isPresent()) {
                bankAccess.setHbciPassportState(((HbciPassport)dialog.getPassport()).getState().get().toJson());
            }
            hbciTanSubmit.setDialogId(dialog.getDialogID());
            hbciTanSubmit.setMsgNum(dialog.getMsgnum());
            payment.setTanSubmitExternal((Object)hbciTanSubmit);
        }
        catch (HBCI_Exception e) {
            this.handleHbciException(e);
        }
    }

    private boolean updateTanSubmit(HbciPassport passport, GVTAN2Step hktan, HbciTanSubmit hbciTanSubmit, Payment payment) {
        try {
            hbciTanSubmit.setGvTanSubmit(HbciGVTanSubmit.builder().properties(OBJECT_MAPPER.writeValueAsString((Object)hktan.getLowlevelParams())).build());
            hbciTanSubmit.setHbciPassport(OBJECT_MAPPER.writeValueAsString((Object)passport.clone()));
            Object pintan_challenge = passport.getPersistentData("pintan_challenge");
            if (pintan_challenge != null) {
                payment.setPaymentChallenge(PaymentChallenge.builder().title(pintan_challenge.toString()).build());
            }
            return true;
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public void submitPayment(Payment payment, String tan) {
        HbciPassport hbciPassport;
        HbciTanSubmit hbciTanSubmit = (HbciTanSubmit)payment.getTanSubmitExternal();
        try {
            hbciPassport = (HbciPassport)((Object)OBJECT_MAPPER.readValue(hbciTanSubmit.getHbciPassport(), HbciPassport.class));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        hbciPassport.getUPD().put("_fetchedMetaInfo", new Date());
        HBCIDialog hbciDialog = new HBCIDialog((HBCIPassportInternal)hbciPassport);
        hbciDialog.setDialogid(hbciTanSubmit.getDialogId());
        hbciDialog.setMsgnum(hbciTanSubmit.getMsgNum());
        try {
            GVTAN2Step hktan = (GVTAN2Step)HBCIJobFactory.newJob((String)"TAN2Step", (HBCIPassportInternal)hbciDialog.getPassport(), (MsgGen)hbciDialog.getKernel().getMsgGen());
            hktan.setLowlevelParams((Properties)OBJECT_MAPPER.readValue(hbciTanSubmit.getGvTanSubmit().getProperties(), Properties.class));
            ((List)hbciDialog.getMessages().get(hbciDialog.getMessages().size() - 1)).add(hktan);
        }
        catch (HBCI_Exception e) {
            this.handleHbciException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean bankSupported(String bankCode) {
        BankInfo bankInfo = HBCIUtils.getBankInfo((String)bankCode);
        return bankInfo != null && bankInfo.getPinTanVersion() != null;
    }

    private void updateTanTransportTypes(BankAccess bankAccess, HbciPassport hbciPassport) {
        if (bankAccess.getTanTransportTypes() == null) {
            bankAccess.setTanTransportTypes(new HashMap());
        }
        bankAccess.getTanTransportTypes().put(this.bankApi(), new ArrayList());
        if (hbciPassport.getUPD() != null) {
            hbciPassport.getAllowedTwostepMechanisms().forEach(id -> {
                Properties properties = (Properties)hbciPassport.getTwostepMechanisms().get(id);
                if (properties != null) {
                    ((List)bankAccess.getTanTransportTypes().get(this.bankApi())).add(TanTransportType.builder().id(id).name(properties.getProperty("name") != null ? properties.getProperty("name") : null).medium(hbciPassport.getUPD().getProperty("tanmedia.names")).build());
                } else {
                    LOG.warn("unable find transport type {} for bank code {}", id, (Object)bankAccess.getBankCode());
                }
            });
        } else {
            LOG.warn("missing passport upd, unable find transport types or bank code {}", (Object)bankAccess.getBankCode());
        }
    }

    private HBCIDialog createDialog(BankAccess bankAccess, String bankCode, HbciCallback callback, String pin) {
        Properties properties = new Properties();
        properties.put("kernel.rewriter", "InvalidSegment,WrongStatusSegOrder,WrongSequenceNumbers,MissingMsgRef,HBCIVersion,SigIdLeadingZero,InvalidSuppHBCIVersion,SecTypeTAN,KUmsDelimiters,KUmsEmptyBDateSets");
        properties.put("log.loglevel.default", "2");
        properties.put("default.hbciversion", "FinTS3");
        properties.put("client.passport.PinTan.checkcert", "1");
        properties.put("client.passport.PinTan.init", "1");
        properties.put("client.errors.ignoreJobNotSupported", "yes");
        properties.put("client.passport.country", "DE");
        properties.put("client.passport.blz", bankCode != null ? bankCode : bankAccess.getBankCode());
        properties.put("client.passport.customerId", bankAccess.getBankLogin());
        properties.put("client.errors.ignoreCryptErrors", "yes");
        if (StringUtils.isNotBlank((CharSequence)bankAccess.getBankLogin2())) {
            properties.put("client.passport.userId", bankAccess.getBankLogin2());
        }
        HbciPassport passport = new HbciPassport(bankAccess.getHbciPassportState(), properties, callback);
        passport.setPIN(pin);
        return new HBCIDialog((HBCIPassportInternal)passport);
    }

    private void handleHbciException(HBCI_Exception e) throws InvalidPinException {
        Throwable processException = e;
        while (processException.getCause() != null && !(processException.getCause() instanceof InvalidPinException)) {
            processException = processException.getCause();
        }
        if (processException.getCause() != null && processException.getCause() instanceof InvalidPinException) {
            throw (InvalidPinException)processException.getCause();
        }
        throw e;
    }
}

