/*
 * Decompiled with CFR 0.152.
 */
package hbci4java;

import com.fasterxml.jackson.databind.ObjectMapper;
import hbci4java.HbciCallback;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.StringTokenizer;
import org.kapott.hbci.callback.HBCICallback;
import org.kapott.hbci.exceptions.HBCI_Exception;
import org.kapott.hbci.manager.HBCIUtils;
import org.kapott.hbci.manager.LogFilter;
import org.kapott.hbci.passport.HBCIPassport;
import org.kapott.hbci.passport.HBCIPassportPinTanNoFile;

public class HbciPassport
extends HBCIPassportPinTanNoFile {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private Optional<State> state = Optional.empty();

    public HbciPassport() {
        super(null, null, null);
    }

    public HbciPassport(String passportState, Properties properties, HbciCallback hbciCallback, Object initObject) {
        super(properties, (HBCICallback)(hbciCallback != null ? hbciCallback : new HbciCallback()), initObject);
        if (passportState != null) {
            this.state = Optional.of(State.readJson(passportState));
            this.state.get().apply(this);
        }
    }

    public Optional<State> getState() {
        return this.state;
    }

    public byte[] hash(byte[] bytes) {
        return new byte[0];
    }

    public byte[] sign(byte[] bytes) {
        try {
            if (this.getPIN() == null) {
                StringBuffer s = new StringBuffer();
                this.callback.callback((HBCIPassport)this, 16, HBCIUtils.getLocMsg((String)"CALLB_NEED_PTPIN"), 1, s);
                if (s.length() == 0) {
                    throw new HBCI_Exception(HBCIUtils.getLocMsg((String)"EXCMSG_PINZERO"));
                }
                this.setPIN(s.toString());
                LogFilter.getInstance().addSecretData(this.getPIN(), "X", 1);
            }
            String tan = "";
            String pintanMethod = this.getCurrentTANMethod(false);
            if (pintanMethod.equals("999")) {
                HBCIUtils.log((String)"onestep method - checking GVs to decide whether or not we need a TAN", (int)4);
                String codes = this.collectSegCodes(new String(bytes, "ISO-8859-1"));
                StringTokenizer tok = new StringTokenizer(codes, "|");
                while (tok.hasMoreTokens()) {
                    String code = tok.nextToken();
                    String info = this.getPinTanInfo(code);
                    if (info.equals("J")) {
                        HBCIUtils.log((String)("the job with the code " + code + " needs a TAN"), (int)4);
                        if (tan.length() == 0) {
                            StringBuffer callbackReturn = new StringBuffer();
                            this.getCallback().callback((HBCIPassport)this, 17, HBCIUtils.getLocMsg((String)"CALLB_NEED_PTTAN"), 2, callbackReturn);
                            if (callbackReturn.length() == 0) {
                                throw new HBCI_Exception(HBCIUtils.getLocMsg((String)"EXCMSG_TANZERO"));
                            }
                            tan = callbackReturn.toString();
                            continue;
                        }
                        HBCIUtils.log((String)"there should be only one job that needs a TAN!", (int)2);
                        continue;
                    }
                    if (info.equals("N")) {
                        HBCIUtils.log((String)("the job with the code " + code + " does not need a TAN"), (int)4);
                        continue;
                    }
                    if (info.length() != 0) continue;
                    HBCIUtils.log((String)("the job with the code " + code + " seems not to be allowed with PIN/TAN"), (int)2);
                }
            } else {
                HBCIUtils.log((String)"twostep method - checking passport(challenge) to decide whether or not we need a TAN", (int)4);
                Properties secmechInfo = this.getCurrentSecMechInfo();
                String challenge = (String)this.getPersistentData("pintan_challenge");
                this.setPersistentData("pintan_challenge", null);
                if (challenge == null) {
                    HBCIUtils.log((String)"will not sign with a TAN, because there is no challenge", (int)4);
                } else {
                    HBCIUtils.log((String)"found challenge in passport, so we ask for a TAN", (int)4);
                    StringBuffer s = new StringBuffer();
                    this.callback.callback((HBCIPassport)this, 17, secmechInfo.getProperty("name") + " " + secmechInfo.getProperty("inputinfo") + ": " + challenge, 2, s);
                    if (s.length() == 0) {
                        throw new HBCI_Exception(HBCIUtils.getLocMsg((String)"EXCMSG_TANZERO"));
                    }
                    tan = s.toString();
                }
            }
            if (tan.length() != 0) {
                LogFilter.getInstance().addSecretData(tan, "X", 1);
            }
            return (this.getPIN() + "|" + tan).getBytes("ISO-8859-1");
        }
        catch (Exception ex) {
            throw new HBCI_Exception("*** signing failed", (Throwable)ex);
        }
    }

    public boolean verify(byte[] bytes, byte[] bytes1) {
        return true;
    }

    public byte[][] encrypt(byte[] bytes) {
        try {
            byte padLength = bytes[bytes.length - 1];
            byte[] encrypted = new String(bytes, 0, bytes.length - padLength, "ISO-8859-1").getBytes("ISO-8859-1");
            return new byte[][]{new byte[8], encrypted};
        }
        catch (Exception ex) {
            throw new HBCI_Exception("*** encrypting message failed", (Throwable)ex);
        }
    }

    public byte[] decrypt(byte[] bytes, byte[] bytes1) {
        try {
            return new String(new String(bytes1, "ISO-8859-1") + '\u0001').getBytes("ISO-8859-1");
        }
        catch (Exception ex) {
            throw new HBCI_Exception("*** decrypting of message failed", (Throwable)ex);
        }
    }

    public void resetPassphrase() {
    }

    public void saveChanges() {
        this.state = Optional.of(new State(this, this.getState()));
    }

    public HbciPassport clone() {
        HbciPassport passport = new HbciPassport(null, this.getProperties(), null, null);
        passport.setCountry(this.getCountry());
        passport.setHost(this.getHost());
        passport.setPort(this.getPort());
        passport.setUserId(this.getUserId());
        passport.setSysId(this.getSysId());
        passport.setBPD(this.getBPD());
        passport.setUPD(this.getUPD());
        passport.setHBCIVersion(this.getHBCIVersion());
        passport.setCustomerId(this.getCustomerId());
        passport.setFilterType(this.getFilterType());
        passport.setAllowedTwostepMechanisms(this.getAllowedTwostepMechanisms());
        passport.setCurrentTANMethod(this.getCurrentTANMethod(false));
        passport.setPIN(this.getPIN());
        passport.setPersistentData(this.getPersistentData());
        passport.unsetComm();
        passport.setCallback(null);
        return passport;
    }

    public static class State {
        public String country;
        public String host;
        public int port;
        public String userId;
        public String sysId;
        public Properties bpd;
        public Properties upd;
        public String hbciVersion;
        public String customerId;
        public String filterType;
        public List<String> allowedTwostepMechanisms;
        public String currentTANMethod;

        State() {
        }

        public State(HbciPassport passport) {
            this(passport, null);
        }

        public State(HbciPassport passport, Optional<State> optionalOldState) {
            this.country = passport.getCountry();
            this.host = passport.getHost();
            this.port = passport.getPort();
            this.userId = passport.getUserId();
            this.sysId = passport.getSysId();
            this.hbciVersion = passport.getHBCIVersion();
            this.customerId = passport.getCustomerId();
            this.filterType = passport.getFilterType();
            this.allowedTwostepMechanisms = passport.getAllowedTwostepMechanisms();
            this.currentTANMethod = passport.getCurrentTANMethod(false);
            optionalOldState.ifPresent(oldState -> {
                this.bpd = State.mergeProperties(oldState.bpd, passport.getBPD());
                this.upd = State.mergeProperties(oldState.upd, passport.getUPD());
            });
        }

        private static Properties mergeProperties(Properties oldP, Properties newP) {
            if (oldP == null && newP == null) {
                return null;
            }
            Properties result = new Properties();
            if (oldP != null) {
                result.putAll((Map<?, ?>)oldP);
            }
            if (newP != null) {
                result.putAll((Map<?, ?>)newP);
            }
            return result;
        }

        public void apply(HbciPassport passport) {
            passport.setCountry(this.country);
            passport.setHost(this.host);
            passport.setPort(this.port);
            passport.setUserId(this.userId);
            passport.setSysId(this.sysId);
            passport.setBPD(this.bpd == null ? null : (Properties)this.bpd.clone());
            passport.setUPD(this.upd == null ? null : (Properties)this.upd.clone());
            passport.setHBCIVersion(this.hbciVersion);
            passport.setCustomerId(this.customerId);
            passport.setFilterType(this.filterType);
            passport.setAllowedTwostepMechanisms(new ArrayList<String>(this.allowedTwostepMechanisms));
            passport.setCurrentTANMethod(this.currentTANMethod);
        }

        public String toJson() {
            try {
                return OBJECT_MAPPER.writeValueAsString((Object)this);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public static State readJson(String s) {
            try {
                return (State)OBJECT_MAPPER.readValue(s, State.class);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

