/*
 * Decompiled with CFR 0.152.
 */
package hbci4java;

import domain.BankAccess;
import domain.BankAccount;
import domain.BankApi;
import domain.BankApiUser;
import domain.Booking;
import hbci4java.HbciFactory;
import hbci4java.HbciPassport;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.kapott.hbci.GV.HBCIJob;
import org.kapott.hbci.GV_Result.GVRKUms;
import org.kapott.hbci.GV_Result.GVRSaldoReq;
import org.kapott.hbci.manager.BankInfo;
import org.kapott.hbci.manager.HBCIHandler;
import org.kapott.hbci.manager.HBCIUtils;
import org.kapott.hbci.passport.HBCIPassport;
import org.kapott.hbci.status.HBCIExecStatus;
import org.kapott.hbci.structures.Konto;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import spi.OnlineBankingService;

public class Hbci4JavaBanking
implements OnlineBankingService {
    private static final Logger LOG = LoggerFactory.getLogger(Hbci4JavaBanking.class);

    public Hbci4JavaBanking() {
        try {
            HBCIUtils.refreshBLZList((InputStream)HBCIUtils.class.getClassLoader().getResource("blz.properties").openStream());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public BankApi bankApiIdentifier() {
        return BankApi.HBCI;
    }

    public boolean userRegistrationRequired() {
        return false;
    }

    public BankApiUser registerUser(String uid) {
        return null;
    }

    public boolean bookingsCategorized() {
        return false;
    }

    public List<BankAccount> loadBankAccounts(BankApiUser bankApiUser, BankAccess bankAccess, String pin) {
        LOG.info("Loading Account list for access {}", (Object)bankAccess.getBankCode());
        HbciPassport hbciPassport = this.createPassport(bankAccess, pin);
        try (HBCIHandler handle = new HBCIHandler(hbciPassport.getHBCIVersion(), (HBCIPassport)hbciPassport);){
            bankAccess.setBankName(hbciPassport.getInstName());
            ArrayList<BankAccount> hbciAccounts = new ArrayList<BankAccount>();
            for (Konto konto : hbciPassport.getAccounts()) {
                hbciAccounts.add(HbciFactory.toBankAccount(konto));
            }
            if (hbciPassport.getState().isPresent()) {
                bankAccess.setPassportState(hbciPassport.getState().get().toJson());
            }
            handle.close();
            ArrayList<BankAccount> arrayList = hbciAccounts;
            return arrayList;
        }
    }

    public List<Booking> loadBookings(BankApiUser bankApiUser, BankAccess bankAccess, BankAccount bankAccount, String pin) {
        HbciPassport hbciPassport = this.createPassport(bankAccess, pin);
        try (HBCIHandler handle = new HBCIHandler(hbciPassport.getHBCIVersion(), (HBCIPassport)hbciPassport);){
            Konto account = hbciPassport.getAccount(bankAccount.getNumberHbciAccount());
            HBCIJob balanceJob = handle.newJob("SaldoReq");
            balanceJob.setParam("my", account);
            balanceJob.addToQueue();
            HBCIJob bookingsJob = handle.newJob("KUmsAll");
            bookingsJob.setParam("my", account);
            bookingsJob.addToQueue();
            HBCIExecStatus status = handle.execute();
            if (!status.isOK()) {
                LOG.error("Status of SaldoReq+KUmsAll batch job not OK " + status);
            }
            if (hbciPassport.getState().isPresent()) {
                bankAccess.setPassportState(hbciPassport.getState().get().toJson());
            }
            bankAccount.setBankAccountBalance(HbciFactory.createBalance((GVRSaldoReq)balanceJob.getJobResult()));
            List<Booking> list = HbciFactory.createBookings((GVRKUms)bookingsJob.getJobResult());
            return list;
        }
    }

    public boolean bankSupported(String bankCode) {
        BankInfo bankInfo = HBCIUtils.getBankInfo((String)bankCode);
        return bankInfo != null && bankInfo.getPinTanVersion() != null;
    }

    private HbciPassport createPassport(BankAccess bankAccess, String pin) {
        Properties properties = new Properties();
        properties.put("kernel.rewriter", "InvalidSegment,WrongStatusSegOrder,WrongSequenceNumbers,MissingMsgRef,HBCIVersion,SigIdLeadingZero,InvalidSuppHBCIVersion,SecTypeTAN,KUmsDelimiters,KUmsEmptyBDateSets");
        properties.put("log.loglevel.default", "2");
        properties.put("default.hbciversion", "FinTS3");
        properties.put("client.passport.PinTan.checkcert", "1");
        properties.put("client.passport.PinTan.init", "1");
        properties.put("client.passport.country", "DE");
        properties.put("client.passport.blz", bankAccess.getBankCode());
        properties.put("client.passport.customerId", bankAccess.getBankLogin());
        HbciPassport passport = new HbciPassport(bankAccess.getPassportState(), properties, null);
        passport.setPIN(pin);
        return passport;
    }
}

