/*
 * Decompiled with CFR 0.152.
 */
package hbci4java;

import domain.BankAccount;
import domain.BankAccountBalance;
import domain.BankAccountType;
import domain.BankApi;
import domain.Booking;
import domain.Cycle;
import domain.StandingOrder;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.lang3.text.WordUtils;
import org.kapott.hbci.GV_Result.GVRDauerList;
import org.kapott.hbci.GV_Result.GVRKUms;
import org.kapott.hbci.GV_Result.GVRSaldoReq;
import org.kapott.hbci.structures.Konto;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HbciMapping {
    private static final Logger LOG = LoggerFactory.getLogger(HbciMapping.class);

    public static BankAccountBalance createBalance(GVRSaldoReq gvSaldoReq) {
        GVRSaldoReq.Info[] infos;
        BankAccountBalance result = new BankAccountBalance();
        if (gvSaldoReq.isOK() && (infos = gvSaldoReq.getEntries()).length > 0) {
            if (infos[0] != null && infos[0].ready != null && infos[0].ready.value != null) {
                result.setReadyHbciBalance(infos[0].ready.value.getBigDecimalValue().setScale(2));
            }
            if (infos[0] != null && infos[0].available != null) {
                result.setAvailableHbciBalance(infos[0].available.getBigDecimalValue().setScale(2));
            }
            if (infos[0] != null && infos[0].kredit != null) {
                result.setCreditHbciBalance(infos[0].kredit.getBigDecimalValue().setScale(2));
            }
            if (infos[0] != null && infos[0].unready != null && infos[0].unready.value != null) {
                result.setUnreadyHbciBalance(infos[0].unready.value.getBigDecimalValue().setScale(2));
            }
            if (infos[0] != null && infos[0].used != null) {
                result.setUsedHbciBalance(infos[0].used.getBigDecimalValue().setScale(2));
            }
        }
        return result;
    }

    public static List<StandingOrder> createStandingOrders(GVRDauerList gvrDauerList) {
        GVRDauerList.Dauer[] lines = gvrDauerList.getEntries();
        ArrayList<StandingOrder> standingOrders = new ArrayList<StandingOrder>();
        for (int i = 0; i < lines.length; ++i) {
            GVRDauerList.Dauer line = lines[i];
            StandingOrder auftrag = new StandingOrder();
            if (line.firstdate != null) {
                auftrag.setFirstExecutionDate(line.firstdate.toInstant().atZone(ZoneId.systemDefault()).toLocalDate());
            }
            if (line.lastdate != null) {
                auftrag.setLastExecutionDate(line.lastdate.toInstant().atZone(ZoneId.systemDefault()).toLocalDate());
            }
            auftrag.setAmount(line.value.getBigDecimalValue());
            auftrag.setOrderId(line.orderid);
            auftrag.setOtherAccount(HbciMapping.toBankAccount(line.other));
            auftrag.setUsage(HbciMapping.getUsage(Arrays.asList(line.usage)));
            auftrag.setExecutionDay(line.execday);
            Cycle cycle = null;
            if (!StringUtils.endsWithIgnoreCase((CharSequence)"M", (CharSequence)line.timeunit)) {
                cycle = Cycle.WEEKLY;
            } else {
                switch (line.turnus) {
                    case 1: {
                        cycle = Cycle.MONTHLY;
                        break;
                    }
                    case 2: {
                        cycle = Cycle.TWO_MONTHLY;
                        break;
                    }
                    case 3: {
                        cycle = Cycle.QUARTERLY;
                        break;
                    }
                    case 6: {
                        cycle = Cycle.HALF_YEARLY;
                        break;
                    }
                    case 12: {
                        cycle = Cycle.YEARLY;
                    }
                }
            }
            auftrag.setCycle(cycle);
            standingOrders.add(auftrag);
        }
        return standingOrders;
    }

    public static List<Booking> createBookings(GVRKUms gvrkUms) {
        ArrayList<Booking> bookings = new ArrayList<Booking>();
        if (gvrkUms.isOK()) {
            List lines = gvrkUms.getFlatData();
            for (GVRKUms.UmsLine line : lines) {
                if (line == null) continue;
                if (line.value == null) {
                    LOG.warn("Booking has no amount, skipping: %s", (Object)line);
                    continue;
                }
                if (line.bdate == null) {
                    LOG.warn("Booking has no booking date, skipping: %s", (Object)line);
                    continue;
                }
                Booking booking = new Booking();
                booking.setBankApi(BankApi.HBCI);
                booking.setBookingDate(line.bdate.toInstant().atZone(ZoneId.systemDefault()).toLocalDate());
                booking.setAmount(line.value.getBigDecimalValue().setScale(2));
                booking.setAdditional(line.additional);
                booking.setAddkey(line.addkey);
                booking.setCustomerRef(line.customerref);
                booking.setInstRef(line.instref);
                booking.setReversal(line.isStorno);
                booking.setSepa(line.isSepa);
                booking.setPrimanota(line.primanota);
                booking.setText(line.text);
                booking.setValutaDate(line.valuta.toInstant().atZone(ZoneId.systemDefault()).toLocalDate());
                if (line.saldo != null && line.saldo.value != null) {
                    booking.setBalance(line.saldo.value.getBigDecimalValue().setScale(2));
                }
                if (line.charge_value != null) {
                    booking.setChargeValue(line.charge_value.getBigDecimalValue().setScale(2));
                }
                if (line.orig_value != null) {
                    booking.setOrigValue(line.orig_value.getBigDecimalValue().setScale(2));
                }
                if (line.other != null) {
                    booking.setOtherAccount(HbciMapping.toBankAccount(line.other));
                }
                booking.setExternalId("B-" + line.bdate.getTime() + "_" + line.value.getLongValue() + "_" + line.saldo.value.getLongValue());
                booking.setUsage(HbciMapping.getUsage(line.usage.size() > 0 ? line.usage : HbciMapping.splitEqually(line.additional, 27)));
                bookings.add(0, booking);
            }
        }
        LOG.debug("Received {} bookings: {}", (Object)bookings.size(), bookings);
        return bookings;
    }

    public static BankAccount toBankAccount(Konto konto) {
        BankAccount bankAccount = new BankAccount();
        bankAccount.accountNumber(konto.number);
        bankAccount.bic(konto.bic);
        bankAccount.blz(konto.blz);
        bankAccount.country(konto.country);
        bankAccount.currency(konto.curr);
        bankAccount.iban(konto.iban);
        bankAccount.owner((konto.name + (konto.name2 != null ? konto.name2 : "")).trim());
        bankAccount.name(konto.type);
        bankAccount.type(BankAccountType.fromHbciType((Integer)NumberUtils.toInt((String)konto.acctype)));
        return bankAccount;
    }

    private static String getUsage(List<String> lines) {
        lines = HbciMapping.rewrap(35, lines);
        String verwendungszweck = "";
        int lineIndex = 0;
        for (String line : lines) {
            String[] words;
            int wordIndex = 0;
            for (String word : words = StringUtils.split((String)line, null, (int)0)) {
                verwendungszweck = verwendungszweck + word;
                verwendungszweck = verwendungszweck + (wordIndex + 1 < words.length ? " " : "");
                ++wordIndex;
            }
            verwendungszweck = verwendungszweck + (lineIndex == 0 ? " " : "");
            ++lineIndex;
        }
        return WordUtils.capitalizeFully((String)verwendungszweck.trim(), (char[])new char[]{' ', '/'});
    }

    private static List<String> clean(boolean trim, List<String> lines) {
        ArrayList<String> result = new ArrayList<String>();
        if (lines == null || lines.size() == 0) {
            return result;
        }
        for (String line : lines) {
            if (line == null) continue;
            if (trim) {
                line = line.trim();
            }
            if (line.length() <= 0) continue;
            result.add(line);
        }
        return result;
    }

    public static List<String> splitEqually(String text, int size) {
        if (text == null || text.length() == 0) {
            return new ArrayList<String>();
        }
        ArrayList<String> ret = new ArrayList<String>((text.length() + size - 1) / size);
        for (int start = 0; start < text.length(); start += size) {
            ret.add(text.substring(start, Math.min(text.length(), start + size)));
        }
        return ret;
    }

    private static List<String> rewrap(int limit, List<String> lines) {
        if (lines == null || lines.size() == 0) {
            return lines;
        }
        boolean found = false;
        for (String s : lines) {
            if (s == null || s.length() <= limit) continue;
            found = true;
            break;
        }
        if (!found) {
            return lines;
        }
        List<String> l = HbciMapping.clean(true, lines);
        StringBuilder sb = new StringBuilder();
        l.forEach(sb::append);
        String result = sb.toString();
        return HbciMapping.splitEqually(result, limit);
    }
}

