/*
 * Decompiled with CFR 0.152.
 */
package hbci4java;

import domain.Bank;
import domain.BankAccess;
import domain.BankAccount;
import domain.BankApi;
import domain.BankApiUser;
import domain.Booking;
import domain.StandingOrder;
import exception.InvalidPinException;
import hbci4java.HbciFactory;
import hbci4java.HbciPassport;
import java.io.InputStream;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Properties;
import java.util.TreeSet;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.kapott.hbci.GV.HBCIJob;
import org.kapott.hbci.GV_Result.GVRDauerList;
import org.kapott.hbci.GV_Result.GVRKUms;
import org.kapott.hbci.GV_Result.GVRSaldoReq;
import org.kapott.hbci.exceptions.HBCI_Exception;
import org.kapott.hbci.exceptions.ProcessException;
import org.kapott.hbci.manager.BankInfo;
import org.kapott.hbci.manager.HBCIHandler;
import org.kapott.hbci.manager.HBCIUtils;
import org.kapott.hbci.passport.HBCIPassport;
import org.kapott.hbci.status.HBCIExecStatus;
import org.kapott.hbci.status.HBCIMsgStatus;
import org.kapott.hbci.status.HBCIRetVal;
import org.kapott.hbci.structures.Konto;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import spi.OnlineBankingService;
import utils.Utils;

public class Hbci4JavaBanking
implements OnlineBankingService {
    private static final Logger LOG = LoggerFactory.getLogger(Hbci4JavaBanking.class);

    public Hbci4JavaBanking() {
        try (InputStream inputStream = HBCIUtils.class.getClassLoader().getResource("blz.properties").openStream();){
            HBCIUtils.refreshBLZList((InputStream)inputStream);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public BankApi bankApi() {
        return BankApi.HBCI;
    }

    public boolean userRegistrationRequired() {
        return false;
    }

    public BankApiUser registerUser(String uid) {
        return null;
    }

    public void removeUser(BankApiUser bankApiUser) {
    }

    public Bank getBankLoginSettings(String bankCode) {
        return null;
    }

    public boolean bookingsCategorized() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<BankAccount> loadBankAccounts(BankApiUser bankApiUser, BankAccess bankAccess, String bankCode, String pin, boolean storePin) {
        LOG.info("Loading Account list for access {}", (Object)bankAccess.getBankCode());
        HbciPassport hbciPassport = this.createPassport(bankAccess, bankCode, pin);
        try (HBCIHandler handle = null;){
            handle = new HBCIHandler(hbciPassport.getHBCIVersion(), (HBCIPassport)hbciPassport);
            bankAccess.setBankName(hbciPassport.getInstName());
            ArrayList<BankAccount> hbciAccounts = new ArrayList<BankAccount>();
            for (Konto konto : hbciPassport.getAccounts()) {
                BankAccount bankAccount = HbciFactory.toBankAccount(konto);
                bankAccount.externalId(this.bankApi(), UUID.randomUUID().toString());
                bankAccount.bankName(bankAccess.getBankName());
                hbciAccounts.add(bankAccount);
            }
            if (hbciPassport.getState().isPresent()) {
                bankAccess.setHbciPassportState(hbciPassport.getState().get().toJson());
            }
            handle.close();
            ArrayList<BankAccount> arrayList = hbciAccounts;
            return arrayList;
        }
    }

    public void removeBankAccount(BankAccount bankAccount, BankApiUser bankApiUser) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Booking> loadBookings(BankApiUser bankApiUser, BankAccess bankAccess, String bankCode, BankAccount bankAccount, String pin) {
        HbciPassport hbciPassport = this.createPassport(bankAccess, bankCode, pin);
        try (HBCIHandler handle = new HBCIHandler(hbciPassport.getHBCIVersion(), (HBCIPassport)hbciPassport);){
            Konto account = hbciPassport.getAccount(bankAccount.getAccountNumber());
            HBCIJob balanceJob = handle.newJob("SaldoReq");
            balanceJob.setParam("my", account);
            balanceJob.addToQueue();
            HBCIJob bookingsJob = handle.newJob("KUmsAll");
            bookingsJob.setParam("my", account);
            bookingsJob.addToQueue();
            HBCIJob standingOrdersJob = handle.newJob("DauerSEPAList");
            standingOrdersJob.setParam("src", account);
            standingOrdersJob.addToQueue();
            HBCIExecStatus status = handle.execute();
            if (!status.isOK()) {
                LOG.error("Status of SaldoReq+KUmsAll batch job not OK " + status);
            }
            if (hbciPassport.getState().isPresent()) {
                bankAccess.setHbciPassportState(hbciPassport.getState().get().toJson());
            }
            bankAccount.setBankAccountBalance(HbciFactory.createBalance((GVRSaldoReq)balanceJob.getJobResult()));
            List<Booking> bookings = HbciFactory.createBookings((GVRKUms)bookingsJob.getJobResult());
            List<StandingOrder> standingOrders = HbciFactory.createStandingOrders((GVRDauerList)standingOrdersJob.getJobResult());
            ArrayList bookingList = bookings.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<Booking>(Comparator.comparing(Booking::getExternalId))), ArrayList::new));
            bookingList.forEach(booking -> {
                booking.setCreditorId(Utils.extractCreditorId((String)booking.getUsage()));
                booking.setMandateReference(Utils.extractMandateReference((String)booking.getUsage()));
            });
            bookingList.forEach(booking -> standingOrders.stream().filter(so -> so.getAmount().negate().compareTo(booking.getAmount()) == 0 && Utils.inCycle((LocalDate)booking.getValutaDate(), (int)so.getExecutionDay()) && Utils.usageContains((String)booking.getUsage(), (String)so.getUsage())).findFirst().ifPresent(standingOrder -> booking.setStandingOrder(true)));
            ArrayList arrayList = bookingList;
            return arrayList;
        }
    }

    public boolean bankSupported(String bankCode) {
        BankInfo bankInfo = HBCIUtils.getBankInfo((String)bankCode);
        return bankInfo != null && bankInfo.getPinTanVersion() != null;
    }

    private HbciPassport createPassport(BankAccess bankAccess, String bankCode, String pin) {
        Properties properties = new Properties();
        properties.put("kernel.rewriter", "InvalidSegment,WrongStatusSegOrder,WrongSequenceNumbers,MissingMsgRef,HBCIVersion,SigIdLeadingZero,InvalidSuppHBCIVersion,SecTypeTAN,KUmsDelimiters,KUmsEmptyBDateSets");
        properties.put("log.loglevel.default", "2");
        properties.put("default.hbciversion", "FinTS3");
        properties.put("client.passport.PinTan.checkcert", "1");
        properties.put("client.passport.PinTan.init", "1");
        properties.put("client.passport.country", "DE");
        properties.put("client.passport.blz", bankCode != null ? bankCode : bankAccess.getBankCode());
        properties.put("client.passport.customerId", bankAccess.getBankLogin());
        if (StringUtils.isNotBlank((CharSequence)bankAccess.getBankLogin2())) {
            properties.put("client.passport.userId", bankAccess.getBankLogin2());
        }
        HbciPassport passport = new HbciPassport(bankAccess.getHbciPassportState(), properties, null);
        passport.setPIN(pin);
        return passport;
    }

    private void handleHbciException(HBCI_Exception e) throws InvalidPinException {
        HBCIMsgStatus msgStatus;
        Throwable processException = e;
        while (processException.getCause() != null && !(processException.getCause() instanceof ProcessException)) {
            processException = processException.getCause();
        }
        if (processException.getCause() != null && processException.getCause() instanceof ProcessException && this.isInvalidPIN(msgStatus = ((ProcessException)processException.getCause()).getMsgStatus())) {
            throw new InvalidPinException();
        }
        throw new RuntimeException(e);
    }

    public boolean isInvalidPIN(HBCIMsgStatus msgStatus) {
        ArrayList<HBCIRetVal> retvals = new ArrayList<HBCIRetVal>(Arrays.asList(msgStatus.globStatus.getErrors()));
        retvals.addAll(new ArrayList<HBCIRetVal>(Arrays.asList(msgStatus.segStatus.getErrors())));
        for (HBCIRetVal ret : retvals) {
            if (!ret.code.equals("9931") && !ret.code.equals("9942") && !ret.code.equals("9340")) continue;
            return true;
        }
        return false;
    }
}

