/*
 * Decompiled with CFR 0.152.
 */
package hbci4java;

import com.fasterxml.jackson.databind.ObjectMapper;
import hbci4java.HbciCallback;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.StringTokenizer;
import org.kapott.hbci.callback.HBCICallback;
import org.kapott.hbci.exceptions.HBCI_Exception;
import org.kapott.hbci.manager.HBCIUtils;
import org.kapott.hbci.manager.HBCIUtilsInternal;
import org.kapott.hbci.manager.LogFilter;
import org.kapott.hbci.passport.HBCIPassport;
import org.kapott.hbci.passport.HBCIPassportPinTanNoFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HbciPassport
extends HBCIPassportPinTanNoFile {
    private static final Logger LOG = LoggerFactory.getLogger(HbciPassport.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private State state;

    public HbciPassport(String passportState, Properties properties, Object initObject) {
        super(properties, (HBCICallback)new HbciCallback(), initObject);
        if (passportState != null) {
            this.state = State.readJson(passportState);
            this.state.apply(this);
        }
    }

    public Optional<State> getState() {
        return Optional.ofNullable(this.state);
    }

    public byte[] hash(byte[] bytes) {
        return new byte[0];
    }

    public byte[] sign(byte[] bytes) {
        try {
            if (this.getPIN() == null) {
                StringBuffer s = new StringBuffer();
                HBCIUtilsInternal.getCallback().callback((HBCIPassport)this, 16, HBCIUtilsInternal.getLocMsg((String)"CALLB_NEED_PTPIN"), 1, s);
                if (s.length() == 0) {
                    throw new HBCI_Exception(HBCIUtilsInternal.getLocMsg((String)"EXCMSG_PINZERO"));
                }
                this.setPIN(s.toString());
                LogFilter.getInstance().addSecretData(this.getPIN(), "X", 1);
            }
            String tan = "";
            String pintanMethod = this.getCurrentTANMethod(false);
            if (pintanMethod.equals("999")) {
                HBCIUtils.log((String)"onestep method - checking GVs to decide whether or not we need a TAN", (int)4);
                String codes = this.collectSegCodes(new String(bytes, "ISO-8859-1"));
                StringTokenizer tok = new StringTokenizer(codes, "|");
                while (tok.hasMoreTokens()) {
                    String code = tok.nextToken();
                    String info = this.getPinTanInfo(code);
                    if (info.equals("J")) {
                        HBCIUtils.log((String)("the job with the code " + code + " needs a TAN"), (int)4);
                        if (tan.length() == 0) {
                            StringBuffer s = new StringBuffer();
                            HBCIUtilsInternal.getCallback().callback((HBCIPassport)this, 17, HBCIUtilsInternal.getLocMsg((String)"CALLB_NEED_PTTAN"), 2, s);
                            if (s.length() == 0) {
                                throw new HBCI_Exception(HBCIUtilsInternal.getLocMsg((String)"EXCMSG_TANZERO"));
                            }
                            tan = s.toString();
                            continue;
                        }
                        HBCIUtils.log((String)"there should be only one job that needs a TAN!", (int)2);
                        continue;
                    }
                    if (info.equals("N")) {
                        HBCIUtils.log((String)("the job with the code " + code + " does not need a TAN"), (int)4);
                        continue;
                    }
                    if (info.length() != 0) continue;
                    HBCIUtils.log((String)("the job with the code " + code + " seems not to be allowed with PIN/TAN"), (int)2);
                }
            } else {
                HBCIUtils.log((String)"twostep method - checking passport(challenge) to decide whether or not we need a TAN", (int)4);
                Properties secmechInfo = this.getCurrentSecMechInfo();
                String challenge = (String)this.getPersistentData("pintan_challenge");
                this.setPersistentData("pintan_challenge", null);
                if (challenge == null) {
                    HBCIUtils.log((String)"will not sign with a TAN, because there is no challenge", (int)4);
                } else {
                    HBCIUtils.log((String)"found challenge in passport, so we ask for a TAN", (int)4);
                    StringBuffer s = new StringBuffer();
                    HBCIUtilsInternal.getCallback().callback((HBCIPassport)this, 17, secmechInfo.getProperty("name") + " " + secmechInfo.getProperty("inputinfo") + ": " + challenge, 2, s);
                    if (s.length() == 0) {
                        throw new HBCI_Exception(HBCIUtilsInternal.getLocMsg((String)"EXCMSG_TANZERO"));
                    }
                    tan = s.toString();
                }
            }
            if (tan.length() != 0) {
                LogFilter.getInstance().addSecretData(tan, "X", 1);
            }
            return (this.getPIN() + "|" + tan).getBytes("ISO-8859-1");
        }
        catch (Exception ex) {
            throw new HBCI_Exception("*** signing failed", (Throwable)ex);
        }
    }

    public boolean verify(byte[] bytes, byte[] bytes1) {
        return true;
    }

    public byte[][] encrypt(byte[] bytes) {
        try {
            byte padLength = bytes[bytes.length - 1];
            byte[] encrypted = new String(bytes, 0, bytes.length - padLength, "ISO-8859-1").getBytes("ISO-8859-1");
            return new byte[][]{new byte[8], encrypted};
        }
        catch (Exception ex) {
            throw new HBCI_Exception("*** encrypting message failed", (Throwable)ex);
        }
    }

    public byte[] decrypt(byte[] bytes, byte[] bytes1) {
        try {
            return new String(new String(bytes1, "ISO-8859-1") + '\u0001').getBytes("ISO-8859-1");
        }
        catch (Exception ex) {
            throw new HBCI_Exception("*** decrypting of message failed", (Throwable)ex);
        }
    }

    public void resetPassphrase() {
    }

    public void saveChanges() {
        this.state = new State(this, this.state);
    }

    public static class State {
        public String country;
        public String host;
        public int port;
        public String userId;
        public String sysId;
        public Properties bpd;
        public Properties upd;
        public String hbciVersion;
        public String customerId;
        public String filterType;
        public List<String> allowedTwostepMechanisms;
        public String currentTANMethod;

        State() {
        }

        public State(HbciPassport passport) {
            this(passport, null);
        }

        public State(HbciPassport passport, State oldState) {
            this.country = passport.getCountry();
            this.host = passport.getHost();
            this.port = passport.getPort();
            this.userId = passport.getUserId();
            this.sysId = passport.getSysId();
            this.bpd = State.mergeProperties(oldState == null ? null : oldState.bpd, passport.getBPD());
            this.upd = State.mergeProperties(oldState == null ? null : oldState.upd, passport.getUPD());
            this.hbciVersion = passport.getHBCIVersion();
            this.customerId = passport.getCustomerId();
            this.filterType = passport.getFilterType();
            this.allowedTwostepMechanisms = passport.getAllowedTwostepMechanisms();
            this.currentTANMethod = passport.getCurrentTANMethod(false);
        }

        private static Properties mergeProperties(Properties oldP, Properties newP) {
            if (oldP == null && newP == null) {
                return null;
            }
            Properties result = new Properties();
            if (oldP != null) {
                result.putAll((Map<?, ?>)oldP);
            }
            if (newP != null) {
                result.putAll((Map<?, ?>)newP);
            }
            return result;
        }

        public void apply(HbciPassport passport) {
            passport.setCountry(this.country);
            passport.setHost(this.host);
            passport.setPort(this.port);
            passport.setUserId(this.userId);
            passport.setSysId(this.sysId);
            passport.setBPD(this.bpd == null ? null : (Properties)this.bpd.clone());
            passport.setUPD(this.upd == null ? null : (Properties)this.upd.clone());
            passport.setHBCIVersion(this.hbciVersion);
            passport.setCustomerId(this.customerId);
            passport.setFilterType(this.filterType);
            passport.setAllowedTwostepMechanisms(new ArrayList<String>(this.allowedTwostepMechanisms));
            passport.setCurrentTANMethod(this.currentTANMethod);
        }

        public String toJson() {
            return this.writeJson(this);
        }

        private String writeJson(State state) {
            try {
                return OBJECT_MAPPER.writeValueAsString((Object)state);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public static State readJson(String s) {
            try {
                return (State)OBJECT_MAPPER.readValue(s, State.class);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

