/*
 * Decompiled with CFR 0.152.
 */
package hbci4java;

import java.util.Date;
import org.kapott.hbci.callback.HBCICallback;
import org.kapott.hbci.passport.HBCIPassport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HbciCallback
implements HBCICallback {
    private static final Logger LOG = LoggerFactory.getLogger(HbciCallback.class);

    public void log(String msg, int level, Date date, StackTraceElement trace) {
        String msg2 = this.preprocessLogMsg(msg);
        if (this.shouldPrintTrace(trace)) {
            switch (level) {
                case 1: {
                    LOG.error("Log: {} (at {})", (Object)msg2, (Object)trace);
                    break;
                }
                case 2: {
                    LOG.warn("Log: {} (at {})", (Object)msg2, (Object)trace);
                    break;
                }
                case 3: {
                    LOG.info("Log: {} (at {})", (Object)msg2, (Object)trace);
                    break;
                }
                case 4: {
                    LOG.debug("Log: {} (at {})", (Object)msg2, (Object)trace);
                    break;
                }
                case 5: {
                    LOG.trace("Log: {} (at {})", (Object)msg2, (Object)trace);
                    break;
                }
            }
        } else {
            switch (level) {
                case 1: {
                    LOG.error("Log: {}", (Object)msg2);
                    break;
                }
                case 2: {
                    LOG.warn("Log: {}", (Object)msg2);
                    break;
                }
                case 3: {
                    LOG.info("Log: {}", (Object)msg2);
                    break;
                }
                case 4: {
                    LOG.debug("Log: {}", (Object)msg2);
                    break;
                }
                case 5: {
                    LOG.trace("Log: {}", (Object)msg2);
                    break;
                }
            }
        }
    }

    boolean shouldPrintTrace(StackTraceElement trace) {
        String className = trace.getClassName();
        return !className.startsWith("org.kapott.hbci.");
    }

    private String preprocessLogMsg(String msg) {
        return msg.replaceFirst("(?s)\\n\\s*at org\\.kapott\\.hbci.*", "");
    }

    public void callback(HBCIPassport passport, int reason, String msg, int datatype, StringBuffer retData) {
        switch (reason) {
            case 27: {
                LOG.warn("Callback: reason: {}, message: {}", (Object)reason, (Object)msg);
                String firstTanMethod = retData.toString().substring(0, retData.toString().indexOf(58));
                retData.setLength(0);
                retData.insert(0, firstTanMethod);
                break;
            }
            case 24: 
            case 25: {
                LOG.debug("Callback: reason: {}, message: {}", (Object)reason, (Object)msg);
                break;
            }
            default: {
                LOG.warn("Callback: reason: {}, message: {}", (Object)reason, (Object)msg);
            }
        }
    }

    public void status(HBCIPassport passport, int statusTag, Object[] o) {
        LOG.debug("Status: {} {}, objects: {}", new Object[]{statusTag, this.statusToString(statusTag), o});
    }

    public void status(HBCIPassport passport, int statusTag, Object o) {
        this.status(passport, statusTag, new Object[]{o});
    }

    public boolean useThreadedCallback(HBCIPassport passport, int reason, String msg, int datatype, StringBuffer retData) {
        return false;
    }

    String statusToString(int status) {
        switch (status) {
            case 1: {
                return "STATUS_SEND_TASK";
            }
            case 2: {
                return "STATUS_SEND_TASK_DONE";
            }
            case 3: {
                return "STATUS_INST_BPD_INIT";
            }
            case 4: {
                return "STATUS_INST_BPD_INIT_DONE";
            }
            case 5: {
                return "STATUS_INST_GET_KEYS";
            }
            case 6: {
                return "STATUS_INST_GET_KEYS_DONE";
            }
            case 7: {
                return "STATUS_SEND_KEYS";
            }
            case 8: {
                return "STATUS_SEND_KEYS_DONE";
            }
            case 9: {
                return "STATUS_INIT_SYSID";
            }
            case 10: {
                return "STATUS_INIT_SYSID_DONE";
            }
            case 11: {
                return "STATUS_INIT_UPD";
            }
            case 12: {
                return "STATUS_INIT_UPD_DONE";
            }
            case 13: {
                return "STATUS_LOCK_KEYS";
            }
            case 14: {
                return "STATUS_LOCK_KEYS_DONE";
            }
            case 15: {
                return "STATUS_INIT_SIGID";
            }
            case 16: {
                return "STATUS_INIT_SIGID_DONE";
            }
            case 17: {
                return "STATUS_DIALOG_INIT";
            }
            case 18: {
                return "STATUS_DIALOG_INIT_DONE";
            }
            case 19: {
                return "STATUS_DIALOG_END";
            }
            case 20: {
                return "STATUS_DIALOG_END_DONE";
            }
            case 21: {
                return "STATUS_MSG_CREATE";
            }
            case 22: {
                return "STATUS_MSG_SIGN";
            }
            case 23: {
                return "STATUS_MSG_CRYPT";
            }
            case 24: {
                return "STATUS_MSG_SEND";
            }
            case 25: {
                return "STATUS_MSG_DECRYPT";
            }
            case 26: {
                return "STATUS_MSG_VERIFY";
            }
            case 27: {
                return "STATUS_MSG_RECV";
            }
            case 28: {
                return "STATUS_MSG_PARSE";
            }
            case 29: {
                return "STATUS_SEND_INFOPOINT_DATA";
            }
            case 30: {
                return "STATUS_MSG_RAW_SEND";
            }
            case 31: {
                return "STATUS_MSG_RAW_RECV";
            }
        }
        return "?";
    }
}

