/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.figo;

import de.adorsys.multibanking.domain.Balance;
import de.adorsys.multibanking.domain.BalancesReport;
import de.adorsys.multibanking.domain.BankAccount;
import de.adorsys.multibanking.domain.BankAccountType;
import de.adorsys.multibanking.domain.BankApi;
import de.adorsys.multibanking.domain.Booking;
import de.adorsys.multibanking.domain.ChallengeData;
import de.adorsys.multibanking.domain.Cycle;
import de.adorsys.multibanking.domain.TanTransportType;
import de.adorsys.multibanking.domain.transaction.AbstractScaTransaction;
import de.adorsys.multibanking.domain.transaction.SinglePayment;
import de.adorsys.multibanking.domain.transaction.StandingOrder;
import de.adorsys.multibanking.domain.utils.Utils;
import java.time.ZoneId;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import me.figo.models.Account;
import me.figo.models.Challenge;
import me.figo.models.Payment;
import me.figo.models.TanScheme;
import me.figo.models.Transaction;
import org.apache.commons.lang3.StringUtils;

public class FigoMapping {
    private static final Map<Cycle, String> FIGO_CYCLE = new HashMap<Cycle, String>();
    private static final Map<AbstractScaTransaction.TransactionType, String> FIGO_TRANSFER = new HashMap<AbstractScaTransaction.TransactionType, String>();

    public static StandingOrder mapStandingOrder(me.figo.models.StandingOrder figoStandingOrder) {
        StandingOrder standingOrder = new StandingOrder();
        standingOrder.setOrderId(figoStandingOrder.getStandingOrderId());
        standingOrder.setExecutionDay(figoStandingOrder.getExecutionDay().intValue());
        standingOrder.setAmount(figoStandingOrder.getAmount());
        standingOrder.setUsage(figoStandingOrder.getPurposeText());
        standingOrder.setCycle(Cycle.valueOf((String)figoStandingOrder.getInterval().toString()));
        standingOrder.setOtherAccount(new BankAccount().owner(figoStandingOrder.getName()).accountNumber(figoStandingOrder.getAccountNumber()).blz(figoStandingOrder.getBankCode()).currency(figoStandingOrder.getCurrency()));
        return standingOrder;
    }

    public static BankAccount mapBankAccount(Account account, BankApi bankApi) {
        return new BankAccount().externalId(bankApi, account.getAccountId()).owner(account.getOwner()).accountNumber(account.getAccountNumber()).name(account.getName()).bankName(account.getBankName()).bic(account.getBIC()).blz(account.getBankCode()).iban(account.getIBAN()).type(BankAccountType.fromFigoType((String)account.getType())).balances(new BalancesReport().readyBalance(Balance.builder().amount(account.getBalance().getBalance()).build()));
    }

    public static Booking mapBooking(Transaction transaction, BankApi bankApi) {
        Booking booking = new Booking();
        booking.setExternalId(transaction.getTransactionId());
        booking.setBankApi(bankApi);
        booking.setBookingDate(transaction.getBookingDate().toInstant().atZone(ZoneId.systemDefault()).toLocalDate());
        booking.setValutaDate(transaction.getValueDate().toInstant().atZone(ZoneId.systemDefault()).toLocalDate());
        booking.setAmount(transaction.getAmount());
        booking.setUsage(transaction.getPurposeText());
        booking.setText(transaction.getBookingText());
        booking.setTransactionCode(transaction.getTransactionCode());
        booking.setOtherAccount(FigoMapping.mapBookingAccount(transaction));
        booking.setCreditorId(Utils.extractCreditorId((String)transaction.getPurposeText()));
        booking.setMandateReference(Utils.extractMandateReference((String)transaction.getPurposeText()));
        return booking;
    }

    public static BankAccount mapBookingAccount(Transaction transaction) {
        BankAccount bankAccount = new BankAccount();
        bankAccount.setName(transaction.getName());
        bankAccount.setBankName(transaction.getBankName());
        bankAccount.setCurrency(transaction.getCurrency());
        bankAccount.setAccountNumber(transaction.getAccountNumber());
        bankAccount.setBlz(transaction.getBankCode());
        bankAccount.setIban(Utils.extractIban((String)transaction.getPurposeText()));
        return bankAccount;
    }

    public static TanTransportType mapTanTransportTypes(TanScheme tanScheme) {
        return TanTransportType.builder().id(tanScheme.getTan_scheme_id()).name(tanScheme.getName()).build();
    }

    public static Payment mapToFigoPayment(String accountId, SinglePayment payment) {
        Payment figoPayment = new Payment();
        figoPayment.setAccountId(accountId);
        if (!StringUtils.isEmpty((CharSequence)payment.getReceiverIban())) {
            figoPayment.setIban(payment.getReceiverIban());
        } else {
            figoPayment.setBankCode(payment.getReceiverBankCode());
            figoPayment.setAccountNumber(payment.getReceiverAccountNumber());
        }
        figoPayment.setAmount(payment.getAmount());
        figoPayment.setCurrency(payment.getCurrency());
        figoPayment.setType(FIGO_TRANSFER.get(payment.getTransactionType()));
        figoPayment.setName(payment.getReceiver());
        figoPayment.setPurpose(payment.getPurpose());
        return figoPayment;
    }

    public static ChallengeData mapToChallenge(Challenge challenge) {
        ChallengeData challengeData = new ChallengeData();
        challengeData.setData(Collections.singletonList(challenge.getData()));
        challengeData.setOtpFormat(challenge.getFormat());
        challengeData.setAdditionalInformation(challenge.getTitle());
        return challengeData;
    }

    static {
        FIGO_CYCLE.put(Cycle.WEEKLY, "weekly");
        FIGO_CYCLE.put(Cycle.MONTHLY, "monthly");
        FIGO_CYCLE.put(Cycle.TWO_MONTHLY, "two monthly");
        FIGO_CYCLE.put(Cycle.QUARTERLY, "quarterly");
        FIGO_CYCLE.put(Cycle.HALF_YEARLY, "half yearly");
        FIGO_CYCLE.put(Cycle.YEARLY, "yearly");
        FIGO_TRANSFER.put(AbstractScaTransaction.TransactionType.SINGLE_PAYMENT, "SEPA transfer");
        FIGO_TRANSFER.put(AbstractScaTransaction.TransactionType.STANDING_ORDER, "SEPA standing order");
    }
}

