/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.figo;

import de.adorsys.multibanking.domain.Balance;
import de.adorsys.multibanking.domain.BalancesReport;
import de.adorsys.multibanking.domain.Bank;
import de.adorsys.multibanking.domain.BankAccess;
import de.adorsys.multibanking.domain.BankAccount;
import de.adorsys.multibanking.domain.BankApi;
import de.adorsys.multibanking.domain.BankApiUser;
import de.adorsys.multibanking.domain.BankLoginCredentialInfo;
import de.adorsys.multibanking.domain.BankLoginSettings;
import de.adorsys.multibanking.domain.exception.MultibankingError;
import de.adorsys.multibanking.domain.exception.MultibankingException;
import de.adorsys.multibanking.domain.request.AuthenticatePsuRequest;
import de.adorsys.multibanking.domain.request.CreateConsentRequest;
import de.adorsys.multibanking.domain.request.LoadAccountInformationRequest;
import de.adorsys.multibanking.domain.request.LoadBalanceRequest;
import de.adorsys.multibanking.domain.request.LoadBookingsRequest;
import de.adorsys.multibanking.domain.request.SubmitAuthorizationCodeRequest;
import de.adorsys.multibanking.domain.request.TransactionRequest;
import de.adorsys.multibanking.domain.response.AuthorisationCodeResponse;
import de.adorsys.multibanking.domain.response.CreateConsentResponse;
import de.adorsys.multibanking.domain.response.InitiatePaymentResponse;
import de.adorsys.multibanking.domain.response.LoadAccountInformationResponse;
import de.adorsys.multibanking.domain.response.LoadBookingsResponse;
import de.adorsys.multibanking.domain.response.ScaMethodsResponse;
import de.adorsys.multibanking.domain.response.SubmitAuthorizationCodeResponse;
import de.adorsys.multibanking.domain.spi.OnlineBankingService;
import de.adorsys.multibanking.domain.utils.Utils;
import de.adorsys.multibanking.figo.FigoMapping;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.stream.Collectors;
import me.figo.FigoConnection;
import me.figo.FigoException;
import me.figo.FigoSession;
import me.figo.internal.SyncTokenRequest;
import me.figo.internal.TaskStatusRequest;
import me.figo.internal.TaskStatusResponse;
import me.figo.internal.TaskTokenResponse;
import me.figo.internal.TokenResponse;
import me.figo.models.Account;
import me.figo.models.AccountBalance;
import org.adorsys.envutils.EnvProperties;
import org.apache.commons.lang3.RandomStringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FigoBanking
implements OnlineBankingService {
    private static final String MAIL_SUFFIX = "@admb.de";
    private static final String CHARACTERS = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789~!@#%^*()-_=+[{]},<>";
    private static SecureRandom random = Utils.getSecureRandom();
    private FigoConnection figoConnection;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private String figoTechUser;
    private String figoTechUserCredential;
    private BankApi bankApi;

    public FigoBanking(BankApi bankApi) {
        this.bankApi = bankApi;
        String clientId = EnvProperties.getEnvOrSysProp((String)"FIGO_CLIENT_ID", (boolean)true);
        String secret = EnvProperties.getEnvOrSysProp((String)"FIGO_SECRET", (boolean)true);
        String timeout = EnvProperties.getEnvOrSysProp((String)"FIGO_TIMEOUT", (String)"0");
        String connectionUrl = EnvProperties.getEnvOrSysProp((String)"FIGO_CONNECTION_URL", (String)"https://api.figo.me");
        if (bankApi == BankApi.FIGO_ALTERNATIVE) {
            clientId = EnvProperties.getEnvOrSysProp((String)"FIGO_ALTERNATIVE_CLIENT_ID", (String)clientId);
            secret = EnvProperties.getEnvOrSysProp((String)"FIGO_ALTERNATIVE_SECRETT", (String)secret);
            timeout = EnvProperties.getEnvOrSysProp((String)"FIGO_ALTERNATIVE_TIMEOUT", (String)timeout);
            connectionUrl = EnvProperties.getEnvOrSysProp((String)"FIGO_ALTERNATIVE_CONNECTION_URL", (String)connectionUrl);
            this.logger = LoggerFactory.getLogger((String)"figo.FigoBankingAlternative");
        }
        if (clientId == null || secret == null) {
            this.logger.warn("missing env properties FIGO_CLIENT_ID and/or FIGO_SECRET");
        } else {
            this.figoConnection = new FigoConnection(clientId, secret, "http://nowhere.here", Integer.parseInt(timeout), connectionUrl);
        }
        this.figoTechUser = EnvProperties.getEnvOrSysProp((String)"FIGO_TECH_USER", (boolean)true);
        this.figoTechUserCredential = EnvProperties.getEnvOrSysProp((String)"FIGO_TECH_USER_CREDENTIAL", (boolean)true);
        if (this.figoTechUser == null || this.figoTechUserCredential == null) {
            this.logger.warn("missing env properties FIGO_TECH_USER and/or FIGO_TECH_USER_CREDENTIAL");
        }
    }

    public BankApi bankApi() {
        return this.bankApi;
    }

    public boolean externalBankAccountRequired() {
        return true;
    }

    public boolean bankSupported(String bankCode) {
        if (this.figoConnection == null) {
            throw new IllegalArgumentException("figo connection not available, check env properties FIGO_CLIENT_ID and/or FIGO_SECRET");
        }
        return true;
    }

    public boolean bookingsCategorized() {
        return false;
    }

    public InitiatePaymentResponse initiatePayment(String bankingUrl, TransactionRequest paymentRequest) {
        return null;
    }

    public void executeTransactionWithoutSca(String bankingUrl, TransactionRequest paymentRequest) {
    }

    public AuthorisationCodeResponse requestAuthorizationCode(String bankingUrl, TransactionRequest paymentRequest) {
        return null;
    }

    public SubmitAuthorizationCodeResponse submitAuthorizationCode(SubmitAuthorizationCodeRequest submitPaymentRequest) {
        return null;
    }

    public boolean userRegistrationRequired() {
        return true;
    }

    public BankApiUser registerUser(String bankingUrl, BankAccess bankAccess, String pin) {
        if (this.figoConnection == null) {
            throw new IllegalArgumentException("figo connection not available, check env properties FIGO_CLIENT_ID and/or FIGO_SECRET");
        }
        String password = RandomStringUtils.random((int)20, (int)0, (int)0, (boolean)false, (boolean)false, (char[])CHARACTERS.toCharArray(), (Random)random);
        try {
            this.figoConnection.addUser(bankAccess.getBankLogin(), bankAccess.getBankLogin() + MAIL_SUFFIX, password, "de");
        }
        catch (IOException | FigoException e) {
            throw new IllegalStateException(e);
        }
        BankApiUser bankApiUser = new BankApiUser();
        bankApiUser.setApiUserId(bankAccess.getBankLogin());
        bankApiUser.setApiPassword(password);
        bankApiUser.setBankApi(this.bankApi());
        return bankApiUser;
    }

    public void removeUser(String bankingUrl, BankApiUser bankApiUser) {
        try {
            TokenResponse tokenResponse = this.figoConnection.credentialLogin(bankApiUser.getApiUserId() + MAIL_SUFFIX, bankApiUser.getApiPassword());
            FigoSession session = this.createSession(tokenResponse.getAccessToken());
            session.removeUser();
        }
        catch (IOException | FigoException e) {
            throw new IllegalStateException(e);
        }
    }

    public ScaMethodsResponse authenticatePsu(String bankingUrl, AuthenticatePsuRequest authenticatePsuRequest) {
        return null;
    }

    public LoadAccountInformationResponse loadBankAccounts(String bankingUrl, LoadAccountInformationRequest loadAccountInformationRequest) {
        BankApiUser bankApiUser = loadAccountInformationRequest.getBankApiUser();
        BankAccess bankAccess = loadAccountInformationRequest.getBankAccess();
        try {
            TokenResponse tokenResponse = this.figoConnection.credentialLogin(bankApiUser.getApiUserId() + MAIL_SUFFIX, bankApiUser.getApiPassword());
            FigoSession session = this.createSession(tokenResponse.getAccessToken());
            TaskTokenResponse response = session.setupNewAccount(bankAccess.getBankCode(), "de", this.createCredentials(bankAccess.getBankLogin(), bankAccess.getBankLogin2(), loadAccountInformationRequest.getPin()), Collections.singletonList("standingOrders"), loadAccountInformationRequest.isStorePin(), true);
            String taskToken = response.getTaskToken();
            while (this.checkState(session, taskToken) == Status.SYNC) {
                Thread.sleep(1000L);
            }
            this.updateTanTransportTypes(bankAccess, session.getAccounts());
            return LoadAccountInformationResponse.builder().bankAccounts(session.getAccounts().stream().map(account -> FigoMapping.mapBankAccount(account, this.bankApi)).collect(Collectors.toList())).build();
        }
        catch (IOException | InterruptedException | FigoException e) {
            throw new IllegalStateException(e);
        }
    }

    public Bank getBankLoginSettings(String bankCode) {
        me.figo.models.BankLoginSettings figoBankLoginSettings;
        FigoSession figoSession = this.loginTechUser();
        try {
            figoBankLoginSettings = (me.figo.models.BankLoginSettings)figoSession.queryApi("/rest/catalog/banks/de/" + bankCode, null, "GET", me.figo.models.BankLoginSettings.class);
        }
        catch (IOException | FigoException e) {
            throw new IllegalStateException(e);
        }
        Bank bank = new Bank();
        bank.setName(figoBankLoginSettings.getBankName());
        BankLoginSettings loginSettings = new BankLoginSettings();
        bank.setLoginSettings(loginSettings);
        loginSettings.setAdvice(figoBankLoginSettings.getAdvice());
        loginSettings.setAuth_type(figoBankLoginSettings.getAuthType());
        loginSettings.setIcon(figoBankLoginSettings.getIcon());
        loginSettings.setCredentials(new ArrayList());
        figoBankLoginSettings.getCredentials().forEach(credential -> {
            BankLoginCredentialInfo bankLoginCredential = new BankLoginCredentialInfo();
            bankLoginCredential.setLabel(credential.getLabel());
            bankLoginCredential.setMasked(credential.isMasked());
            bankLoginCredential.setOptional(credential.isOptional());
            loginSettings.getCredentials().add(bankLoginCredential);
        });
        return bank;
    }

    private BalancesReport getBalance(FigoSession figoSession, String accountId) {
        try {
            Account account = figoSession.getAccount(accountId);
            AccountBalance accountBalance = account.getBalance();
            return new BalancesReport().readyBalance(Balance.builder().amount(accountBalance.getBalance()).build());
        }
        catch (IOException | FigoException e) {
            throw new IllegalStateException(e);
        }
    }

    public void removeBankAccount(String bankingUrl, BankAccount bankAccount, BankApiUser bankApiUser) {
        try {
            TokenResponse tokenResponse = this.figoConnection.credentialLogin(bankApiUser.getApiUserId() + MAIL_SUFFIX, bankApiUser.getApiPassword());
            FigoSession session = this.createSession(tokenResponse.getAccessToken());
            session.removeAccount((String)bankAccount.getExternalIdMap().get(this.bankApi()));
        }
        catch (IOException | FigoException e) {
            throw new IllegalStateException(e);
        }
    }

    public LoadBookingsResponse loadBookings(String bankingUrl, LoadBookingsRequest loadBookingsRequest) {
        BankApiUser bankApiUser = loadBookingsRequest.getBankApiUser();
        BankAccount bankAccount = loadBookingsRequest.getBankAccount();
        try {
            TokenResponse tokenResponse = this.figoConnection.credentialLogin(bankApiUser.getApiUserId() + MAIL_SUFFIX, bankApiUser.getApiPassword());
            FigoSession session = this.createSession(tokenResponse.getAccessToken());
            TaskTokenResponse response = (TaskTokenResponse)session.queryApi("/rest/sync", (Object)new SyncTokenRequest(RandomStringUtils.randomAlphanumeric((int)5), null, Collections.singletonList("standingOrders"), Collections.singletonList(bankAccount.getExternalIdMap().get(this.bankApi())), true, 0, false), "POST", TaskTokenResponse.class);
            Status status = this.waitForFinish(session, response.getTaskToken());
            if (status == Status.PIN) {
                this.submitPin(response.getTaskToken(), loadBookingsRequest.getPin(), session);
            }
            List bookings = session.getTransactions((String)bankAccount.getExternalIdMap().get(this.bankApi())).stream().map(transaction -> FigoMapping.mapBooking(transaction, this.bankApi)).collect(Collectors.toList());
            List standingOrders = session.getStandingOrders((String)bankAccount.getExternalIdMap().get(this.bankApi())).stream().map(FigoMapping::mapStandingOrder).collect(Collectors.toList());
            this.updateTanTransportTypes(loadBookingsRequest.getBankAccess(), session.getAccounts());
            return LoadBookingsResponse.builder().bookings(bookings).standingOrders(standingOrders).bankAccountBalance(this.getBalance(session, (String)bankAccount.getExternalIdMap().get(this.bankApi()))).build();
        }
        catch (IOException | InterruptedException | FigoException e) {
            throw new IllegalStateException(e);
        }
    }

    public List<BankAccount> loadBalances(String bankingUrl, LoadBalanceRequest loadBalanceRequest) {
        return null;
    }

    public boolean accountInformationConsentRequired() {
        return false;
    }

    public CreateConsentResponse createAccountInformationConsent(String bankingUrl, CreateConsentRequest createConsentRequest) {
        return null;
    }

    private TaskStatusResponse submitPin(String taskToken, String pin, FigoSession session) throws FigoException, InterruptedException, IOException {
        TaskStatusResponse response = (TaskStatusResponse)session.queryApi("/task/progress?id=" + taskToken, (Object)new TaskStatusRequest(taskToken, pin), "POST", TaskStatusResponse.class);
        Status status = this.waitForFinish(session, taskToken);
        if (status != Status.OK && status != Status.TAN) {
            throw new MultibankingException(MultibankingError.INVALID_PIN, response.getMessage());
        }
        return response;
    }

    private void submitTan(String taskToken, String tan, FigoSession session) throws FigoException, InterruptedException, IOException {
        TaskStatusRequest taskStatusRequest = new TaskStatusRequest(taskToken);
        taskStatusRequest.setResponse(tan);
        session.queryApi("/task/progress?id=" + taskToken, (Object)taskStatusRequest, "POST", TaskStatusResponse.class);
        Status status = this.waitForFinish(session, taskToken);
        if (status != Status.OK) {
            throw new MultibankingException(MultibankingError.INVALID_TAN, Collections.emptyList());
        }
    }

    private void updateTanTransportTypes(BankAccess bankAccess, List<Account> accounts) {
        List tanTransportTypes = accounts.stream().map(Account::getSupportedTanSchemes).flatMap(Collection::stream).map(FigoMapping::mapTanTransportTypes).collect(Collectors.toList());
        if (bankAccess.getTanTransportTypes() == null) {
            bankAccess.setTanTransportTypes(new HashMap());
        }
        bankAccess.getTanTransportTypes().put(this.bankApi(), tanTransportTypes);
    }

    private Status waitForFinish(FigoSession session, String taskToken) throws IOException, FigoException, InterruptedException {
        Status status;
        while ((status = this.checkState(session, taskToken)) == Status.SYNC) {
            Thread.sleep(1000L);
        }
        return status;
    }

    private Status checkState(FigoSession figoSession, String taskToken) throws IOException, FigoException {
        TaskStatusResponse taskStatus;
        try {
            taskStatus = figoSession.getTaskState(taskToken);
            this.logger.info("figo.getTaskState {} {}", (Object)taskStatus.getAccountId(), (Object)taskStatus.getMessage());
        }
        catch (IOException | FigoException e) {
            throw new IllegalStateException(e);
        }
        return this.resolveStatus(taskStatus);
    }

    private Status resolveStatus(TaskStatusResponse taskStatus) throws IOException, FigoException {
        if (!(taskStatus.isEnded() || taskStatus.isErroneous() || taskStatus.isWaitingForPin() || taskStatus.isWaitingForResponse())) {
            return Status.SYNC;
        }
        if (taskStatus.isWaitingForPin()) {
            return Status.PIN;
        }
        if (taskStatus.isWaitingForResponse()) {
            return Status.TAN;
        }
        if (taskStatus.isErroneous()) {
            if (taskStatus.getError().getCode() == 10000 || taskStatus.getError().getCode() == 10001) {
                throw new MultibankingException(MultibankingError.INVALID_PIN, taskStatus.getError().getMessage());
            }
            throw new IllegalStateException(taskStatus.getError().getMessage());
        }
        return Status.OK;
    }

    String extractTaskToken(URL url) throws UnsupportedEncodingException {
        String[] pairs;
        String query = url.getQuery();
        for (String pair : pairs = query.split("&")) {
            if (!pair.startsWith("id=")) continue;
            String id = pair.substring(3);
            return URLDecoder.decode(id, "UTF-8");
        }
        return null;
    }

    private FigoSession loginTechUser() {
        String accessToken;
        String username = this.figoTechUser + MAIL_SUFFIX;
        try {
            accessToken = this.figoConnection.credentialLogin(username, this.figoTechUserCredential).getAccessToken();
        }
        catch (Exception e) {
            try {
                this.figoConnection.addUser(this.figoTechUser, username, this.figoTechUserCredential, "de");
                accessToken = this.figoConnection.credentialLogin(username, this.figoTechUserCredential).getAccessToken();
            }
            catch (Exception e1) {
                throw new IllegalStateException(e);
            }
        }
        return this.createSession(accessToken);
    }

    private FigoSession createSession(String accessToken) {
        return new FigoSession(accessToken, this.figoConnection.getTimeout(), this.figoConnection.getApiEndpoint());
    }

    private List<String> createCredentials(String ... credentials) {
        return Arrays.stream(credentials).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public static enum Status {
        OK,
        SYNC,
        PIN,
        TAN,
        ERROR;

    }
}

