/*
 * Decompiled with CFR 0.152.
 */
package figo;

import domain.AbstractPayment;
import domain.Balance;
import domain.BalancesReport;
import domain.BankAccount;
import domain.BankAccountType;
import domain.BankApi;
import domain.Booking;
import domain.Cycle;
import domain.PaymentChallenge;
import domain.SinglePayment;
import domain.TanTransportType;
import java.time.ZoneId;
import java.util.HashMap;
import java.util.Map;
import me.figo.models.Account;
import me.figo.models.Challenge;
import me.figo.models.Payment;
import me.figo.models.StandingOrder;
import me.figo.models.TanScheme;
import me.figo.models.Transaction;
import org.apache.commons.lang3.StringUtils;
import utils.Utils;

public class FigoMapping {
    private static final Map<Cycle, String> FIGO_CYCLE = new HashMap<Cycle, String>();
    private static final Map<AbstractPayment.PaymentType, String> FIGO_TRANSFER = new HashMap<AbstractPayment.PaymentType, String>();

    public static domain.StandingOrder mapStandingOrder(StandingOrder figoStandingOrder) {
        domain.StandingOrder standingOrder = new domain.StandingOrder();
        standingOrder.setOrderId(figoStandingOrder.getStandingOrderId());
        standingOrder.setExecutionDay(figoStandingOrder.getExecutionDay().intValue());
        standingOrder.setAmount(figoStandingOrder.getAmount());
        standingOrder.setUsage(figoStandingOrder.getPurposeText());
        standingOrder.setCycle(Cycle.valueOf((String)figoStandingOrder.getInterval().toString()));
        standingOrder.setOtherAccount(new BankAccount().owner(figoStandingOrder.getName()).accountNumber(figoStandingOrder.getAccountNumber()).blz(figoStandingOrder.getBankCode()).currency(figoStandingOrder.getCurrency()));
        return standingOrder;
    }

    public static BankAccount mapBankAccount(Account account, BankApi bankApi) {
        return new BankAccount().externalId(bankApi, account.getAccountId()).owner(account.getOwner()).accountNumber(account.getAccountNumber()).name(account.getName()).bankName(account.getBankName()).bic(account.getBIC()).blz(account.getBankCode()).iban(account.getIBAN()).type(BankAccountType.fromFigoType((String)account.getType())).bankAccountBalance(new BalancesReport().readyHbciBalance(Balance.builder().amount(account.getBalance().getBalance()).build()));
    }

    public static Booking mapBooking(Transaction transaction, BankApi bankApi) {
        Booking booking = new Booking();
        booking.setExternalId(transaction.getTransactionId());
        booking.setBankApi(bankApi);
        booking.setBookingDate(transaction.getBookingDate().toInstant().atZone(ZoneId.systemDefault()).toLocalDate());
        booking.setValutaDate(transaction.getValueDate().toInstant().atZone(ZoneId.systemDefault()).toLocalDate());
        booking.setAmount(transaction.getAmount());
        booking.setUsage(transaction.getPurposeText());
        booking.setText(transaction.getBookingText());
        booking.setTransactionCode(transaction.getTransactionCode());
        booking.setOtherAccount(FigoMapping.mapBookingAccount(transaction));
        booking.setCreditorId(Utils.extractCreditorId((String)transaction.getPurposeText()));
        booking.setMandateReference(Utils.extractMandateReference((String)transaction.getPurposeText()));
        return booking;
    }

    public static BankAccount mapBookingAccount(Transaction transaction) {
        BankAccount bankAccount = new BankAccount();
        bankAccount.setName(transaction.getName());
        bankAccount.setBankName(transaction.getBankName());
        bankAccount.setCurrency(transaction.getCurrency());
        bankAccount.setAccountNumber(transaction.getAccountNumber());
        bankAccount.setBlz(transaction.getBankCode());
        bankAccount.setIban(Utils.extractIban((String)transaction.getPurposeText()));
        return bankAccount;
    }

    public static TanTransportType mapTanTransportTypes(TanScheme tanScheme) {
        return TanTransportType.builder().id(tanScheme.getTan_scheme_id()).name(tanScheme.getName()).build();
    }

    public static Payment mapToFigoPayment(String accountId, SinglePayment payment) {
        Payment figoPayment = new Payment();
        figoPayment.setAccountId(accountId);
        if (!StringUtils.isEmpty((CharSequence)payment.getReceiverIban())) {
            figoPayment.setIban(payment.getReceiverIban());
        } else {
            figoPayment.setBankCode(payment.getReceiverBankCode());
            figoPayment.setAccountNumber(payment.getReceiverAccountNumber());
        }
        figoPayment.setAmount(payment.getAmount());
        figoPayment.setCurrency("EUR");
        figoPayment.setType(FIGO_TRANSFER.get(payment.getPaymentType()));
        figoPayment.setName(payment.getReceiver());
        figoPayment.setPurpose(payment.getPurpose());
        return figoPayment;
    }

    public static PaymentChallenge mapToChallenge(Challenge challenge) {
        return PaymentChallenge.builder().data(challenge.getData()).format(challenge.getFormat()).label(challenge.getLabel()).title(challenge.getTitle()).build();
    }

    static {
        FIGO_CYCLE.put(Cycle.WEEKLY, "weekly");
        FIGO_CYCLE.put(Cycle.MONTHLY, "monthly");
        FIGO_CYCLE.put(Cycle.TWO_MONTHLY, "two monthly");
        FIGO_CYCLE.put(Cycle.QUARTERLY, "quarterly");
        FIGO_CYCLE.put(Cycle.HALF_YEARLY, "half yearly");
        FIGO_CYCLE.put(Cycle.YEARLY, "yearly");
        FIGO_TRANSFER.put(AbstractPayment.PaymentType.SINGLE_PAYMENT, "SEPA transfer");
        FIGO_TRANSFER.put(AbstractPayment.PaymentType.STANDING_ORDER, "SEPA standing order");
    }
}

