/*
 * Decompiled with CFR 0.152.
 */
package figo;

import domain.Bank;
import domain.BankAccess;
import domain.BankAccount;
import domain.BankAccountBalance;
import domain.BankApi;
import domain.BankApiUser;
import domain.BankLoginCredential;
import domain.BankLoginSettings;
import domain.LoadBookingsResponse;
import exception.InvalidPinException;
import figo.FigoMapping;
import java.io.IOException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.stream.Collectors;
import me.figo.FigoConnection;
import me.figo.FigoException;
import me.figo.FigoSession;
import me.figo.internal.SyncTokenRequest;
import me.figo.internal.TaskStatusRequest;
import me.figo.internal.TaskStatusResponse;
import me.figo.internal.TaskTokenResponse;
import me.figo.internal.TokenResponse;
import me.figo.models.Account;
import me.figo.models.AccountBalance;
import org.adorsys.envutils.EnvProperties;
import org.apache.commons.lang3.RandomStringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import spi.OnlineBankingService;
import utils.Utils;

public class FigoBanking
implements OnlineBankingService {
    private static final String MAIL_SUFFIX = "@admb.de";
    private FigoConnection figoConnection;
    private static SecureRandom random = Utils.getSecureRandom();
    private static final String CHARACTERS = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789~!@#%^*()-_=+[{]},<>";
    private Logger LOG = LoggerFactory.getLogger(this.getClass());
    private String figoTechUser;
    private String figoTechUserCredential;
    private BankApi bankApi;

    public FigoBanking(BankApi bankApi) {
        this.bankApi = bankApi;
        String clientId = EnvProperties.getEnvOrSysProp((String)"FIGO_CLIENT_ID", (boolean)true);
        String secret = EnvProperties.getEnvOrSysProp((String)"FIGO_SECRET", (boolean)true);
        String timeout = EnvProperties.getEnvOrSysProp((String)"FIGO_TIMEOUT", (String)"0");
        String connectionUrl = EnvProperties.getEnvOrSysProp((String)"FIGO_CONNECTION_URL", (String)"https://api.figo.me");
        if (bankApi == BankApi.FIGO_ALTERNATIVE) {
            clientId = EnvProperties.getEnvOrSysProp((String)"FIGO_ALTERNATIVE_CLIENT_ID", (String)clientId);
            secret = EnvProperties.getEnvOrSysProp((String)"FIGO_ALTERNATIVE_SECRETT", (String)secret);
            timeout = EnvProperties.getEnvOrSysProp((String)"FIGO_ALTERNATIVE_TIMEOUT", (String)timeout);
            connectionUrl = EnvProperties.getEnvOrSysProp((String)"FIGO_ALTERNATIVE_CONNECTION_URL", (String)connectionUrl);
            this.LOG = LoggerFactory.getLogger((String)"figo.FigoBankingAlternative");
        }
        if (clientId == null || secret == null) {
            this.LOG.warn("missing env properties FIGO_CLIENT_ID and/or FIGO_SECRET");
        } else {
            this.figoConnection = new FigoConnection(clientId, secret, "http://nowhere.here", Integer.parseInt(timeout), connectionUrl);
        }
        this.figoTechUser = EnvProperties.getEnvOrSysProp((String)"FIGO_TECH_USER", (boolean)true);
        this.figoTechUserCredential = EnvProperties.getEnvOrSysProp((String)"FIGO_TECH_USER_CREDENTIAL", (boolean)true);
        if (this.figoTechUser == null || this.figoTechUserCredential == null) {
            this.LOG.warn("missing env properties FIGO_TECH_USER and/or FIGO_TECH_USER_CREDENTIAL");
        }
    }

    public BankApi bankApi() {
        return this.bankApi;
    }

    public boolean externalBankAccountRequired() {
        return true;
    }

    public boolean bankSupported(String bankCode) {
        if (this.figoConnection == null) {
            throw new IllegalArgumentException("figo connection not available, check env properties FIGO_CLIENT_ID and/or FIGO_SECRET");
        }
        return true;
    }

    public boolean bookingsCategorized() {
        return false;
    }

    public boolean userRegistrationRequired() {
        return true;
    }

    public BankApiUser registerUser(String uid) {
        if (this.figoConnection == null) {
            throw new IllegalArgumentException("figo connection not available, check env properties FIGO_CLIENT_ID and/or FIGO_SECRET");
        }
        String password = RandomStringUtils.random((int)20, (int)0, (int)0, (boolean)false, (boolean)false, (char[])CHARACTERS.toCharArray(), (Random)random);
        try {
            this.figoConnection.addUser(uid, uid + MAIL_SUFFIX, password, "de");
        }
        catch (IOException | FigoException e) {
            throw new RuntimeException(e);
        }
        BankApiUser bankApiUser = new BankApiUser();
        bankApiUser.setApiUserId(uid);
        bankApiUser.setApiPassword(password);
        bankApiUser.setBankApi(this.bankApi());
        return bankApiUser;
    }

    public void removeUser(BankApiUser bankApiUser) {
        try {
            TokenResponse tokenResponse = this.figoConnection.credentialLogin(bankApiUser.getApiUserId() + MAIL_SUFFIX, bankApiUser.getApiPassword());
            FigoSession session = this.createSession(tokenResponse.getAccessToken());
            session.removeUser();
        }
        catch (IOException | FigoException e) {
            throw new RuntimeException(e);
        }
    }

    public Bank getBankLoginSettings(String bankCode) {
        me.figo.models.BankLoginSettings figoBankLoginSettings;
        FigoSession figoSession = this.loginTechUser();
        try {
            figoBankLoginSettings = (me.figo.models.BankLoginSettings)figoSession.queryApi("/rest/catalog/banks/de/" + bankCode, null, "GET", me.figo.models.BankLoginSettings.class);
        }
        catch (IOException | FigoException e) {
            throw new RuntimeException(e);
        }
        Bank bank = new Bank();
        bank.setName(figoBankLoginSettings.getBankName());
        BankLoginSettings loginSettings = new BankLoginSettings();
        bank.setLoginSettings(loginSettings);
        loginSettings.setAdditional_icons(figoBankLoginSettings.getAdditionalIcons());
        loginSettings.setAdvice(figoBankLoginSettings.getAdvice());
        loginSettings.setAuth_type(figoBankLoginSettings.getAuthType());
        loginSettings.setIcon(figoBankLoginSettings.getIcon());
        loginSettings.setCredentials(new ArrayList());
        figoBankLoginSettings.getCredentials().forEach(credential -> {
            BankLoginCredential bankLoginCredential = new BankLoginCredential();
            bankLoginCredential.setLabel(credential.getLabel());
            bankLoginCredential.setMasked(credential.isMasked());
            bankLoginCredential.setOptional(credential.isOptional());
            loginSettings.getCredentials().add(bankLoginCredential);
        });
        return bank;
    }

    public List<BankAccount> loadBankAccounts(BankApiUser bankApiUser, BankAccess bankAccess, String bankCode, String pin, boolean storePin) {
        try {
            TokenResponse tokenResponse = this.figoConnection.credentialLogin(bankApiUser.getApiUserId() + MAIL_SUFFIX, bankApiUser.getApiPassword());
            FigoSession session = this.createSession(tokenResponse.getAccessToken());
            TaskTokenResponse response = session.setupNewAccount(bankAccess.getBankCode(), "de", this.createCredentials(bankAccess.getBankLogin(), bankAccess.getBankLogin2(), pin), Collections.singletonList("standingOrders"), storePin, true);
            String taskToken = response.getTaskToken();
            while (this.checkState(session, taskToken) == Status.SYNC) {
                Thread.sleep(1000L);
            }
            this.updateTanTransportTypes(bankAccess, session.getAccounts());
            return session.getAccounts().stream().map(FigoMapping::mapBankAccount).collect(Collectors.toList());
        }
        catch (IOException | InterruptedException | FigoException e) {
            throw new RuntimeException(e);
        }
    }

    private BankAccountBalance getBalance(FigoSession figoSession, String accountId) {
        try {
            Account account = figoSession.getAccount(accountId);
            AccountBalance accountBalance = account.getBalance();
            return new BankAccountBalance().readyHbciBalance(accountBalance.getBalance());
        }
        catch (IOException | FigoException e) {
            throw new RuntimeException(e);
        }
    }

    public void removeBankAccount(BankAccount bankAccount, BankApiUser bankApiUser) {
        try {
            TokenResponse tokenResponse = this.figoConnection.credentialLogin(bankApiUser.getApiUserId() + MAIL_SUFFIX, bankApiUser.getApiPassword());
            FigoSession session = this.createSession(tokenResponse.getAccessToken());
            session.removeAccount((String)bankAccount.getExternalIdMap().get(this.bankApi()));
        }
        catch (IOException | FigoException e) {
            throw new RuntimeException(e);
        }
    }

    public LoadBookingsResponse loadBookings(BankApiUser bankApiUser, BankAccess bankAccess, String bankCode, BankAccount bankAccount, String pin) {
        try {
            TokenResponse tokenResponse = this.figoConnection.credentialLogin(bankApiUser.getApiUserId() + MAIL_SUFFIX, bankApiUser.getApiPassword());
            FigoSession session = this.createSession(tokenResponse.getAccessToken());
            TaskTokenResponse response = (TaskTokenResponse)session.queryApi("/rest/sync", (Object)new SyncTokenRequest(RandomStringUtils.randomAlphanumeric((int)5), null, Collections.singletonList("standingOrders"), Collections.singletonList(bankAccount.getExternalIdMap().get(this.bankApi())), true, 0, false), "POST", TaskTokenResponse.class);
            Status status = this.waitForFinish(session, response.getTaskToken(), pin);
            if (status == Status.PIN) {
                TaskStatusRequest request = new TaskStatusRequest(response.getTaskToken());
                request.setPin(pin);
                session.queryApi("/task/progress?id=" + response.getTaskToken(), (Object)request, "POST", TaskStatusResponse.class);
                this.waitForFinish(session, response.getTaskToken(), pin);
            }
            List bookings = session.getTransactions((String)bankAccount.getExternalIdMap().get(this.bankApi())).stream().map(FigoMapping::mapBooking).collect(Collectors.toList());
            List standingOrders = session.getStandingOrders((String)bankAccount.getExternalIdMap().get(this.bankApi())).stream().map(FigoMapping::mapStandingOrder).collect(Collectors.toList());
            this.updateTanTransportTypes(bankAccess, session.getAccounts());
            return LoadBookingsResponse.builder().bookings(bookings).standingOrders(standingOrders).bankAccountBalance(this.getBalance(session, (String)bankAccount.getExternalIdMap().get(this.bankApi()))).build();
        }
        catch (IOException | InterruptedException | FigoException e) {
            throw new RuntimeException(e);
        }
    }

    private void updateTanTransportTypes(BankAccess bankAccess, List<Account> accounts) throws FigoException, IOException {
        List tanTransportTypes = accounts.stream().map(Account::getSupportedTanSchemes).flatMap(listContainer -> listContainer.stream()).map(FigoMapping::mapTanTransportTypes).collect(Collectors.toList());
        bankAccess.setTanTransportTypes(tanTransportTypes);
    }

    private Status waitForFinish(FigoSession session, String taskToken, String pin) throws IOException, FigoException, InterruptedException {
        Status status;
        while ((status = this.checkState(session, taskToken)) == Status.SYNC) {
            Thread.sleep(1000L);
        }
        return status;
    }

    private Status checkState(FigoSession figoSession, String taskToken) throws IOException, FigoException {
        TaskStatusResponse taskStatus;
        try {
            taskStatus = figoSession.getTaskState(taskToken);
            this.LOG.info("figo.getTaskState {} {}", (Object)taskStatus.getAccountId(), (Object)taskStatus.getMessage());
        }
        catch (IOException | FigoException e) {
            throw new RuntimeException(e);
        }
        return this.resolveStatus(taskStatus);
    }

    private Status resolveStatus(TaskStatusResponse taskStatus) throws IOException, FigoException {
        if (!(taskStatus.isEnded() || taskStatus.isErroneous() || taskStatus.isWaitingForPin() || taskStatus.isWaitingForResponse())) {
            return Status.SYNC;
        }
        if (taskStatus.isWaitingForPin()) {
            return Status.PIN;
        }
        if (taskStatus.isWaitingForResponse()) {
            return Status.TAN;
        }
        if (taskStatus.isErroneous()) {
            if (taskStatus.getError().getCode() == 10000 || taskStatus.getError().getCode() == 10001) {
                throw new InvalidPinException();
            }
            throw new RuntimeException(taskStatus.getError().getMessage());
        }
        return Status.OK;
    }

    private FigoSession loginTechUser() {
        String accessToken;
        String username = this.figoTechUser + MAIL_SUFFIX;
        try {
            accessToken = this.figoConnection.credentialLogin(username, this.figoTechUserCredential).getAccessToken();
        }
        catch (Exception e) {
            try {
                this.figoConnection.addUser(this.figoTechUser, username, this.figoTechUserCredential, "de");
                accessToken = this.figoConnection.credentialLogin(username, this.figoTechUserCredential).getAccessToken();
            }
            catch (Exception e1) {
                throw new RuntimeException(e);
            }
        }
        return this.createSession(accessToken);
    }

    private FigoSession createSession(String accessToken) {
        return new FigoSession(accessToken, this.figoConnection.getTimeout(), this.figoConnection.getApiEndpoint());
    }

    private List<String> createCredentials(String ... credentials) {
        return Arrays.stream(credentials).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public static enum Status {
        OK,
        SYNC,
        PIN,
        TAN,
        ERROR;

    }
}

