/*
 * Decompiled with CFR 0.152.
 */
package hbci4java;

import domain.BankAccount;
import domain.BankAccountBalance;
import domain.Booking;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.text.WordUtils;
import org.kapott.hbci.GV_Result.GVRKUms;
import org.kapott.hbci.GV_Result.GVRSaldoReq;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HbciFactory {
    private static final Logger LOG = LoggerFactory.getLogger(HbciFactory.class);

    public static BankAccountBalance createBalance(GVRSaldoReq gvSaldoReq) {
        GVRSaldoReq.Info[] infos;
        BankAccountBalance result = new BankAccountBalance();
        if (gvSaldoReq.isOK() && (infos = gvSaldoReq.getEntries()).length > 0) {
            if (infos[0] != null && infos[0].ready != null && infos[0].ready.value != null) {
                result.readyHbciBalance(infos[0].ready.value.getBigDecimalValue().setScale(2));
            }
            if (infos[0] != null && infos[0].available != null) {
                result.availableHbciBalance(infos[0].available.getBigDecimalValue().setScale(2));
            }
            if (infos[0] != null && infos[0].kredit != null) {
                result.creditHbciBalance(infos[0].kredit.getBigDecimalValue().setScale(2));
            }
            if (infos[0] != null && infos[0].unready != null && infos[0].unready.value != null) {
                result.unreadyHbciBalance(infos[0].unready.value.getBigDecimalValue().setScale(2));
            }
            if (infos[0] != null && infos[0].used != null) {
                result.usedHbciBalance(infos[0].used.getBigDecimalValue().setScale(2));
            }
        }
        return result;
    }

    public static List<Booking> createBookings(GVRKUms gvrkUms) {
        ArrayList<Booking> bookings = new ArrayList<Booking>();
        if (gvrkUms.isOK()) {
            List lines = gvrkUms.getFlatData();
            for (GVRKUms.UmsLine line : lines) {
                if (line == null) continue;
                if (line.value == null) {
                    LOG.warn("Booking has no amount, skipping: %s", (Object)line);
                    continue;
                }
                if (line.bdate == null) {
                    LOG.warn("Booking has no booking date, skipping: %s", (Object)line);
                    continue;
                }
                Booking booking = new Booking();
                booking.bookingDate(line.bdate);
                booking.amount(line.value.getBigDecimalValue().setScale(2));
                booking.additional(line.additional);
                booking.addkey(line.addkey);
                booking.customerRef(line.customerref);
                booking.instRef(line.instref);
                booking.reversal(line.isStorno);
                booking.sepa(line.isSepa);
                booking.primanota(line.primanota);
                booking.text(line.text);
                booking.valutaDate(line.valuta);
                if (line.saldo != null && line.saldo.value != null) {
                    booking.balance(line.saldo.value.getBigDecimalValue().setScale(2));
                }
                if (line.charge_value != null) {
                    booking.chargeValue(line.charge_value.getBigDecimalValue().setScale(2));
                }
                if (line.orig_value != null) {
                    booking.origValue(line.orig_value.getBigDecimalValue().setScale(2));
                }
                if (line.other != null) {
                    booking.otherAccount(new BankAccount(line.other));
                }
                booking.externalId("B-" + line.bdate.getTime() + "_" + line.value.getLongValue() + "_" + line.saldo.value.getLongValue());
                bookings.add(0, booking);
            }
        }
        LOG.debug("Received {} bookings: {}", (Object)bookings.size(), bookings);
        return bookings;
    }

    private static void applyVerwendungszweck(GVRKUms.UmsLine u, Booking booking) {
        String[] lines = u.usage.toArray(new String[u.usage.size()]);
        if (lines.length == 0) {
            lines = HbciFactory.parse(u.additional);
        }
        lines = HbciFactory.rewrap(35, lines);
        String verwendungszweck = "";
        int lineIndex = 0;
        for (String line : lines) {
            String[] words;
            int wordIndex = 0;
            for (String word : words = StringUtils.split((String)line, null, (int)0)) {
                verwendungszweck = verwendungszweck + word;
                verwendungszweck = verwendungszweck + (wordIndex + 1 < words.length ? " " : "");
                ++wordIndex;
            }
            verwendungszweck = verwendungszweck + (lineIndex == 0 ? " " : "");
            ++lineIndex;
        }
        booking.usage(WordUtils.capitalizeFully((String)verwendungszweck.trim(), (char[])new char[]{' ', '/'}));
    }

    private static List<String> clean(boolean trim, String ... lines) {
        ArrayList<String> result = new ArrayList<String>();
        if (lines == null || lines.length == 0) {
            return result;
        }
        for (String line : lines) {
            if (line == null) continue;
            if (trim) {
                line = line.trim();
            }
            if (line.length() <= 0) continue;
            result.add(line);
        }
        return result;
    }

    private static String[] parse(String line) {
        if (line == null || line.length() == 0) {
            return new String[0];
        }
        String s = line.replaceAll("(.{27})", "$1--##--##");
        return s.split("--##--##");
    }

    private static String[] rewrap(int limit, String ... lines) {
        String s2;
        if (lines == null || lines.length == 0) {
            return lines;
        }
        boolean found = false;
        for (String s2 : lines) {
            if (s2 == null || s2.length() <= limit) continue;
            found = true;
            break;
        }
        if (!found) {
            return lines;
        }
        List<String> l = HbciFactory.clean(true, lines);
        StringBuilder sb = new StringBuilder();
        l.forEach(sb::append);
        String result = sb.toString();
        s2 = result.replaceAll("(.{" + limit + "})", "$1--##--##");
        return s2.split("--##--##");
    }
}

