/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.mbs.service.example.config;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import de.adorsys.mbs.service.example.analytics.SimpleEmbededSmartAnalyticsFacade;
import de.adorsys.smartanalytics.api.GroupConfig;
import de.adorsys.smartanalytics.api.SmartAnalyticsFacade;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class SmartanalyticsConfig {
    @Value(value="${SMARTANALYTICS_GROUPCONFIG_URL:classpath:/analytics/group-config.yml}")
    private URL groupConfigUrl;
    @Value(value="${SMARTANALYTICS_CONTRACT_BLACKLIST_URL:classpath:/analytics/contract-blacklist.yml}")
    private URL contractBlacklistUrl;

    @Bean
    public SmartAnalyticsFacade facade() {
        return new SimpleEmbededSmartAnalyticsFacade();
    }

    @Bean
    public GroupConfig groupConfig() throws IOException {
        YAMLFactory ymlFactory = new YAMLFactory();
        ObjectMapper objectMapper = new ObjectMapper((JsonFactory)ymlFactory);
        return (GroupConfig)objectMapper.readValue(this.groupConfigUrl, GroupConfig.class);
    }

    @Bean
    @Qualifier(value="contractBlacklist")
    public List<String> contractBlacklist() throws IOException {
        YAMLFactory ymlFactory = new YAMLFactory();
        ObjectMapper objectMapper = new ObjectMapper((JsonFactory)ymlFactory);
        return (List)objectMapper.readValue(this.contractBlacklistUrl, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
    }
}

