/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.mbs.service.example.analytics;

import de.adorsys.multibanking.analytics.connector.CreditorIdValidator;
import de.adorsys.multibanking.analytics.connector.DECreditorIdValidator;
import de.adorsys.smartanalytics.api.AnalyticsRequest;
import de.adorsys.smartanalytics.api.AnalyticsResult;
import de.adorsys.smartanalytics.api.Rule;
import de.adorsys.smartanalytics.api.SmartAnalyticsFacade;
import de.adorsys.smartanalytics.api.WrappedBooking;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SimpleEmbededSmartAnalyticsFacade
implements SmartAnalyticsFacade {
    Map<String, Rule> creditorIdRules = new HashMap();
    Map<String, Rule> otherIbanRule = new HashMap();
    CreditorIdValidator validator = new DECreditorIdValidator();

    public AnalyticsResult analyzeBookings(AnalyticsRequest analyticsRequest) {
        List bookings = analyticsRequest.getBookings();
        ArrayList categorized = new ArrayList();
        bookings.forEach(booking -> {
            WrappedBooking wrappedBooking = new WrappedBooking(booking);
            String creditorId = booking.getCreditorId();
            if (!this.validator.isValid(creditorId)) {
                creditorId = this.validator.find(booking.getPurpose());
                if (creditorId != null) {
                    String nationalId = this.validator.nationalId(creditorId);
                    Rule rule = (Rule)this.creditorIdRules.get(nationalId);
                    wrappedBooking.setMainCategory(rule.getMainCategory());
                    wrappedBooking.setSubCategory(rule.getSubCategory());
                    wrappedBooking.setSpecification(rule.getSpecification());
                    wrappedBooking.setLogo(rule.getLogo());
                    wrappedBooking.setHomepage(rule.getHomepage());
                    wrappedBooking.setHotline(rule.getHotline());
                    wrappedBooking.setEmail(rule.getEmail());
                    if (wrappedBooking.getBooking().getCreditorId() == null) {
                        wrappedBooking.getBooking().setCreditorId(rule.getCreditorId());
                    }
                }
                categorized.add(wrappedBooking);
            }
        });
        AnalyticsResult analyticResult = new AnalyticsResult();
        analyticResult.setBookings(categorized);
        return analyticResult;
    }
}

