/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.mbs.service.example.config;

import de.adorsys.multibanking.auth.SystemContext;
import de.adorsys.multibanking.auth.UserContext;
import de.adorsys.multibanking.service.base.ExceptionHandlingDocumentSafeService;
import org.adorsys.cryptoutils.storeconnectionfactory.ExtendedStoreConnectionFactory;
import org.adorsys.docusafe.business.DocumentSafeService;
import org.adorsys.docusafe.business.impl.DocumentSafeServiceImpl;
import org.adorsys.docusafe.business.types.UserID;
import org.adorsys.docusafe.business.types.complex.UserIDAuth;
import org.adorsys.encobject.domain.ReadKeyPassword;
import org.adorsys.encobject.service.api.ExtendedStoreConnection;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class DocuSafeConfig {
    @Value(value="${docusafe.system.user.name}")
    String docusafeSystemUserName;
    @Value(value="${docusafe.system.user.password}")
    String docusafeSystemUserPassword;

    @Bean
    SystemContext systemContext() {
        UserIDAuth systemId = new UserIDAuth(new UserID(this.docusafeSystemUserName), new ReadKeyPassword(this.docusafeSystemUserPassword));
        UserContext userContext = new UserContext();
        userContext.setAuth(systemId);
        return new SystemContext(userContext);
    }

    @Bean
    DocumentSafeService docusafe(SystemContext systemContext) {
        ExtendedStoreConnection extendedStorageConnection = ExtendedStoreConnectionFactory.get();
        ExceptionHandlingDocumentSafeService safe = new ExceptionHandlingDocumentSafeService((DocumentSafeService)new DocumentSafeServiceImpl(extendedStorageConnection));
        UserIDAuth systemId = systemContext.getUser().getAuth();
        if (!safe.userExists(systemContext.getUser().getAuth().getUserID())) {
            safe.createUser(systemId);
        }
        return safe;
    }
}

