/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.mbs.service.example.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.adorsys.multibanking.auth.SystemContext;
import de.adorsys.multibanking.auth.UserContext;
import de.adorsys.multibanking.service.base.StorageUserService;
import de.adorsys.multibanking.service.base.SystemObjectService;
import de.adorsys.multibanking.service.base.UserObjectService;
import de.adorsys.multibanking.service.crypto.SecretClaimDecryptionService;
import de.adorsys.sts.filter.JWTAuthenticationFilter;
import de.adorsys.sts.token.authentication.TokenAuthenticationService;
import de.adorsys.sts.tokenauth.BearerToken;
import de.adorsys.sts.tokenauth.BearerTokenValidator;
import java.util.Arrays;
import java.util.Collections;
import javax.servlet.Filter;
import javax.servlet.http.HttpServletRequest;
import org.adorsys.docusafe.business.DocumentSafeService;
import org.adorsys.docusafe.business.types.UserID;
import org.adorsys.docusafe.business.types.complex.UserIDAuth;
import org.adorsys.encobject.domain.ReadKeyPassword;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.context.annotation.Scope;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.http.HttpMethod;
import org.springframework.security.config.annotation.method.configuration.EnableGlobalMethodSecurity;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.authentication.www.BasicAuthenticationFilter;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.cors.CorsConfigurationSource;
import org.springframework.web.cors.UrlBasedCorsConfigurationSource;

@Configuration
@EnableWebSecurity
@EnableGlobalMethodSecurity(prePostEnabled=true)
public class WebSecurityConfig
extends WebSecurityConfigurerAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(WebSecurityConfig.class);
    @Autowired
    private TokenAuthenticationService tokenAuthenticationService;
    @Autowired
    private SecretClaimDecryptionService secretClaimDecryptionService;
    @Autowired
    private StorageUserService storageUserService;
    @Autowired
    private DocumentSafeService documentSafeService;
    @Autowired
    private ObjectMapper objectMapper;
    @Autowired
    private BearerTokenValidator bearerTokenValidator;

    protected void configure(HttpSecurity http) throws Exception {
        ((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity)((HttpSecurity)http.csrf().disable()).sessionManagement().sessionCreationPolicy(SessionCreationPolicy.STATELESS).and()).authorizeRequests().antMatchers(HttpMethod.GET, new String[]{"/actuator/health"})).permitAll().antMatchers(HttpMethod.GET, new String[]{"/actuator/info"})).permitAll().antMatchers(new String[]{"/actuator/**"})).hasAuthority("admin").antMatchers(new String[]{"/"})).permitAll().antMatchers(new String[]{"/pop"})).permitAll().antMatchers(new String[]{"/swagger-ui.html**"})).permitAll().antMatchers(new String[]{"/webjars/**"})).permitAll().antMatchers(new String[]{"/swagger-resources/**"})).permitAll().antMatchers(new String[]{"/v2/api-docs/**"})).permitAll().antMatchers(HttpMethod.GET, new String[]{"/api/v1/bank/**"})).permitAll().antMatchers(new String[]{"/api/v1/image/**"})).permitAll().antMatchers(new String[]{"/api/v1/**"})).authenticated().anyRequest()).denyAll().and()).cors();
        http.addFilterBefore((Filter)new JWTAuthenticationFilter(this.tokenAuthenticationService), BasicAuthenticationFilter.class);
    }

    @Bean
    @Primary
    @Scope(scopeName="request", proxyMode=ScopedProxyMode.TARGET_CLASS)
    public UserContext getUserContext(HttpServletRequest request) {
        LOGGER.debug("************************************** Enter getUserContext");
        UserContext userContext = new UserContext();
        String userId = SecurityContextHolder.getContext().getAuthentication().getName();
        String userSecret = this.secretClaimDecryptionService.decryptSecretClaim();
        UserIDAuth userIDAuth = new UserIDAuth(new UserID(userId), new ReadKeyPassword(userSecret));
        userContext.setAuth(userIDAuth);
        String token = request.getHeader("Authorization");
        BearerToken bearerToken = this.bearerTokenValidator.extract(token);
        userContext.setBearerToken(bearerToken);
        if (StringUtils.isNotBlank((CharSequence)userSecret) && !this.storageUserService.userExists(userContext.getAuth().getUserID())) {
            this.storageUserService.createUser(userContext.getAuth());
        }
        LOGGER.debug("userContext ist " + userContext.getAuth().getUserID().getValue());
        LOGGER.debug("************************************** Exit getUserContext");
        return userContext;
    }

    @Bean
    @Scope(scopeName="request", proxyMode=ScopedProxyMode.TARGET_CLASS)
    UserObjectService userObjectService(UserContext userContext) {
        return new UserObjectService(this.objectMapper, userContext, this.documentSafeService);
    }

    @Bean
    SystemObjectService systemObjectService(SystemContext systemContext) {
        return new SystemObjectService(this.objectMapper, systemContext, this.documentSafeService);
    }

    @Bean
    public CorsConfigurationSource corsConfigurationSource() {
        CorsConfiguration configuration = new CorsConfiguration();
        configuration.setAllowedOrigins(Collections.singletonList("*"));
        configuration.setAllowedMethods(Arrays.asList("HEAD", "GET", "POST", "PUT", "DELETE", "PATCH"));
        configuration.setAllowCredentials(Boolean.valueOf(true));
        configuration.setAllowedHeaders(Arrays.asList("Authorization", "Cache-Control", "Content-Type"));
        configuration.setExposedHeaders(Collections.singletonList("Location"));
        UrlBasedCorsConfigurationSource source = new UrlBasedCorsConfigurationSource();
        source.registerCorsConfiguration("/**", configuration);
        return source;
    }
}

