/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.service;

import de.adorsys.multibanking.bg.BankingGatewayAdapter;
import de.adorsys.multibanking.domain.BankApi;
import de.adorsys.multibanking.domain.BankEntity;
import de.adorsys.multibanking.domain.spi.OnlineBankingService;
import de.adorsys.multibanking.figo.FigoBanking;
import de.adorsys.multibanking.finapi.FinapiBanking;
import de.adorsys.multibanking.hbci.HbciBanking;
import de.adorsys.multibanking.ing.IngAdapter;
import de.adorsys.multibanking.pers.spi.repository.BankRepositoryIf;
import de.adorsys.multibanking.service.OnlineBankingServiceProducer;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class OnlineBankingServiceProducer {
    private final IngAdapter ingAdapter;
    private final BankingGatewayAdapter bankingGatewayAdapter;
    private final HbciBanking hbci4JavaBanking;
    private final FigoBanking figoBanking;
    private final FigoBanking figoBankingAlternative;
    private final FinapiBanking finapiBanking;
    private final BankRepositoryIf bankRepository;
    @Value(value="${defaultBankApi:HBCI}")
    private String defaultBankApi;

    private BankApi getBankApiForBlz(String blz) {
        BankEntity bankInfoEntity = this.bankRepository.findByBankCode(blz).orElse(null);
        if (bankInfoEntity != null && bankInfoEntity.getBankApi() != null) {
            return bankInfoEntity.getBankApi();
        }
        return BankApi.valueOf((String)this.defaultBankApi);
    }

    public OnlineBankingService getBankingService(String bankCode) {
        BankApi bankApi = this.getBankApiForBlz(bankCode);
        return this.getBankingService(bankApi);
    }

    public OnlineBankingService getBankingService(BankApi bankApi) {
        switch (1.$SwitchMap$de$adorsys$multibanking$domain$BankApi[bankApi.ordinal()]) {
            case 1: {
                return this.hbci4JavaBanking;
            }
            case 2: {
                return this.figoBanking;
            }
            case 3: {
                return this.ingAdapter;
            }
            case 4: {
                return this.figoBankingAlternative;
            }
            case 5: {
                return this.finapiBanking;
            }
            case 6: {
                return this.bankingGatewayAdapter;
            }
        }
        throw new IllegalStateException("unsupported bank api");
    }

    public OnlineBankingServiceProducer(IngAdapter ingAdapter, BankingGatewayAdapter bankingGatewayAdapter, HbciBanking hbci4JavaBanking, FigoBanking figoBanking, FigoBanking figoBankingAlternative, FinapiBanking finapiBanking, BankRepositoryIf bankRepository) {
        this.ingAdapter = ingAdapter;
        this.bankingGatewayAdapter = bankingGatewayAdapter;
        this.hbci4JavaBanking = hbci4JavaBanking;
        this.figoBanking = figoBanking;
        this.figoBankingAlternative = figoBankingAlternative;
        this.finapiBanking = finapiBanking;
        this.bankRepository = bankRepository;
    }
}

