/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.web;

import de.adorsys.multibanking.domain.BankApi;
import de.adorsys.multibanking.domain.ScaApproach;
import de.adorsys.multibanking.domain.response.UpdateAuthResponse;
import de.adorsys.multibanking.service.ConsentService;
import de.adorsys.multibanking.web.BankController;
import de.adorsys.multibanking.web.ConsentAuthorisationController;
import de.adorsys.multibanking.web.UserResource;
import de.adorsys.multibanking.web.mapper.ConsentAuthorisationMapper;
import de.adorsys.multibanking.web.model.SelectPsuAuthenticationMethodRequestTO;
import de.adorsys.multibanking.web.model.TransactionAuthorisationRequestTO;
import de.adorsys.multibanking.web.model.UpdateAuthResponseTO;
import de.adorsys.multibanking.web.model.UpdatePsuAuthenticationRequestTO;
import io.micrometer.core.annotation.Timed;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.ArrayList;
import java.util.List;
import javax.validation.Valid;
import org.iban4j.Iban;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.Resource;
import org.springframework.hateoas.mvc.ControllerLinkBuilder;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Timed(value="consent-authorisation")
@Tag(name="Consent authorisation")
@UserResource
@RestController
@RequestMapping(path={"api/v1/consents/{consentId}/authorisations/{authorisationId}"})
public class ConsentAuthorisationController {
    private static final Logger log = LoggerFactory.getLogger(ConsentAuthorisationController.class);
    private final ConsentService consentService;
    private final ConsentAuthorisationMapper consentAuthorisationMapper;

    @Operation(description="Update authorisation (authenticate user)")
    @PutMapping(value={"/updatePsuAuthentication"})
    public ResponseEntity<Resource<UpdateAuthResponseTO>> updateAuthentication(@PathVariable String consentId, @PathVariable String authorisationId, @RequestBody @Valid UpdatePsuAuthenticationRequestTO updatePsuAuthenticationRequestTO) {
        String bankCode = Iban.valueOf((String)this.consentService.getInternalConsent(consentId).getPsuAccountIban()).getBankCode();
        UpdateAuthResponse updateAuthResponse = this.consentService.updatePsuAuthentication(updatePsuAuthenticationRequestTO, consentId);
        return ResponseEntity.ok((Object)this.mapToResource(updateAuthResponse, consentId, authorisationId, bankCode));
    }

    @Operation(description="Update authorisation (select SCA method)")
    @PutMapping(value={"/selectPsuAuthenticationMethod"})
    public ResponseEntity<Resource<UpdateAuthResponseTO>> selectAuthenticationMethod(@PathVariable String consentId, @PathVariable String authorisationId, @RequestBody @Valid SelectPsuAuthenticationMethodRequestTO selectPsuAuthenticationMethodRequest) {
        String bankCode = Iban.valueOf((String)this.consentService.getInternalConsent(consentId).getPsuAccountIban()).getBankCode();
        UpdateAuthResponse updateAuthResponse = this.consentService.selectPsuAuthenticationMethod(selectPsuAuthenticationMethodRequest, consentId);
        return ResponseEntity.ok((Object)this.mapToResource(updateAuthResponse, consentId, authorisationId, bankCode));
    }

    @Operation(description="Update authorisation (authorize transaction)")
    @PutMapping(value={"/transactionAuthorisation"})
    public ResponseEntity<Resource<UpdateAuthResponseTO>> transactionAuthorisation(@PathVariable String consentId, @PathVariable String authorisationId, @RequestBody @Valid TransactionAuthorisationRequestTO transactionAuthorisationRequest) {
        String bankCode = Iban.valueOf((String)this.consentService.getInternalConsent(consentId).getPsuAccountIban()).getBankCode();
        UpdateAuthResponse updateAuthResponse = this.consentService.authorizeConsent(transactionAuthorisationRequest, consentId);
        return ResponseEntity.ok((Object)this.mapToResource(updateAuthResponse, consentId, authorisationId, bankCode));
    }

    @Operation(description="Get consent authorisation status")
    @GetMapping
    public ResponseEntity<Resource<UpdateAuthResponseTO>> getConsentAuthorisationStatus(@PathVariable String consentId, @PathVariable String authorisationId) {
        String bankCode = Iban.valueOf((String)this.consentService.getInternalConsent(consentId).getPsuAccountIban()).getBankCode();
        UpdateAuthResponse updateAuthResponse = this.consentService.getAuthorisationStatus(consentId);
        return ResponseEntity.ok((Object)this.mapToResource(updateAuthResponse, consentId, authorisationId, bankCode));
    }

    private Resource<UpdateAuthResponseTO> mapToResource(UpdateAuthResponse response, String consentId, String authorisationId, String bankCode) {
        ArrayList<Link> links = new ArrayList<Link>();
        links.add(ControllerLinkBuilder.linkTo((Object)((ConsentAuthorisationController)ControllerLinkBuilder.methodOn(ConsentAuthorisationController.class, (Object[])new Object[0])).getConsentAuthorisationStatus(consentId, authorisationId)).withSelfRel());
        links.add(ControllerLinkBuilder.linkTo((Object)((BankController)ControllerLinkBuilder.methodOn(BankController.class, (Object[])new Object[0])).getBank(bankCode)).withRel("bank"));
        if (response.getScaApproach() != ScaApproach.REDIRECT && response.getScaApproach() != ScaApproach.OAUTH) {
            this.appendEmbeddedAuthLinks(response, consentId, authorisationId, links);
        }
        return new Resource((Object)this.consentAuthorisationMapper.toUpdateAuthResponseTO(response), links);
    }

    private void appendEmbeddedAuthLinks(UpdateAuthResponse response, String consentId, String authorisationId, List<Link> links) {
        switch (1.$SwitchMap$de$adorsys$multibanking$domain$ScaStatus[response.getScaStatus().ordinal()]) {
            case 1: 
            case 2: 
            case 3: {
                links.add(ControllerLinkBuilder.linkTo((Object)((ConsentAuthorisationController)ControllerLinkBuilder.methodOn(ConsentAuthorisationController.class, (Object[])new Object[0])).updateAuthentication(consentId, authorisationId, null)).withRel("updateAuthentication"));
                break;
            }
            case 4: {
                links.add(ControllerLinkBuilder.linkTo((Object)((ConsentAuthorisationController)ControllerLinkBuilder.methodOn(ConsentAuthorisationController.class, (Object[])new Object[0])).selectAuthenticationMethod(consentId, authorisationId, null)).withRel("selectAuthenticationMethod"));
                break;
            }
            case 5: {
                if (response.getScaApproach() != ScaApproach.EMBEDDED || response.getBankApi() == BankApi.HBCI) break;
                links.add(ControllerLinkBuilder.linkTo((Object)((ConsentAuthorisationController)ControllerLinkBuilder.methodOn(ConsentAuthorisationController.class, (Object[])new Object[0])).transactionAuthorisation(consentId, authorisationId, null)).withRel("transactionAuthorisation"));
                break;
            }
        }
    }

    public ConsentAuthorisationController(ConsentService consentService, ConsentAuthorisationMapper consentAuthorisationMapper) {
        this.consentService = consentService;
        this.consentAuthorisationMapper = consentAuthorisationMapper;
    }
}

