/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.metrics;

import de.adorsys.multibanking.domain.BankApi;
import de.adorsys.multibanking.domain.exception.MultibankingException;
import de.adorsys.multibanking.metrics.Bankgruppe;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.Timer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.springframework.boot.actuate.metrics.web.servlet.WebMvcTags;
import org.springframework.stereotype.Component;

@Component
public class MetricsCollector {
    private final MeterRegistry meterRegistry;

    public void count(String tag, String bankCode, BankApi bankApi) {
        this.count(tag, bankCode, bankApi, null);
    }

    public void count(String tag, String bankCode, BankApi bankApi, Throwable exception) {
        this.count(tag, bankCode, bankApi, exception, null);
    }

    public void count(String tag, String bankCode, BankApi bankApi, Throwable exception, String tanMedia) {
        ArrayList<Tag> tagList = new ArrayList<Tag>(Arrays.asList(Tag.of((String)"bank_code", (String)bankCode), Tag.of((String)"bank_group", (String)Bankgruppe.tagByBankCode((String)bankCode)), Tag.of((String)"bank_api", (String)(bankApi == null ? "undefined" : bankApi.toString())), Tag.of((String)"outcome", (String)(exception == null ? "SUCCESS" : "ERROR")), this.getExceptionTag(exception), tanMedia != null ? Tag.of((String)"tan_media", (String)tanMedia) : null));
        tagList.removeIf(Objects::isNull);
        this.meterRegistry.counter(tag, (Iterable)Tags.of(tagList)).increment();
    }

    public void time(String tag, String bankCode, BankApi bankApi, Throwable throwable, long duration) {
        Timer.builder((String)tag).tag("bank_code", bankCode).tag("bank_group", Bankgruppe.tagByBankCode((String)bankCode)).tag("bank_api", bankApi == null ? "undefined" : bankApi.toString()).tag("outcome", throwable == null ? "SUCCESS" : "ERROR").tag("exception", this.getExceptionTag(throwable).getValue()).register(this.meterRegistry).record(duration, TimeUnit.MILLISECONDS);
    }

    private Tag getExceptionTag(Throwable exception) {
        if (exception instanceof MultibankingException) {
            return Tag.of((String)"exception", (String)((MultibankingException)exception).getMultibankingError().toString());
        }
        return WebMvcTags.exception((Throwable)exception);
    }

    public MetricsCollector(MeterRegistry meterRegistry) {
        this.meterRegistry = meterRegistry;
    }
}

