package de.adorsys.multibanking.web.mapper;

import de.adorsys.multibanking.domain.ContractEntity;
import de.adorsys.multibanking.domain.Frequency;
import de.adorsys.multibanking.web.model.ContractTO;
import de.adorsys.multibanking.web.model.CycleTO;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Generated;
import org.springframework.stereotype.Component;

@Generated(
    value = "org.mapstruct.ap.MappingProcessor",
    date = "2020-03-06T11:06:50+0000",
    comments = "version: 1.3.0.Final, compiler: javac, environment: Java 1.8.0_242 (Private Build)"
)
@Component
public class ContractMapperImpl implements ContractMapper {

    @Override
    public ContractTO toContractTO(ContractEntity contractEntity) {
        if ( contractEntity == null ) {
            return null;
        }

        ContractTO contractTO = new ContractTO();

        contractTO.setId( contractEntity.getId() );
        contractTO.setLogo( contractEntity.getLogo() );
        contractTO.setHomepage( contractEntity.getHomepage() );
        contractTO.setHotline( contractEntity.getHotline() );
        contractTO.setEmail( contractEntity.getEmail() );
        contractTO.setMandateReference( contractEntity.getMandateReference() );
        contractTO.setInterval( frequencyToCycleTO( contractEntity.getInterval() ) );
        contractTO.setCancelled( contractEntity.isCancelled() );
        contractTO.setAmount( contractEntity.getAmount() );
        contractTO.setMainCategory( contractEntity.getMainCategory() );
        contractTO.setSubCategory( contractEntity.getSubCategory() );
        contractTO.setSpecification( contractEntity.getSpecification() );
        contractTO.setProvider( contractEntity.getProvider() );

        return contractTO;
    }

    @Override
    public List<ContractTO> toContractTOs(List<ContractEntity> contractEntities) {
        if ( contractEntities == null ) {
            return null;
        }

        List<ContractTO> list = new ArrayList<ContractTO>( contractEntities.size() );
        for ( ContractEntity contractEntity : contractEntities ) {
            list.add( toContractTO( contractEntity ) );
        }

        return list;
    }

    protected CycleTO frequencyToCycleTO(Frequency frequency) {
        if ( frequency == null ) {
            return null;
        }

        CycleTO cycleTO;

        switch ( frequency ) {
            case WEEKLY: cycleTO = CycleTO.WEEKLY;
            break;
            case TWO_WEEKLY: cycleTO = CycleTO.TWO_WEEKLY;
            break;
            case MONTHLY: cycleTO = CycleTO.MONTHLY;
            break;
            case TWO_MONTHLY: cycleTO = CycleTO.TWO_MONTHLY;
            break;
            case QUARTERLY: cycleTO = CycleTO.QUARTERLY;
            break;
            case HALF_YEARLY: cycleTO = CycleTO.HALF_YEARLY;
            break;
            case YEARLY: cycleTO = CycleTO.YEARLY;
            break;
            case INVALID: cycleTO = CycleTO.INVALID;
            break;
            default: throw new IllegalArgumentException( "Unexpected enum constant: " + frequency );
        }

        return cycleTO;
    }
}
