/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.web.mapper;

import de.adorsys.multibanking.domain.Balance;
import de.adorsys.multibanking.domain.BalancesReport;
import de.adorsys.multibanking.domain.BankAccount;
import de.adorsys.multibanking.domain.BankAccountType;
import de.adorsys.multibanking.domain.BankApi;
import de.adorsys.multibanking.domain.BookingCategory;
import de.adorsys.multibanking.domain.BookingEntity;
import de.adorsys.multibanking.domain.Frequency;
import de.adorsys.multibanking.web.mapper.BookingMapper;
import de.adorsys.multibanking.web.mapper.BookingMapperImpl;
import de.adorsys.multibanking.web.model.BalanceTO;
import de.adorsys.multibanking.web.model.BalancesReportTO;
import de.adorsys.multibanking.web.model.BankAccountTO;
import de.adorsys.multibanking.web.model.BankApiTO;
import de.adorsys.multibanking.web.model.BookingCategoryTO;
import de.adorsys.multibanking.web.model.BookingTO;
import de.adorsys.multibanking.web.model.CycleTO;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.stereotype.Component;

@Component
public class BookingMapperImpl
implements BookingMapper {
    public BookingTO toBookingTO(BookingEntity bookingEntity) {
        if (bookingEntity == null) {
            return null;
        }
        BookingTO bookingTO = new BookingTO();
        bookingTO.setId(bookingEntity.getId());
        bookingTO.setExternalId(bookingEntity.getExternalId());
        bookingTO.setOtherAccount(this.bankAccountToBankAccountTO(bookingEntity.getOtherAccount()));
        bookingTO.setValutaDate(bookingEntity.getValutaDate());
        bookingTO.setBookingDate(bookingEntity.getBookingDate());
        bookingTO.setAmount(bookingEntity.getAmount());
        bookingTO.setCurrency(bookingEntity.getCurrency());
        bookingTO.setReversal(bookingEntity.isReversal());
        bookingTO.setBalance(bookingEntity.getBalance());
        bookingTO.setCustomerRef(bookingEntity.getCustomerRef());
        bookingTO.setInstRef(bookingEntity.getInstRef());
        bookingTO.setOrigValue(bookingEntity.getOrigValue());
        bookingTO.setChargeValue(bookingEntity.getChargeValue());
        bookingTO.setText(bookingEntity.getText());
        bookingTO.setAdditional(bookingEntity.getAdditional());
        bookingTO.setPrimanota(bookingEntity.getPrimanota());
        bookingTO.setUsage(bookingEntity.getUsage());
        bookingTO.setAddkey(bookingEntity.getAddkey());
        bookingTO.setSepa(bookingEntity.isSepa());
        bookingTO.setStandingOrder(bookingEntity.isStandingOrder());
        bookingTO.setCreditorId(bookingEntity.getCreditorId());
        bookingTO.setMandateReference(bookingEntity.getMandateReference());
        bookingTO.setBankApi(this.bankApiToBankApiTO(bookingEntity.getBankApi()));
        bookingTO.setBookingCategory(this.bookingCategoryToBookingCategoryTO(bookingEntity.getBookingCategory()));
        bookingTO.setTransactionCode(bookingEntity.getTransactionCode());
        bookingTO.setProprietaryBankTransactionCode(bookingEntity.getProprietaryBankTransactionCode());
        return bookingTO;
    }

    public List<BookingTO> toBookingTOs(Iterable<BookingEntity> bookingEntities) {
        if (bookingEntities == null) {
            return null;
        }
        ArrayList<BookingTO> list = new ArrayList<BookingTO>();
        for (BookingEntity bookingEntity : bookingEntities) {
            list.add(this.toBookingTO(bookingEntity));
        }
        return list;
    }

    protected BalanceTO balanceToBalanceTO(Balance balance) {
        if (balance == null) {
            return null;
        }
        BalanceTO balanceTO = new BalanceTO();
        balanceTO.setDate(balance.getDate());
        balanceTO.setAmount(balance.getAmount());
        balanceTO.setCurrency(balance.getCurrency());
        return balanceTO;
    }

    protected BalancesReportTO balancesReportToBalancesReportTO(BalancesReport balancesReport) {
        if (balancesReport == null) {
            return null;
        }
        BalancesReportTO balancesReportTO = new BalancesReportTO();
        balancesReportTO.setReadyBalance(this.balanceToBalanceTO(balancesReport.getReadyBalance()));
        balancesReportTO.setUnreadyBalance(this.balanceToBalanceTO(balancesReport.getUnreadyBalance()));
        balancesReportTO.setCreditBalance(this.balanceToBalanceTO(balancesReport.getCreditBalance()));
        balancesReportTO.setAvailableBalance(this.balanceToBalanceTO(balancesReport.getAvailableBalance()));
        balancesReportTO.setUsedBalance(this.balanceToBalanceTO(balancesReport.getUsedBalance()));
        return balancesReportTO;
    }

    protected BankAccountTO.BankAccountTypeTO bankAccountTypeToBankAccountTypeTO(BankAccountType bankAccountType) {
        BankAccountTO.BankAccountTypeTO bankAccountTypeTO;
        if (bankAccountType == null) {
            return null;
        }
        switch (1.$SwitchMap$de$adorsys$multibanking$domain$BankAccountType[bankAccountType.ordinal()]) {
            case 1: {
                bankAccountTypeTO = BankAccountTO.BankAccountTypeTO.GIRO;
                break;
            }
            case 2: {
                bankAccountTypeTO = BankAccountTO.BankAccountTypeTO.SAVINGS;
                break;
            }
            case 3: {
                bankAccountTypeTO = BankAccountTO.BankAccountTypeTO.FIXEDTERMDEPOSIT;
                break;
            }
            case 4: {
                bankAccountTypeTO = BankAccountTO.BankAccountTypeTO.DEPOT;
                break;
            }
            case 5: {
                bankAccountTypeTO = BankAccountTO.BankAccountTypeTO.LOAN;
                break;
            }
            case 6: {
                bankAccountTypeTO = BankAccountTO.BankAccountTypeTO.CREDITCARD;
                break;
            }
            case 7: {
                bankAccountTypeTO = BankAccountTO.BankAccountTypeTO.BUIILDINGSAVING;
                break;
            }
            case 8: {
                bankAccountTypeTO = BankAccountTO.BankAccountTypeTO.INSURANCE;
                break;
            }
            case 9: {
                bankAccountTypeTO = BankAccountTO.BankAccountTypeTO.UNKNOWN;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected enum constant: " + bankAccountType);
            }
        }
        return bankAccountTypeTO;
    }

    protected BankAccountTO.SyncStatusTO syncStatusToSyncStatusTO(BankAccount.SyncStatus syncStatus) {
        BankAccountTO.SyncStatusTO syncStatusTO;
        if (syncStatus == null) {
            return null;
        }
        switch (1.$SwitchMap$de$adorsys$multibanking$domain$BankAccount$SyncStatus[syncStatus.ordinal()]) {
            case 1: {
                syncStatusTO = BankAccountTO.SyncStatusTO.PENDING;
                break;
            }
            case 2: {
                syncStatusTO = BankAccountTO.SyncStatusTO.SYNC;
                break;
            }
            case 3: {
                syncStatusTO = BankAccountTO.SyncStatusTO.READY;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected enum constant: " + syncStatus);
            }
        }
        return syncStatusTO;
    }

    protected BankAccountTO bankAccountToBankAccountTO(BankAccount bankAccount) {
        if (bankAccount == null) {
            return null;
        }
        BankAccountTO bankAccountTO = new BankAccountTO();
        bankAccountTO.setBalances(this.balancesReportToBalancesReportTO(bankAccount.getBalances()));
        bankAccountTO.setOwner(bankAccount.getOwner());
        bankAccountTO.setCountry(bankAccount.getCountry());
        bankAccountTO.setBlz(bankAccount.getBlz());
        bankAccountTO.setBankName(bankAccount.getBankName());
        bankAccountTO.setAccountNumber(bankAccount.getAccountNumber());
        bankAccountTO.setType(this.bankAccountTypeToBankAccountTypeTO(bankAccount.getType()));
        bankAccountTO.setCurrency(bankAccount.getCurrency());
        bankAccountTO.setName(bankAccount.getName());
        bankAccountTO.setBic(bankAccount.getBic());
        bankAccountTO.setIban(bankAccount.getIban());
        bankAccountTO.setSyncStatus(this.syncStatusToSyncStatusTO(bankAccount.getSyncStatus()));
        bankAccountTO.setLastSync(bankAccount.getLastSync());
        return bankAccountTO;
    }

    protected BankApiTO bankApiToBankApiTO(BankApi bankApi) {
        BankApiTO bankApiTO;
        if (bankApi == null) {
            return null;
        }
        switch (1.$SwitchMap$de$adorsys$multibanking$domain$BankApi[bankApi.ordinal()]) {
            case 1: {
                bankApiTO = BankApiTO.HBCI;
                break;
            }
            case 2: {
                bankApiTO = BankApiTO.XS2A;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected enum constant: " + bankApi);
            }
        }
        return bankApiTO;
    }

    protected CycleTO frequencyToCycleTO(Frequency frequency) {
        CycleTO cycleTO;
        if (frequency == null) {
            return null;
        }
        switch (1.$SwitchMap$de$adorsys$multibanking$domain$Frequency[frequency.ordinal()]) {
            case 1: {
                cycleTO = CycleTO.WEEKLY;
                break;
            }
            case 2: {
                cycleTO = CycleTO.TWO_WEEKLY;
                break;
            }
            case 3: {
                cycleTO = CycleTO.MONTHLY;
                break;
            }
            case 4: {
                cycleTO = CycleTO.TWO_MONTHLY;
                break;
            }
            case 5: {
                cycleTO = CycleTO.QUARTERLY;
                break;
            }
            case 6: {
                cycleTO = CycleTO.HALF_YEARLY;
                break;
            }
            case 7: {
                cycleTO = CycleTO.YEARLY;
                break;
            }
            case 8: {
                cycleTO = CycleTO.INVALID;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected enum constant: " + frequency);
            }
        }
        return cycleTO;
    }

    protected BookingCategoryTO bookingCategoryToBookingCategoryTO(BookingCategory bookingCategory) {
        if (bookingCategory == null) {
            return null;
        }
        BookingCategoryTO bookingCategoryTO = new BookingCategoryTO();
        bookingCategoryTO.setLogo(bookingCategory.getLogo());
        bookingCategoryTO.setHomepage(bookingCategory.getHomepage());
        bookingCategoryTO.setHotline(bookingCategory.getHotline());
        bookingCategoryTO.setEmail(bookingCategory.getEmail());
        bookingCategoryTO.setMandateReference(bookingCategory.getMandateReference());
        bookingCategoryTO.setInterval(this.frequencyToCycleTO(bookingCategory.getInterval()));
        bookingCategoryTO.setCancelled(bookingCategory.isCancelled());
        bookingCategoryTO.setAmount(bookingCategory.getAmount());
        bookingCategoryTO.setMainCategory(bookingCategory.getMainCategory());
        bookingCategoryTO.setSubCategory(bookingCategory.getSubCategory());
        bookingCategoryTO.setSpecification(bookingCategory.getSpecification());
        bookingCategoryTO.setProvider(bookingCategory.getProvider());
        Set set = bookingCategory.getRules();
        if (set != null) {
            bookingCategoryTO.setRules(new HashSet(set));
        }
        bookingCategoryTO.setReceiver(bookingCategory.getReceiver());
        Map map = bookingCategory.getCustom();
        if (map != null) {
            bookingCategoryTO.setCustom(new HashMap(map));
        }
        return bookingCategoryTO;
    }
}

