/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.service.analytics;

import de.adorsys.multibanking.domain.BankAccount;
import de.adorsys.multibanking.domain.BookingCategory;
import de.adorsys.multibanking.domain.BookingEntity;
import de.adorsys.multibanking.domain.BookingGroup;
import de.adorsys.multibanking.domain.BookingPeriod;
import de.adorsys.multibanking.domain.Contract;
import de.adorsys.multibanking.domain.ContractEntity;
import de.adorsys.multibanking.domain.Frequency;
import de.adorsys.multibanking.service.analytics.SmartAnalyticsMapper;
import de.adorsys.multibanking.service.analytics.SmartAnalyticsMapperImpl;
import de.adorsys.smartanalytics.api.Booking;
import de.adorsys.smartanalytics.api.BookingGroup;
import de.adorsys.smartanalytics.api.Cycle;
import de.adorsys.smartanalytics.api.ExecutedBooking;
import de.adorsys.smartanalytics.api.WrappedBooking;
import de.adorsys.smartanalytics.api.config.Group;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.stereotype.Component;

@Component
public class SmartAnalyticsMapperImpl
extends SmartAnalyticsMapper {
    BookingCategory toBookingcategory(WrappedBooking wrappedBooking) {
        if (wrappedBooking == null) {
            return null;
        }
        BookingCategory bookingCategory = new BookingCategory();
        bookingCategory.setInterval(this.cycleToFrequency(wrappedBooking.getCycle()));
        bookingCategory.setReceiver(wrappedBooking.getOtherAccount());
        Set set = wrappedBooking.getRuleIds();
        if (set != null) {
            bookingCategory.setRules(new HashSet(set));
        }
        bookingCategory.setLogo(wrappedBooking.getLogo());
        bookingCategory.setHomepage(wrappedBooking.getHomepage());
        bookingCategory.setHotline(wrappedBooking.getHotline());
        bookingCategory.setEmail(wrappedBooking.getEmail());
        bookingCategory.setMandateReference(wrappedBooking.getMandateReference());
        bookingCategory.setAmount(wrappedBooking.getAmount());
        bookingCategory.setMainCategory(wrappedBooking.getMainCategory());
        bookingCategory.setSubCategory(wrappedBooking.getSubCategory());
        bookingCategory.setSpecification(wrappedBooking.getSpecification());
        Map map = wrappedBooking.getCustom();
        if (map != null) {
            bookingCategory.setCustom(new HashMap(map));
        }
        return bookingCategory;
    }

    List<de.adorsys.multibanking.domain.BookingGroup> mapBookingGroups(List<BookingGroup> bookingGroups) {
        if (bookingGroups == null) {
            return null;
        }
        ArrayList<de.adorsys.multibanking.domain.BookingGroup> list = new ArrayList<de.adorsys.multibanking.domain.BookingGroup>(bookingGroups.size());
        for (BookingGroup bookingGroup : bookingGroups) {
            list.add(this.mapBookingGroup(bookingGroup));
        }
        return list;
    }

    de.adorsys.multibanking.domain.BookingGroup mapBookingGroup(BookingGroup bookingGroup) {
        if (bookingGroup == null) {
            return null;
        }
        BookingGroup.BookingGroupBuilder bookingGroup1 = de.adorsys.multibanking.domain.BookingGroup.builder();
        bookingGroup1.type(this.typeToType(bookingGroup.getGroupType()));
        bookingGroup1.contract(this.toContract(bookingGroup));
        bookingGroup1.name(bookingGroup.getName());
        bookingGroup1.salaryWage(bookingGroup.isSalaryWage());
        bookingGroup1.mainCategory(bookingGroup.getMainCategory());
        bookingGroup1.subCategory(bookingGroup.getSubCategory());
        bookingGroup1.specification(bookingGroup.getSpecification());
        bookingGroup1.amount(bookingGroup.getAmount());
        bookingGroup1.bookingPeriods(this.bookingPeriodListToBookingPeriodList(bookingGroup.getBookingPeriods()));
        this.mapBookingGroupAfterMapping(bookingGroup, bookingGroup1);
        return bookingGroup1.build();
    }

    Contract toContract(BookingGroup bookingsGroup) {
        if (bookingsGroup == null) {
            return null;
        }
        Contract contract = new Contract();
        contract.setMandateReference(bookingsGroup.getMandatreference());
        contract.setInterval(this.cycleToFrequency(bookingsGroup.getCycle()));
        contract.setLogo(bookingsGroup.getLogo());
        contract.setHomepage(bookingsGroup.getHomepage());
        contract.setHotline(bookingsGroup.getHotline());
        contract.setEmail(bookingsGroup.getEmail());
        contract.setCancelled(bookingsGroup.isCancelled());
        contract.setAmount(bookingsGroup.getAmount());
        contract.setMainCategory(bookingsGroup.getMainCategory());
        contract.setSubCategory(bookingsGroup.getSubCategory());
        contract.setSpecification(bookingsGroup.getSpecification());
        return contract;
    }

    ContractEntity toContractEntity(String userId, String accountId, BookingGroup bookingGroup) {
        if (userId == null && accountId == null && bookingGroup == null) {
            return null;
        }
        ContractEntity contractEntity = new ContractEntity();
        if (userId != null) {
            contractEntity.setUserId(userId);
        }
        if (accountId != null) {
            contractEntity.setAccountId(accountId);
        }
        if (bookingGroup != null) {
            contractEntity.setMandateReference(bookingGroup.getMandatreference());
            contractEntity.setInterval(this.cycleToFrequency(bookingGroup.getCycle()));
            contractEntity.setProvider(bookingGroup.getOtherAccount());
            contractEntity.setLogo(bookingGroup.getLogo());
            contractEntity.setHomepage(bookingGroup.getHomepage());
            contractEntity.setHotline(bookingGroup.getHotline());
            contractEntity.setEmail(bookingGroup.getEmail());
            contractEntity.setCancelled(bookingGroup.isCancelled());
            contractEntity.setAmount(bookingGroup.getAmount());
            contractEntity.setMainCategory(bookingGroup.getMainCategory());
            contractEntity.setSubCategory(bookingGroup.getSubCategory());
            contractEntity.setSpecification(bookingGroup.getSpecification());
        }
        return contractEntity;
    }

    List<Booking> toSmartAnalyticsBookings(Collection<BookingEntity> bookings) {
        if (bookings == null) {
            return null;
        }
        ArrayList<Booking> list = new ArrayList<Booking>(bookings.size());
        for (BookingEntity bookingEntity : bookings) {
            list.add(this.toSmartAnalyticsBooking(bookingEntity));
        }
        return list;
    }

    Booking toSmartAnalyticsBooking(BookingEntity booking) {
        if (booking == null) {
            return null;
        }
        Booking booking1 = new Booking();
        booking1.setBookingId(booking.getExternalId());
        booking1.setPurpose(booking.getUsage());
        booking1.setExecutionDate(booking.getValutaDate());
        booking1.setIban(this.bookingOtherAccountIban(booking));
        booking1.setAccountNumber(this.bookingOtherAccountAccountNumber(booking));
        booking1.setBankCode(this.bookingOtherAccountBlz(booking));
        booking1.setAmount(booking.getAmount());
        booking1.setCreditorId(booking.getCreditorId());
        booking1.setStandingOrder(booking.isStandingOrder());
        booking1.setMandateReference(booking.getMandateReference());
        this.toSmartAnalyticsBookingAfterMapping(booking, booking1);
        return booking1;
    }

    protected Frequency cycleToFrequency(Cycle cycle) {
        Frequency frequency;
        if (cycle == null) {
            return null;
        }
        switch (1.$SwitchMap$de$adorsys$smartanalytics$api$Cycle[cycle.ordinal()]) {
            case 1: {
                frequency = Frequency.WEEKLY;
                break;
            }
            case 2: {
                frequency = Frequency.MONTHLY;
                break;
            }
            case 3: {
                frequency = Frequency.TWO_MONTHLY;
                break;
            }
            case 4: {
                frequency = Frequency.QUARTERLY;
                break;
            }
            case 5: {
                frequency = Frequency.HALF_YEARLY;
                break;
            }
            case 6: {
                frequency = Frequency.YEARLY;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected enum constant: " + cycle);
            }
        }
        return frequency;
    }

    protected BookingGroup.Type typeToType(Group.Type type) {
        BookingGroup.Type type1;
        if (type == null) {
            return null;
        }
        switch (1.$SwitchMap$de$adorsys$smartanalytics$api$config$Group$Type[type.ordinal()]) {
            case 1: {
                type1 = BookingGroup.Type.STANDING_ORDER;
                break;
            }
            case 2: {
                type1 = BookingGroup.Type.RECURRENT_INCOME;
                break;
            }
            case 3: {
                type1 = BookingGroup.Type.RECURRENT_SEPA;
                break;
            }
            case 4: {
                type1 = BookingGroup.Type.RECURRENT_NONSEPA;
                break;
            }
            case 5: {
                type1 = BookingGroup.Type.CUSTOM;
                break;
            }
            case 6: {
                type1 = BookingGroup.Type.OTHER_INCOME;
                break;
            }
            case 7: {
                type1 = BookingGroup.Type.OTHER_EXPENSES;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected enum constant: " + type);
            }
        }
        return type1;
    }

    protected de.adorsys.multibanking.domain.ExecutedBooking executedBookingToExecutedBooking(ExecutedBooking executedBooking) {
        if (executedBooking == null) {
            return null;
        }
        de.adorsys.multibanking.domain.ExecutedBooking executedBooking1 = new de.adorsys.multibanking.domain.ExecutedBooking();
        executedBooking1.setBookingId(executedBooking.getBookingId());
        executedBooking1.setExecutionDate(executedBooking.getExecutionDate());
        executedBooking1.setExecuted(executedBooking.isExecuted());
        return executedBooking1;
    }

    protected List<de.adorsys.multibanking.domain.ExecutedBooking> executedBookingListToExecutedBookingList(List<ExecutedBooking> list) {
        if (list == null) {
            return null;
        }
        ArrayList<de.adorsys.multibanking.domain.ExecutedBooking> list1 = new ArrayList<de.adorsys.multibanking.domain.ExecutedBooking>(list.size());
        for (ExecutedBooking executedBooking : list) {
            list1.add(this.executedBookingToExecutedBooking(executedBooking));
        }
        return list1;
    }

    protected BookingPeriod bookingPeriodToBookingPeriod(de.adorsys.smartanalytics.api.BookingPeriod bookingPeriod) {
        if (bookingPeriod == null) {
            return null;
        }
        BookingPeriod.BookingPeriodBuilder bookingPeriod1 = BookingPeriod.builder();
        bookingPeriod1.start(bookingPeriod.getStart());
        bookingPeriod1.end(bookingPeriod.getEnd());
        bookingPeriod1.amount(bookingPeriod.getAmount());
        bookingPeriod1.bookings(this.executedBookingListToExecutedBookingList(bookingPeriod.getBookings()));
        return bookingPeriod1.build();
    }

    protected List<BookingPeriod> bookingPeriodListToBookingPeriodList(List<de.adorsys.smartanalytics.api.BookingPeriod> list) {
        if (list == null) {
            return null;
        }
        ArrayList<BookingPeriod> list1 = new ArrayList<BookingPeriod>(list.size());
        for (de.adorsys.smartanalytics.api.BookingPeriod bookingPeriod : list) {
            list1.add(this.bookingPeriodToBookingPeriod(bookingPeriod));
        }
        return list1;
    }

    private String bookingOtherAccountIban(BookingEntity bookingEntity) {
        if (bookingEntity == null) {
            return null;
        }
        BankAccount otherAccount = bookingEntity.getOtherAccount();
        if (otherAccount == null) {
            return null;
        }
        String iban = otherAccount.getIban();
        if (iban == null) {
            return null;
        }
        return iban;
    }

    private String bookingOtherAccountAccountNumber(BookingEntity bookingEntity) {
        if (bookingEntity == null) {
            return null;
        }
        BankAccount otherAccount = bookingEntity.getOtherAccount();
        if (otherAccount == null) {
            return null;
        }
        String accountNumber = otherAccount.getAccountNumber();
        if (accountNumber == null) {
            return null;
        }
        return accountNumber;
    }

    private String bookingOtherAccountBlz(BookingEntity bookingEntity) {
        if (bookingEntity == null) {
            return null;
        }
        BankAccount otherAccount = bookingEntity.getOtherAccount();
        if (otherAccount == null) {
            return null;
        }
        String blz = otherAccount.getBlz();
        if (blz == null) {
            return null;
        }
        return blz;
    }
}

