/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.service;

import de.adorsys.multibanking.domain.BankApi;
import de.adorsys.multibanking.domain.BankEntity;
import de.adorsys.multibanking.domain.Consent;
import de.adorsys.multibanking.domain.ConsentEntity;
import de.adorsys.multibanking.domain.ConsentStatus;
import de.adorsys.multibanking.domain.ScaStatus;
import de.adorsys.multibanking.domain.exception.MultibankingException;
import de.adorsys.multibanking.domain.request.SelectPsuAuthenticationMethodRequest;
import de.adorsys.multibanking.domain.request.TransactionAuthorisationRequest;
import de.adorsys.multibanking.domain.request.UpdatePsuAuthenticationRequest;
import de.adorsys.multibanking.domain.response.CreateConsentResponse;
import de.adorsys.multibanking.domain.response.UpdateAuthResponse;
import de.adorsys.multibanking.domain.spi.OnlineBankingService;
import de.adorsys.multibanking.exception.MissingScaMethodSelectionException;
import de.adorsys.multibanking.exception.ResourceNotFoundException;
import de.adorsys.multibanking.exception.TransactionAuthorisationRequiredException;
import de.adorsys.multibanking.metrics.MetricsCollector;
import de.adorsys.multibanking.pers.spi.repository.ConsentRepositoryIf;
import de.adorsys.multibanking.service.BankService;
import de.adorsys.multibanking.service.ConsentService;
import de.adorsys.multibanking.service.OnlineBankingServiceProducer;
import de.adorsys.multibanking.web.mapper.ConsentAuthorisationMapper;
import de.adorsys.multibanking.web.mapper.ConsentMapper;
import de.adorsys.multibanking.web.model.ConsentTO;
import de.adorsys.multibanking.web.model.SelectPsuAuthenticationMethodRequestTO;
import de.adorsys.multibanking.web.model.TransactionAuthorisationRequestTO;
import de.adorsys.multibanking.web.model.UpdatePsuAuthenticationRequestTO;
import java.util.Optional;
import org.iban4j.Iban;
import org.springframework.stereotype.Service;

@Service
public class ConsentService {
    private final ConsentRepositoryIf consentRepository;
    private final OnlineBankingServiceProducer bankingServiceProducer;
    private final ConsentAuthorisationMapper consentAuthorisationMapper;
    private final ConsentMapper consentMapper;
    private final BankService bankService;
    private final MetricsCollector metricsCollector;

    public CreateConsentResponse createConsent(Consent consent, String tppRedirectUri, BankApi bankApi) {
        ConsentEntity tempConsentEntity = Optional.ofNullable(consent.getConsentId()).flatMap(arg_0 -> ((ConsentRepositoryIf)this.consentRepository).findById(arg_0)).orElse(null);
        OnlineBankingService onlineBankingService = this.getOnlineBankingService(bankApi, consent.getPsuAccountIban());
        BankEntity bank = this.bankService.findBank(Iban.valueOf((String)consent.getPsuAccountIban()).getBankCode());
        try {
            CreateConsentResponse createConsentResponse = onlineBankingService.getStrongCustomerAuthorisation().createConsent(consent, bank.isRedirectPreferred(), tppRedirectUri, tempConsentEntity != null ? tempConsentEntity.getBankApiConsentData() : null);
            createConsentResponse.setRedirectId(consent.getRedirectId());
            if (tempConsentEntity != null) {
                this.consentRepository.delete(tempConsentEntity);
            }
            ConsentEntity consentEntity = this.consentMapper.toConsentEntity(createConsentResponse, consent.getRedirectId(), consent.getPsuAccountIban(), onlineBankingService.bankApi());
            consentEntity.setTemporary(createConsentResponse.getConsentId() == null);
            this.consentRepository.save(consentEntity);
            createConsentResponse.setConsentId(consentEntity.getId());
            this.metricsCollector.count("createConsent", bank.getBankCode(), onlineBankingService.bankApi());
            return createConsentResponse;
        }
        catch (Exception e) {
            this.metricsCollector.count("createConsent", bank.getBankCode(), onlineBankingService.bankApi(), (Throwable)e);
            throw e;
        }
    }

    public UpdateAuthResponse updatePsuAuthentication(UpdatePsuAuthenticationRequestTO updatePsuAuthenticationRequestTO, String consentId) {
        ConsentEntity internalConsent = (ConsentEntity)this.consentRepository.findById(consentId).orElseThrow(() -> new ResourceNotFoundException(ConsentEntity.class, consentId));
        OnlineBankingService onlineBankingService = this.bankingServiceProducer.getBankingService(internalConsent.getBankApi());
        BankEntity bank = this.bankService.findBank(Iban.valueOf((String)internalConsent.getPsuAccountIban()).getBankCode());
        UpdatePsuAuthenticationRequest updatePsuAuthenticationRequest = this.consentAuthorisationMapper.toUpdatePsuAuthenticationRequest(updatePsuAuthenticationRequestTO, internalConsent, bank);
        try {
            UpdateAuthResponse response = onlineBankingService.getStrongCustomerAuthorisation().updatePsuAuthentication(updatePsuAuthenticationRequest);
            internalConsent.setBankApiConsentData(updatePsuAuthenticationRequest.getBankApiConsentData());
            this.consentRepository.save(internalConsent);
            this.metricsCollector.count("updatePsuAuthentication", bank.getBankCode(), onlineBankingService.bankApi());
            return response;
        }
        catch (Exception e) {
            this.metricsCollector.count("updatePsuAuthentication", bank.getBankCode(), onlineBankingService.bankApi(), (Throwable)e);
            throw e;
        }
    }

    public UpdateAuthResponse selectPsuAuthenticationMethod(SelectPsuAuthenticationMethodRequestTO selectPsuAuthenticationMethodRequestTO, String consentId) {
        ConsentEntity internalConsent = (ConsentEntity)this.consentRepository.findById(consentId).orElseThrow(() -> new ResourceNotFoundException(ConsentEntity.class, consentId));
        OnlineBankingService onlineBankingService = this.bankingServiceProducer.getBankingService(internalConsent.getBankApi());
        SelectPsuAuthenticationMethodRequest selectPsuAuthenticationMethodRequest = this.consentAuthorisationMapper.toSelectPsuAuthenticationMethodRequest(selectPsuAuthenticationMethodRequestTO, internalConsent);
        try {
            UpdateAuthResponse response = onlineBankingService.getStrongCustomerAuthorisation().selectPsuAuthenticationMethod(selectPsuAuthenticationMethodRequest);
            internalConsent.setBankApiConsentData(selectPsuAuthenticationMethodRequest.getBankApiConsentData());
            this.consentRepository.save(internalConsent);
            this.metricsCollector.count("selectPsuAuthenticationMethod", Iban.valueOf((String)internalConsent.getPsuAccountIban()).getBankCode(), onlineBankingService.bankApi());
            return response;
        }
        catch (Exception e) {
            this.metricsCollector.count("selectPsuAuthenticationMethod", Iban.valueOf((String)internalConsent.getPsuAccountIban()).getBankCode(), onlineBankingService.bankApi(), (Throwable)e);
            throw e;
        }
    }

    public UpdateAuthResponse authorizeConsent(TransactionAuthorisationRequestTO transactionAuthorisationRequestTO, String consentId) {
        ConsentEntity internalConsent = (ConsentEntity)this.consentRepository.findById(consentId).orElseThrow(() -> new ResourceNotFoundException(ConsentEntity.class, consentId));
        OnlineBankingService onlineBankingService = this.bankingServiceProducer.getBankingService(internalConsent.getBankApi());
        TransactionAuthorisationRequest transactionAuthorisationRequest = this.consentAuthorisationMapper.toTransactionAuthorisationRequest(transactionAuthorisationRequestTO, internalConsent);
        try {
            UpdateAuthResponse response = onlineBankingService.getStrongCustomerAuthorisation().authorizeConsent(transactionAuthorisationRequest);
            internalConsent.setBankApiConsentData(transactionAuthorisationRequest.getBankApiConsentData());
            this.consentRepository.save(internalConsent);
            this.metricsCollector.count("authorizeConsent", Iban.valueOf((String)internalConsent.getPsuAccountIban()).getBankCode(), onlineBankingService.bankApi());
            return response;
        }
        catch (Exception e) {
            this.metricsCollector.count("authorizeConsent", Iban.valueOf((String)internalConsent.getPsuAccountIban()).getBankCode(), onlineBankingService.bankApi(), (Throwable)e);
            throw e;
        }
    }

    public void revokeConsent(String consentId) {
        ConsentEntity internalConsent = (ConsentEntity)this.consentRepository.findById(consentId).orElseThrow(() -> new ResourceNotFoundException(ConsentEntity.class, consentId));
        OnlineBankingService onlineBankingService = this.bankingServiceProducer.getBankingService(internalConsent.getBankApi());
        onlineBankingService.getStrongCustomerAuthorisation().revokeConsent(consentId, internalConsent.getBankApiConsentData());
        throw new ResourceNotFoundException(ConsentTO.class, consentId);
    }

    public ConsentEntity getInternalConsent(String consentId) {
        return (ConsentEntity)this.consentRepository.findById(consentId).orElseThrow(() -> new ResourceNotFoundException(ConsentEntity.class, consentId));
    }

    public Consent getConsent(String consentId) {
        ConsentEntity internalConsent = (ConsentEntity)this.consentRepository.findById(consentId).orElseThrow(() -> new ResourceNotFoundException(ConsentEntity.class, consentId));
        if (internalConsent.isTemporary()) {
            return this.consentMapper.toConsent(internalConsent);
        }
        OnlineBankingService onlineBankingService = this.bankingServiceProducer.getBankingService(internalConsent.getBankApi());
        return onlineBankingService.getStrongCustomerAuthorisation().getConsent(consentId, internalConsent.getBankApiConsentData());
    }

    public ConsentStatus getConsentStatus(String consentId) {
        ConsentEntity internalConsent = (ConsentEntity)this.consentRepository.findById(consentId).orElseThrow(() -> new ResourceNotFoundException(ConsentEntity.class, consentId));
        if (internalConsent.isTemporary()) {
            return null;
        }
        OnlineBankingService onlineBankingService = this.bankingServiceProducer.getBankingService(internalConsent.getBankApi());
        return onlineBankingService.getStrongCustomerAuthorisation().getConsentStatus(consentId, internalConsent.getBankApiConsentData());
    }

    public Consent getConsentByRedirectId(String redirectId) {
        ConsentEntity internalConsent = (ConsentEntity)this.consentRepository.findByRedirectId(redirectId).orElseThrow(() -> new ResourceNotFoundException(ConsentEntity.class, redirectId));
        if (internalConsent.isTemporary()) {
            return this.consentMapper.toConsent(internalConsent);
        }
        OnlineBankingService onlineBankingService = this.bankingServiceProducer.getBankingService(internalConsent.getBankApi());
        return onlineBankingService.getStrongCustomerAuthorisation().getConsent(internalConsent.getId(), internalConsent.getBankApiConsentData());
    }

    public UpdateAuthResponse getAuthorisationStatus(String consentId) {
        ConsentEntity internalConsent = (ConsentEntity)this.consentRepository.findById(consentId).orElseThrow(() -> new ResourceNotFoundException(ConsentEntity.class, consentId));
        return this.getAuthorisationStatus(internalConsent);
    }

    public UpdateAuthResponse getAuthorisationStatus(ConsentEntity consentEntity) {
        OnlineBankingService onlineBankingService = this.bankingServiceProducer.getBankingService(consentEntity.getBankApi());
        return onlineBankingService.getStrongCustomerAuthorisation().getAuthorisationStatus(consentEntity.getId(), consentEntity.getAuthorisationId(), consentEntity.getBankApiConsentData());
    }

    public void submitAuthorisationCode(String consentId, String authorisationCode) {
        ConsentEntity internalConsent = (ConsentEntity)this.consentRepository.findById(consentId).orElseThrow(() -> new ResourceNotFoundException(ConsentEntity.class, consentId));
        OnlineBankingService onlineBankingService = this.bankingServiceProducer.getBankingService(internalConsent.getBankApi());
        onlineBankingService.getStrongCustomerAuthorisation().submitAuthorisationCode(internalConsent.getBankApiConsentData(), authorisationCode);
        this.consentRepository.save(internalConsent);
    }

    private OnlineBankingService getOnlineBankingService(BankApi bankApi, String iban) {
        return bankApi != null ? this.bankingServiceProducer.getBankingService(bankApi) : this.bankingServiceProducer.getBankingService(Iban.valueOf((String)iban).getBankCode());
    }

    ConsentEntity validateAndGetConsent(OnlineBankingService onlineBankingService, String consentId, ScaStatus expectedConsentStatus) {
        ConsentEntity internalConsent = (ConsentEntity)this.consentRepository.findById(consentId).orElseThrow(() -> new ResourceNotFoundException(ConsentEntity.class, consentId));
        try {
            onlineBankingService.getStrongCustomerAuthorisation().validateConsent(internalConsent.getId(), internalConsent.getAuthorisationId(), expectedConsentStatus, internalConsent.getBankApiConsentData());
        }
        catch (MultibankingException e) {
            switch (1.$SwitchMap$de$adorsys$multibanking$domain$exception$MultibankingError[e.getMultibankingError().ordinal()]) {
                case 1: {
                    throw new MissingScaMethodSelectionException();
                }
                case 2: {
                    if (expectedConsentStatus == ScaStatus.FINALISED) {
                        UpdateAuthResponse authorisationStatus = this.getAuthorisationStatus(internalConsent);
                        throw new TransactionAuthorisationRequiredException(authorisationStatus, internalConsent.getId(), internalConsent.getAuthorisationId());
                    }
                    if (expectedConsentStatus == ScaStatus.SCAMETHODSELECTED) {
                        throw new MissingScaMethodSelectionException();
                    }
                    throw e;
                }
            }
            throw e;
        }
        return internalConsent;
    }

    public ConsentService(ConsentRepositoryIf consentRepository, OnlineBankingServiceProducer bankingServiceProducer, ConsentAuthorisationMapper consentAuthorisationMapper, ConsentMapper consentMapper, BankService bankService, MetricsCollector metricsCollector) {
        this.consentRepository = consentRepository;
        this.bankingServiceProducer = bankingServiceProducer;
        this.consentAuthorisationMapper = consentAuthorisationMapper;
        this.consentMapper = consentMapper;
        this.bankService = bankService;
        this.metricsCollector = metricsCollector;
    }
}

