/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.service;

import de.adorsys.multibanking.domain.Bank;
import de.adorsys.multibanking.domain.BankAccess;
import de.adorsys.multibanking.domain.BankAccessEntity;
import de.adorsys.multibanking.domain.BankAccount;
import de.adorsys.multibanking.domain.BankAccountEntity;
import de.adorsys.multibanking.domain.BankApi;
import de.adorsys.multibanking.domain.BankApiUser;
import de.adorsys.multibanking.domain.BankEntity;
import de.adorsys.multibanking.domain.Booking;
import de.adorsys.multibanking.domain.BookingEntity;
import de.adorsys.multibanking.domain.BookingsIndexEntity;
import de.adorsys.multibanking.domain.ConsentEntity;
import de.adorsys.multibanking.domain.ScaStatus;
import de.adorsys.multibanking.domain.StandingOrder;
import de.adorsys.multibanking.domain.StandingOrderEntity;
import de.adorsys.multibanking.domain.exception.MultibankingException;
import de.adorsys.multibanking.domain.request.TransactionRequest;
import de.adorsys.multibanking.domain.request.TransactionRequestFactory;
import de.adorsys.multibanking.domain.response.AbstractResponse;
import de.adorsys.multibanking.domain.response.TransactionsResponse;
import de.adorsys.multibanking.domain.spi.OnlineBankingService;
import de.adorsys.multibanking.domain.transaction.AbstractTransaction;
import de.adorsys.multibanking.domain.transaction.LoadAccounts;
import de.adorsys.multibanking.domain.transaction.LoadTransactions;
import de.adorsys.multibanking.metrics.MetricsCollector;
import de.adorsys.multibanking.pers.spi.repository.AnalyticsRepositoryIf;
import de.adorsys.multibanking.pers.spi.repository.BankAccessRepositoryIf;
import de.adorsys.multibanking.pers.spi.repository.BankAccountRepositoryIf;
import de.adorsys.multibanking.pers.spi.repository.BookingRepositoryIf;
import de.adorsys.multibanking.pers.spi.repository.BookingsIndexRepositoryIf;
import de.adorsys.multibanking.pers.spi.repository.StandingOrderRepositoryIf;
import de.adorsys.multibanking.service.AccountInformationService;
import de.adorsys.multibanking.service.AnonymizationService;
import de.adorsys.multibanking.service.BankService;
import de.adorsys.multibanking.service.ConsentService;
import de.adorsys.multibanking.service.OnlineBankingServiceProducer;
import de.adorsys.multibanking.service.UserService;
import de.adorsys.multibanking.service.analytics.AnalyticsService;
import de.adorsys.multibanking.service.analytics.SmartAnalyticsIf;
import de.adorsys.multibanking.service.analytics.SmartAnalyticsMapper;
import de.adorsys.smartanalytics.api.AnalyticsResult;
import de.adorsys.smartanalytics.api.config.ConfigStatus;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.lang.Nullable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BookingService
extends AccountInformationService {
    private static final Logger log = LoggerFactory.getLogger(BookingService.class);
    private final BankAccessRepositoryIf bankAccessRepository;
    private final BankAccountRepositoryIf bankAccountRepository;
    private final BookingRepositoryIf bookingRepository;
    private final BookingsIndexRepositoryIf bookingsIndexRepository;
    private final StandingOrderRepositoryIf standingOrderRepository;
    private final AnalyticsRepositoryIf analyticsRepository;
    private final SmartAnalyticsIf smartAnalyticsService;
    private final AnalyticsService analyticsService;
    private final AnonymizationService anonymizationService;
    private final ConsentService consentService;
    private final BankService bankService;
    private final UserService userService;
    private final OnlineBankingServiceProducer bankingServiceProducer;
    private final SmartAnalyticsMapper smartAnalyticsMapper;
    private final MetricsCollector metricsCollector;

    public String getBookingsCsv(String userId, String accessId, String accountId) {
        List bookings = this.getBookings(userId, accessId, accountId);
        StringBuilder builder = new StringBuilder();
        bookings.forEach(bookingEntity -> {
            builder.append(bookingEntity.getBookingDate() != null ? bookingEntity.getBookingDate().toString() : "");
            builder.append(";");
            builder.append(bookingEntity.getOtherAccount() != null ? bookingEntity.getOtherAccount().getOwner() : "");
            builder.append(";");
            builder.append(bookingEntity.getBookingCategory() != null ? bookingEntity.getBookingCategory().getMainCategory() : "");
            builder.append(";");
            builder.append(bookingEntity.getBookingCategory() != null ? bookingEntity.getBookingCategory().getSubCategory() : "");
            builder.append(";");
            builder.append(bookingEntity.getBookingCategory() != null ? bookingEntity.getBookingCategory().getSpecification() : "");
            builder.append(";");
            builder.append(bookingEntity.getAmount() != null ? bookingEntity.getAmount().toString() : "");
            builder.append(";");
            builder.append(bookingEntity.getCreditorId() != null ? bookingEntity.getCreditorId() : "");
            builder.append(";");
            builder.append(bookingEntity.getUsage() != null ? bookingEntity.getUsage() : "");
            builder.append("\n");
        });
        return builder.toString();
    }

    public Page<BookingEntity> getBookingsPageable(Pageable pageable, String userId, String accessId, String accountId, BankApi bankApi) {
        if (bankApi == null) {
            String bankCode = this.bankAccessRepository.getBankCode(accessId);
            bankApi = this.bankingServiceProducer.getBankingService(bankCode).bankApi();
        }
        return this.bookingRepository.findPageableByUserIdAndAccountIdAndBankApi(pageable, userId, accountId, bankApi);
    }

    public Iterable<BookingEntity> getBookingsById(String name, List<String> ids) {
        return this.bookingRepository.findByUserIdAndIds(name, ids);
    }

    public Optional<BookingsIndexEntity> getSearchIndex(String userId, String accountId) {
        return this.bookingsIndexRepository.findByUserIdAndAccountId(userId, accountId);
    }

    private List<BookingEntity> getBookings(String userId, String accessId, String accountId) {
        String bankCode = this.bankAccessRepository.getBankCode(accessId);
        BankApi bankApi = this.bankingServiceProducer.getBankingService(bankCode).bankApi();
        return this.bookingRepository.findByUserIdAndAccountIdAndBankApi(userId, accountId, bankApi);
    }

    @Transactional
    public List<BookingEntity> syncBookings(ScaStatus expectedConsentStatus, String authorisationCode, BankAccessEntity bankAccess, BankAccountEntity bankAccount, @Nullable BankApi bankApi) {
        this.bankAccountRepository.updateSyncStatus(bankAccount.getId(), BankAccount.SyncStatus.SYNC);
        OnlineBankingService onlineBankingService = bankApi != null ? this.bankingServiceProducer.getBankingService(bankApi) : this.bankingServiceProducer.getBankingService(bankAccess.getBankCode());
        try {
            ConsentEntity consentEntity = this.consentService.validateAndGetConsent(onlineBankingService, bankAccess.getConsentId(), expectedConsentStatus);
            TransactionsResponse response = this.loadBookingsOnline(consentEntity, authorisationCode, onlineBankingService, bankAccess, bankAccount);
            if (!bankAccess.isTemporary()) {
                this.bankAccessRepository.save(bankAccess);
            }
            List result = this.processBookings(onlineBankingService, bankAccess, bankAccount, response);
            Optional.ofNullable(response.getBalancesReport()).ifPresent(arg_0 -> ((BankAccountEntity)bankAccount).setBalances(arg_0));
            bankAccount.setSyncStatus(BankAccount.SyncStatus.READY);
            bankAccount.setLastSync(LocalDateTime.now());
            this.bankAccountRepository.save(bankAccount);
            this.metricsCollector.count("syncBookings", bankAccess.getBankCode(), onlineBankingService.bankApi());
            List list = result;
            return list;
        }
        catch (Exception e) {
            this.metricsCollector.count("syncBookings", bankAccess.getBankCode(), onlineBankingService.bankApi(), (Throwable)e);
            throw e;
        }
        finally {
            this.bankAccountRepository.updateSyncStatus(bankAccount.getId(), BankAccount.SyncStatus.PENDING);
        }
    }

    private List<BookingEntity> processBookings(OnlineBankingService onlineBankingService, BankAccessEntity bankAccess, BankAccountEntity bankAccount, TransactionsResponse response) {
        List newBookings = this.mapBookings(bankAccount, response.getBookings());
        List existingBookings = this.bookingRepository.findByUserIdAndAccountIdAndBankApi(bankAccess.getUserId(), bankAccount.getId(), onlineBankingService.bankApi());
        List mergedBookings = !existingBookings.isEmpty() ? this.mergeBookings(existingBookings, newBookings) : newBookings;
        if (mergedBookings.size() == existingBookings.size() && !this.rulesVersionChanged(bankAccess.getUserId(), bankAccount.getId())) {
            log.info("no bookings or rules changes, skip analytics");
            return existingBookings;
        }
        AnalyticsResult analyticsResult = null;
        if (bankAccess.isCategorizeBookings() || bankAccess.isStoreAnalytics()) {
            analyticsResult = this.analyticsService.analyzeBookings(bankAccess.getUserId(), mergedBookings);
            if (!onlineBankingService.bookingsCategorized()) {
                this.smartAnalyticsMapper.applyCategories(mergedBookings, analyticsResult);
            }
        }
        if (bankAccess.isStoreBookings()) {
            this.bookingRepository.save(mergedBookings);
            this.updateBookingsIndex(bankAccount, mergedBookings);
        }
        if (bankAccess.isStoreAnonymizedBookings()) {
            this.anonymizationService.anonymizeAndStoreBookingsAsync(mergedBookings);
        }
        this.saveAnalytics(analyticsResult, bankAccess, bankAccount, mergedBookings);
        if (!mergedBookings.isEmpty()) {
            LocalDate firstBookingData = ((BookingEntity)mergedBookings.get(0)).getBookingDate();
            LocalDate lastBookingDate = ((BookingEntity)mergedBookings.get(mergedBookings.size() - 1)).getBookingDate();
            if (firstBookingData != null && lastBookingDate != null && firstBookingData.compareTo(lastBookingDate) < 0) {
                Collections.reverse(mergedBookings);
            }
        }
        return mergedBookings;
    }

    private boolean rulesVersionChanged(String userId, String accountId) {
        ConfigStatus analyticsConfigStatus = this.smartAnalyticsService.getAnalyticsConfigStatus();
        if (analyticsConfigStatus.getLastChangeDate() == null) {
            return false;
        }
        return this.analyticsRepository.findLastAnalyticsDateByUserIdAndAccountId(userId, accountId).map(lastAnalyticsDate -> {
            if (lastAnalyticsDate.isBefore(analyticsConfigStatus.getLastChangeDate())) {
                return true;
            }
            return this.userService.getRulesLastChangeDate(userId).map(lastAnalyticsDate::isBefore).orElse(false);
        }).orElse(true);
    }

    void saveAnalytics(AnalyticsResult analyticsResult, BankAccessEntity bankAccess, BankAccountEntity bankAccount, List<BookingEntity> bookingEntities) {
        if (analyticsResult == null) {
            return;
        }
        analyticsResult.getBookingGroups().stream().filter(bookingGroup -> bookingGroup.getBookingPeriods() != null).forEach(bookingGroup -> bookingGroup.getBookingPeriods().forEach(period -> period.getBookings().forEach(executedBooking -> bookingEntities.stream().filter(bookingEntity -> bookingEntity.getExternalId() != null).filter(bookingEntity -> bookingEntity.getExternalId().equals(executedBooking.getBookingId())).findFirst().ifPresent(bookingEntity -> executedBooking.setBookingId(bookingEntity.getId())))));
        if (bankAccess.isStoreAnalytics()) {
            this.analyticsService.saveAccountAnalytics(bankAccount, analyticsResult.getBookingGroups());
            this.analyticsService.identifyAndStoreContracts(bankAccount.getUserId(), bankAccount.getId(), analyticsResult.getBookingGroups());
        }
    }

    private void saveStandingOrders(BankAccountEntity bankAccount, List<StandingOrder> standingOrders) {
        Optional.ofNullable(standingOrders).ifPresent(sto -> {
            List standingOrderEntities = sto.stream().map(booking -> {
                StandingOrderEntity target = new StandingOrderEntity();
                BeanUtils.copyProperties((Object)booking, (Object)target);
                target.setAccountId(bankAccount.getId());
                target.setUserId(bankAccount.getUserId());
                return target;
            }).collect(Collectors.toList());
            this.standingOrderRepository.deleteByAccountId(bankAccount.getId());
            this.standingOrderRepository.save(standingOrderEntities);
        });
    }

    private void updateBookingsIndex(BankAccountEntity bankAccount, List<BookingEntity> bookings) {
        BookingsIndexEntity bookingsIndexEntity = this.bookingsIndexRepository.findByUserIdAndAccountId(bankAccount.getUserId(), bankAccount.getId()).orElseGet(() -> {
            BookingsIndexEntity newIndexEntity = new BookingsIndexEntity();
            newIndexEntity.setAccountId(bankAccount.getId());
            newIndexEntity.setUserId(bankAccount.getUserId());
            return newIndexEntity;
        });
        bookingsIndexEntity.updateSearchIndex(bookings);
        this.bookingsIndexRepository.save(bookingsIndexEntity);
    }

    private TransactionsResponse loadBookingsOnline(ConsentEntity consentEntity, String authorisationCode, OnlineBankingService onlineBankingService, BankAccessEntity bankAccess, BankAccountEntity bankAccount) {
        BankApiUser bankApiUser = this.userService.checkApiRegistration(onlineBankingService, this.userService.findUser(bankAccess.getUserId()));
        if (onlineBankingService.externalBankAccountRequired()) {
            this.checkExternalBankAccountExists(bankAccess, bankAccount, bankApiUser, onlineBankingService);
        }
        BankEntity bankEntity = this.bankService.findBank(bankAccess.getBankCode());
        TransactionRequest loadBookingsRequest = this.createLoadBookingsRequest(bankAccess, bankAccount, bankApiUser, consentEntity, bankEntity, authorisationCode);
        try {
            TransactionsResponse response = onlineBankingService.loadTransactions(loadBookingsRequest);
            this.checkSca((AbstractResponse)response, consentEntity, onlineBankingService);
            return response;
        }
        catch (MultibankingException e) {
            throw this.handleMultibankingException(bankAccess, e);
        }
    }

    private TransactionRequest<LoadTransactions> createLoadBookingsRequest(BankAccessEntity bankAccess, BankAccountEntity bankAccount, BankApiUser bankApiUser, ConsentEntity consentEntity, BankEntity bankEntity, String authorisationCode) {
        LoadTransactions loadBookings = new LoadTransactions();
        loadBookings.setBookingStatus(LoadTransactions.BookingStatus.BOOKED);
        loadBookings.setPsuAccount((BankAccount)bankAccount);
        loadBookings.setDateFrom(bankAccount.getLastSync() != null ? bankAccount.getLastSync().toLocalDate() : null);
        loadBookings.setDateTo(LocalDate.now());
        loadBookings.setWithBalance(true);
        TransactionRequest transactionRequest = TransactionRequestFactory.create((AbstractTransaction)loadBookings, (BankApiUser)bankApiUser, (BankAccess)bankAccess, (Bank)bankEntity, (Object)consentEntity.getBankApiConsentData());
        transactionRequest.setAuthorisationCode(authorisationCode);
        return transactionRequest;
    }

    List<BookingEntity> mapBookings(BankAccountEntity bankAccount, List<Booking> bookings) {
        return bookings.stream().map(booking -> {
            BookingEntity target = new BookingEntity();
            BeanUtils.copyProperties((Object)booking, (Object)target);
            target.setAccountId(bankAccount.getId());
            target.setUserId(bankAccount.getUserId());
            return target;
        }).collect(Collectors.toList());
    }

    List<BookingEntity> mergeBookings(List<BookingEntity> dbBookings, List<BookingEntity> newBookings) {
        return Stream.of(dbBookings, newBookings).flatMap(Collection::stream).collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<BookingEntity>(Comparator.comparing(Booking::getExternalId, Comparator.nullsLast(Comparator.naturalOrder())))), ArrayList::new));
    }

    private void checkExternalBankAccountExists(BankAccessEntity bankAccess, BankAccountEntity bankAccount, BankApiUser bankApiUser, OnlineBankingService onlineBankingService) {
        String externalAccountId = (String)bankAccount.getExternalIdMap().get(onlineBankingService.bankApi());
        if (externalAccountId == null) {
            BankEntity bankEntity = this.bankService.findBank(bankAccess.getBankCode());
            TransactionRequest transactionRequest = TransactionRequestFactory.create((AbstractTransaction)new LoadAccounts(), (BankApiUser)bankApiUser, (BankAccess)bankAccess, (Bank)bankEntity, null);
            List apiBankAccounts = onlineBankingService.loadBankAccounts(transactionRequest).getBankAccounts();
            List dbBankAccounts = this.bankAccountRepository.findByUserIdAndBankAccessId(bankAccess.getUserId(), bankAccess.getId());
            apiBankAccounts.forEach(apiBankAccount -> dbBankAccounts.forEach(dbBankAccount -> {
                if (apiBankAccount.getAccountNumber().equals(dbBankAccount.getAccountNumber())) {
                    dbBankAccount.externalId(onlineBankingService.bankApi(), (String)apiBankAccount.getExternalIdMap().get(onlineBankingService.bankApi()));
                    this.bankAccountRepository.save(dbBankAccount);
                    if (bankAccess.getId().equals(dbBankAccount.getId())) {
                        bankAccess.externalId(onlineBankingService.bankApi(), (String)apiBankAccount.getExternalIdMap().get(onlineBankingService.bankApi()));
                    }
                }
            }));
        }
    }

    public BookingService(BankAccessRepositoryIf bankAccessRepository, BankAccountRepositoryIf bankAccountRepository, BookingRepositoryIf bookingRepository, BookingsIndexRepositoryIf bookingsIndexRepository, StandingOrderRepositoryIf standingOrderRepository, AnalyticsRepositoryIf analyticsRepository, SmartAnalyticsIf smartAnalyticsService, AnalyticsService analyticsService, AnonymizationService anonymizationService, ConsentService consentService, BankService bankService, UserService userService, OnlineBankingServiceProducer bankingServiceProducer, SmartAnalyticsMapper smartAnalyticsMapper, MetricsCollector metricsCollector) {
        this.bankAccessRepository = bankAccessRepository;
        this.bankAccountRepository = bankAccountRepository;
        this.bookingRepository = bookingRepository;
        this.bookingsIndexRepository = bookingsIndexRepository;
        this.standingOrderRepository = standingOrderRepository;
        this.analyticsRepository = analyticsRepository;
        this.smartAnalyticsService = smartAnalyticsService;
        this.analyticsService = analyticsService;
        this.anonymizationService = anonymizationService;
        this.consentService = consentService;
        this.bankService = bankService;
        this.userService = userService;
        this.bankingServiceProducer = bankingServiceProducer;
        this.smartAnalyticsMapper = smartAnalyticsMapper;
        this.metricsCollector = metricsCollector;
    }
}

