/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.service;

import de.adorsys.multibanking.domain.Bank;
import de.adorsys.multibanking.domain.BankAccess;
import de.adorsys.multibanking.domain.BankAccessEntity;
import de.adorsys.multibanking.domain.BankAccount;
import de.adorsys.multibanking.domain.BankAccountEntity;
import de.adorsys.multibanking.domain.BankApi;
import de.adorsys.multibanking.domain.BankApiUser;
import de.adorsys.multibanking.domain.BankEntity;
import de.adorsys.multibanking.domain.ConsentEntity;
import de.adorsys.multibanking.domain.ScaStatus;
import de.adorsys.multibanking.domain.UserEntity;
import de.adorsys.multibanking.domain.exception.MultibankingException;
import de.adorsys.multibanking.domain.request.TransactionRequest;
import de.adorsys.multibanking.domain.request.TransactionRequestFactory;
import de.adorsys.multibanking.domain.response.AbstractResponse;
import de.adorsys.multibanking.domain.response.AccountInformationResponse;
import de.adorsys.multibanking.domain.spi.OnlineBankingService;
import de.adorsys.multibanking.domain.transaction.AbstractTransaction;
import de.adorsys.multibanking.domain.transaction.LoadAccounts;
import de.adorsys.multibanking.exception.InvalidBankAccessException;
import de.adorsys.multibanking.exception.ResourceNotFoundException;
import de.adorsys.multibanking.metrics.MetricsCollector;
import de.adorsys.multibanking.pers.spi.repository.BankAccessRepositoryIf;
import de.adorsys.multibanking.pers.spi.repository.BankAccountRepositoryIf;
import de.adorsys.multibanking.service.AccountInformationService;
import de.adorsys.multibanking.service.BankService;
import de.adorsys.multibanking.service.ConsentService;
import de.adorsys.multibanking.service.OnlineBankingServiceProducer;
import de.adorsys.multibanking.service.UserService;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class BankAccountService
extends AccountInformationService {
    private static final Logger log = LoggerFactory.getLogger(BankAccountService.class);
    private final BankAccessRepositoryIf bankAccessRepository;
    private final BankAccountRepositoryIf bankAccountRepository;
    private final OnlineBankingServiceProducer bankingServiceProducer;
    private final ConsentService consentService;
    private final UserService userService;
    private final BankService bankService;
    private final MetricsCollector metricsCollector;

    public List<BankAccountEntity> getBankAccounts(String userId, String accessId) {
        BankAccessEntity bankAccessEntity = (BankAccessEntity)this.bankAccessRepository.findByUserIdAndId(userId, accessId).orElseThrow(() -> new ResourceNotFoundException(BankAccessEntity.class, accessId));
        List bankAccounts = this.bankAccountRepository.findByUserIdAndBankAccessId(userId, accessId);
        if (bankAccounts.isEmpty()) {
            BankEntity bank = this.bankService.findBank(bankAccessEntity.getBankCode());
            bankAccounts = this.loadBankAccountsOnline(bank, bankAccessEntity, null);
            bankAccounts.forEach(account -> account.setBankAccessId(bankAccessEntity.getId()));
            this.bankAccountRepository.save(bankAccounts);
            log.info("[{}] accounts for connection [{}] created.", (Object)bankAccounts.size(), (Object)bankAccessEntity.getId());
            this.bankAccessRepository.save(bankAccessEntity);
        }
        return bankAccounts;
    }

    List<BankAccountEntity> loadBankAccountsOnline(BankEntity bankEntity, BankAccessEntity bankAccess, BankApi bankApi) {
        return this.loadBankAccountsOnline(bankEntity, bankAccess, this.userService.findUser(bankAccess.getUserId()), bankApi, ScaStatus.FINALISED);
    }

    public List<BankAccountEntity> loadBankAccountsOnline(BankEntity bankEntity, BankAccessEntity bankAccess, UserEntity userEntity, BankApi bankApi, ScaStatus expectedConsentStatus) {
        OnlineBankingService onlineBankingService;
        OnlineBankingService onlineBankingService2 = onlineBankingService = bankApi != null ? this.bankingServiceProducer.getBankingService(bankApi) : this.bankingServiceProducer.getBankingService(bankAccess.getBankCode());
        if (!onlineBankingService.bankSupported(bankAccess.getBankCode())) {
            throw new InvalidBankAccessException(bankAccess.getBankCode());
        }
        BankApiUser bankApiUser = this.userService.checkApiRegistration(onlineBankingService, userEntity);
        List bankAccounts = this.loadBankAccountsOnline(expectedConsentStatus, bankAccess, onlineBankingService, bankApiUser, bankEntity);
        return Optional.ofNullable(bankAccounts).stream().flatMap(Collection::stream).map(source -> {
            BankAccountEntity target = new BankAccountEntity();
            BeanUtils.copyProperties((Object)source, (Object)target);
            target.setUserId(bankAccess.getUserId());
            return target;
        }).collect(Collectors.toList());
    }

    private List<BankAccount> loadBankAccountsOnline(ScaStatus expectedConsentStatus, BankAccessEntity bankAccess, OnlineBankingService onlineBankingService, BankApiUser bankApiUser, BankEntity bankEntity) {
        ConsentEntity consentEntity = this.consentService.validateAndGetConsent(onlineBankingService, bankAccess.getConsentId(), expectedConsentStatus);
        TransactionRequest transactionRequest = TransactionRequestFactory.create((AbstractTransaction)new LoadAccounts(), (BankApiUser)bankApiUser, (BankAccess)bankAccess, (Bank)bankEntity, (Object)consentEntity.getBankApiConsentData());
        try {
            AccountInformationResponse response = onlineBankingService.loadBankAccounts(transactionRequest);
            this.checkSca((AbstractResponse)response, consentEntity, onlineBankingService);
            this.metricsCollector.count("loadAccounts", bankAccess.getBankCode(), onlineBankingService.bankApi());
            return response.getBankAccounts();
        }
        catch (MultibankingException e) {
            this.metricsCollector.count("loadAccounts", bankAccess.getBankCode(), onlineBankingService.bankApi(), (Throwable)e);
            throw this.handleMultibankingException(bankAccess, e);
        }
        catch (Exception e) {
            this.metricsCollector.count("loadAccounts", bankAccess.getBankCode(), onlineBankingService.bankApi(), (Throwable)e);
            throw e;
        }
    }

    public BankAccountService(BankAccessRepositoryIf bankAccessRepository, BankAccountRepositoryIf bankAccountRepository, OnlineBankingServiceProducer bankingServiceProducer, ConsentService consentService, UserService userService, BankService bankService, MetricsCollector metricsCollector) {
        this.bankAccessRepository = bankAccessRepository;
        this.bankAccountRepository = bankAccountRepository;
        this.bankingServiceProducer = bankingServiceProducer;
        this.consentService = consentService;
        this.userService = userService;
        this.bankService = bankService;
        this.metricsCollector = metricsCollector;
    }
}

