/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.logging;

import ch.qos.logback.classic.PatternLayout;
import ch.qos.logback.classic.spi.ILoggingEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.IntStream;

public class WhitelistMaskEverythingLayout
extends PatternLayout {
    private static final String USAGE_PATTERN = "(usage)\\=(.*?)[)|,](?= addkey=)";
    private static final String JAVAOBJECT_PATTERN = "([\\w\\d]+)\\=([^()|,]*)[)|,]";
    private static final String JSON_PATTERN = "\"([\\w\\d]+)\" ?\\: ?(\"[^\"]*\"|[^{}()\\[\\]|,\\s]*)[\\s})|,]";
    private final Pattern multilinePattern;
    private List<String> whitelistEntries = new ArrayList();

    public WhitelistMaskEverythingLayout() {
        this.multilinePattern = Pattern.compile(String.join((CharSequence)"|", USAGE_PATTERN, JAVAOBJECT_PATTERN, JSON_PATTERN), 8);
    }

    public void addWhitelistEntry(String whitelistEntry) {
        this.whitelistEntries.add(whitelistEntry);
    }

    public String doLayout(ILoggingEvent event) {
        return this.maskMessage(super.doLayout(event));
    }

    String maskMessage(String message) {
        if (this.multilinePattern == null) {
            return message;
        }
        StringBuilder sb = new StringBuilder(message);
        Matcher matcher = this.multilinePattern.matcher(sb);
        while (matcher.find()) {
            String key = matcher.group(1);
            String value = matcher.group(2);
            int valuePosition = 2;
            if (value == null) {
                key = matcher.group(3);
                value = matcher.group(4);
                valuePosition = 4;
            }
            if (value == null) {
                key = matcher.group(5);
                value = matcher.group(6);
                valuePosition = 6;
            }
            if (this.whitelistEntries.contains(key) || value == null || "null".equals(value)) continue;
            IntStream.range(matcher.start(valuePosition), matcher.end(valuePosition)).forEach(i -> sb.setCharAt(i, '*'));
        }
        String maskedMessage = sb.toString();
        return maskedMessage.replaceAll("\\*{10,}", "****###****");
    }
}

