/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.exception;

import de.adorsys.multibanking.domain.exception.MultibankingException;
import de.adorsys.multibanking.exception.ParametrizedMessageException;
import de.adorsys.multibanking.exception.domain.Message;
import de.adorsys.multibanking.exception.domain.Messages;
import de.adorsys.multibanking.logging.RestControllerAspectLogging;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletionException;
import java.util.stream.Collectors;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.validation.ConstraintViolationException;
import org.iban4j.InvalidCheckDigitException;
import org.kapott.hbci.exceptions.HBCI_Exception;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.util.StringUtils;
import org.springframework.validation.BindException;
import org.springframework.validation.ObjectError;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.ServletRequestBindingException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.client.HttpStatusCodeException;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.method.annotation.MethodArgumentTypeMismatchException;

@ControllerAdvice
public class ExceptionHandlerAdvice {
    private static final Logger log = LoggerFactory.getLogger(ExceptionHandlerAdvice.class);
    private static final String VALIDATION_ERROR = "VALIDATION_ERROR";
    private static final String INVALD_FORMAT = "INVALID_FORMAT";
    private static final String LOG_FORMAT = "Error: [{}] from Controller: [{}]";

    @ResponseStatus
    @ExceptionHandler
    @ResponseBody
    public ResponseEntity<Messages> handleException(Exception e, HandlerMethod handlerMethod) {
        return this.handleInternal((Throwable)e, handlerMethod);
    }

    @ResponseStatus(code=HttpStatus.BAD_REQUEST)
    @ExceptionHandler
    @ResponseBody
    public ResponseEntity<Messages> handleException(HBCI_Exception e, HandlerMethod handlerMethod) {
        ArrayList<Message> messages = new ArrayList<Message>();
        for (Object e2 = e; e2 != null; e2 = ((Throwable)e2).getCause()) {
            if (((Throwable)e2).getMessage() == null) continue;
            messages.add(Message.builder().key("HBCI_ERROR").severity(Message.Severity.ERROR).renderedMessage(((Throwable)e2).getMessage()).build());
        }
        return this.handleInternal((Throwable)e, Messages.builder().messages(messages).build(), HttpStatus.BAD_REQUEST, handlerMethod);
    }

    @ResponseStatus(code=HttpStatus.INTERNAL_SERVER_ERROR)
    @ExceptionHandler
    @ResponseBody
    public ResponseEntity<Messages> handleException(CompletionException e, HandlerMethod handlerMethod) {
        Throwable cause = e.getCause();
        if (HttpStatusCodeException.class.isAssignableFrom(cause.getClass())) {
            return this.handleHttpStatusCodeException((HttpStatusCodeException)cause, handlerMethod);
        }
        if (ParametrizedMessageException.class.isAssignableFrom(cause.getClass())) {
            return this.handleException((ParametrizedMessageException)cause, handlerMethod);
        }
        return this.handleInternal((Throwable)e, handlerMethod);
    }

    @ResponseStatus
    @ExceptionHandler
    @ResponseBody
    public ResponseEntity<Messages> handleException(MultibankingException e, HandlerMethod handlerMethod) {
        HttpStatus httpStatus = HttpStatus.valueOf((int)e.getHttpResponseCode());
        List messages = Optional.ofNullable(e.getPsuMessages()).orElse(Collections.emptyList()).stream().map(message -> Message.builder().key(message.getKey() != null ? message.getKey() : e.getMultibankingError().toString()).severity(message.getSeverity() != null ? Message.Severity.valueOf((String)message.getSeverity().toString()) : null).field(message.getField()).renderedMessage(message.getRenderedMessage()).paramsMap(message.getParamsMap()).build()).collect(Collectors.toList());
        messages.addAll(Optional.ofNullable(e.getPsuMessages()).orElse(Collections.emptyList()).stream().map(message -> Message.builder().key(e.getMultibankingError().toString()).renderedMessage(message.toString()).build()).collect(Collectors.toList()));
        Messages messagesContainer = Messages.builder().messages(messages).build();
        return this.handleInternal((Throwable)e, messagesContainer, httpStatus, handlerMethod);
    }

    @ResponseStatus(code=HttpStatus.FORBIDDEN)
    @ExceptionHandler
    @ResponseBody
    public ResponseEntity<Messages> handleAccessDeniedException(ServletRequest request, AccessDeniedException e, HandlerMethod handlerMethod) {
        try {
            HttpServletRequest httpServletRequest = (HttpServletRequest)request;
            log.info("User [{}] access denied to [{}] [{}]", new Object[]{httpServletRequest.getRemoteUser(), httpServletRequest.getMethod(), httpServletRequest.getRequestURI()});
        }
        catch (Exception ex) {
            log.info("Can't LOG: {}", (Object)ex.getMessage());
        }
        return new ResponseEntity(HttpStatus.FORBIDDEN);
    }

    @ResponseStatus
    @ExceptionHandler
    @ResponseBody
    public ResponseEntity<Messages> handleException(ParametrizedMessageException e, HandlerMethod handlerMethod) {
        ResponseStatus responseStatus = (ResponseStatus)AnnotationUtils.findAnnotation(e.getClass(), ResponseStatus.class);
        if (responseStatus != null) {
            Messages messages = Messages.createError((String)responseStatus.reason(), (String)e.getLocalizedMessage(), (Map)e.getParamsMap());
            return this.handleInternal((Throwable)e, messages, responseStatus.code(), handlerMethod);
        }
        return this.handleException(e, handlerMethod);
    }

    @ResponseStatus
    @ExceptionHandler
    @ResponseBody
    public ResponseEntity<Messages> handleHttpStatusCodeException(HttpStatusCodeException e, HandlerMethod handlerMethod) {
        return this.handleInternal((Throwable)e, null, e.getStatusCode(), handlerMethod);
    }

    @ResponseStatus(code=HttpStatus.BAD_REQUEST)
    @ExceptionHandler
    @ResponseBody
    public ResponseEntity<Messages> handleMethodArgumentTypeMismatchException(MethodArgumentTypeMismatchException e, HandlerMethod handlerMethod) {
        Message message = Message.builder().key(INVALD_FORMAT).severity(Message.Severity.ERROR).field(e.getName()).renderedMessage(e.getMessage()).build();
        return this.handleInternal((Throwable)e, Messages.builder().messages(Collections.singletonList(message)).build(), HttpStatus.BAD_REQUEST, handlerMethod);
    }

    @ResponseStatus(code=HttpStatus.BAD_REQUEST)
    @ExceptionHandler
    @ResponseBody
    public ResponseEntity<Messages> handleMethodArgumentNotValidException(MethodArgumentNotValidException ex, HandlerMethod handlerMethod) {
        Collection messages = ex.getBindingResult().getFieldErrors().stream().map(fieldError -> Message.builder().key(VALIDATION_ERROR).severity(Message.Severity.ERROR).field(fieldError.getField()).renderedMessage(fieldError.getDefaultMessage()).build()).collect(Collectors.toList());
        if (ex.getBindingResult().hasGlobalErrors()) {
            ObjectError objectError = (ObjectError)ex.getBindingResult().getGlobalErrors().iterator().next();
            Message message = Message.builder().key(VALIDATION_ERROR).severity(Message.Severity.ERROR).renderedMessage(objectError.getDefaultMessage()).build();
            messages.add(message);
        }
        return this.handleInternal((Throwable)ex, Messages.builder().messages(messages).build(), HttpStatus.BAD_REQUEST, handlerMethod);
    }

    @ResponseStatus(code=HttpStatus.BAD_REQUEST)
    @ExceptionHandler
    @ResponseBody
    public ResponseEntity<Messages> handleMethodBindException(BindException ex, HandlerMethod handlerMethod) {
        Collection messages = ex.getBindingResult().getFieldErrors().stream().map(fieldError -> Message.builder().key(VALIDATION_ERROR).severity(Message.Severity.ERROR).field(fieldError.getField()).renderedMessage(fieldError.getDefaultMessage()).build()).collect(Collectors.toList());
        if (ex.getBindingResult().hasGlobalErrors()) {
            ObjectError objectError = (ObjectError)ex.getBindingResult().getGlobalErrors().iterator().next();
            messages.add(Message.builder().key(VALIDATION_ERROR).severity(Message.Severity.ERROR).renderedMessage(objectError.getDefaultMessage()).build());
        }
        return this.handleInternal((Throwable)ex, Messages.builder().messages(messages).build(), HttpStatus.BAD_REQUEST, handlerMethod);
    }

    @ResponseStatus(code=HttpStatus.BAD_REQUEST)
    @ExceptionHandler
    @ResponseBody
    public ResponseEntity<Messages> handleConstraintViolationException(ConstraintViolationException e, HandlerMethod handlerMethod) {
        Collection messages = e.getConstraintViolations().stream().map(cv -> Message.builder().key(VALIDATION_ERROR).severity(Message.Severity.ERROR).field(cv.getPropertyPath().toString()).renderedMessage(cv.getMessage()).build()).collect(Collectors.toList());
        return this.handleInternal((Throwable)e, Messages.builder().messages(messages).build(), HttpStatus.BAD_REQUEST, handlerMethod);
    }

    @ResponseStatus(code=HttpStatus.BAD_REQUEST)
    @ExceptionHandler
    @ResponseBody
    public ResponseEntity<Messages> handleUnsatisfiedServletRequestParameterException(ServletRequestBindingException ex, HandlerMethod handlerMethod) {
        return this.handleInternal((Throwable)ex, null, HttpStatus.BAD_REQUEST, handlerMethod);
    }

    @ResponseStatus(code=HttpStatus.BAD_REQUEST)
    @ExceptionHandler
    @ResponseBody
    public ResponseEntity<Messages> handleHttpMessageNotReadableException(HttpMessageNotReadableException ex, HandlerMethod handlerMethod) {
        return this.handleInternal((Throwable)ex, null, HttpStatus.BAD_REQUEST, handlerMethod);
    }

    @ResponseStatus(code=HttpStatus.METHOD_NOT_ALLOWED)
    @ExceptionHandler
    @ResponseBody
    public ResponseEntity<Messages> handleHttpRequestMethodNotSupportedException(HttpRequestMethodNotSupportedException ex, HandlerMethod handlerMethod) {
        return this.handleInternal((Throwable)ex, null, HttpStatus.METHOD_NOT_ALLOWED, handlerMethod);
    }

    @ResponseStatus(code=HttpStatus.BAD_REQUEST)
    @ExceptionHandler
    @ResponseBody
    public ResponseEntity<Messages> handleInvalidCheckDigitException(InvalidCheckDigitException ex, HandlerMethod handlerMethod) {
        return this.handleInternal((Throwable)ex, Messages.builder().message(Message.builder().key("INVALID_IBAN").field("iban").severity(Message.Severity.ERROR).build()).build(), HttpStatus.BAD_REQUEST, handlerMethod);
    }

    private ResponseEntity<Messages> handleInternal(Throwable throwable, HandlerMethod handlerMethod) {
        ResponseStatus responseStatus = (ResponseStatus)AnnotationUtils.findAnnotation(throwable.getClass(), ResponseStatus.class);
        Messages messages = responseStatus != null && StringUtils.hasText((String)responseStatus.reason()) ? Messages.createError((String)responseStatus.reason(), (String)throwable.getMessage()) : Messages.createError((String)throwable.getClass().toString(), (String)throwable.getMessage());
        HttpStatus statusCode = Optional.ofNullable(responseStatus).map(ResponseStatus::code).orElse(HttpStatus.INTERNAL_SERVER_ERROR);
        return this.handleInternal(throwable, messages, statusCode, handlerMethod);
    }

    private ResponseEntity<Messages> handleInternal(Throwable throwable, Messages messages, HttpStatus httpStatus, HandlerMethod handlerMethod) {
        String message;
        String controller = handlerMethod.getMethod().getDeclaringClass().getSimpleName();
        String string = message = throwable instanceof MultibankingException ? ((MultibankingException)throwable).getMultibankingError().toString() : throwable.getMessage();
        if (httpStatus == HttpStatus.NOT_FOUND) {
            log.info(LOG_FORMAT, (Object)message, (Object)controller);
        } else if (httpStatus.is4xxClientError()) {
            log.warn(LOG_FORMAT, (Object)message, (Object)controller);
            log.warn(throwable.getMessage(), throwable);
        } else {
            log.error(LOG_FORMAT, (Object)message, (Object)controller);
            log.error(throwable.getMessage(), throwable);
        }
        ResponseEntity responseEntity = messages == null ? new ResponseEntity(httpStatus) : new ResponseEntity((Object)messages, httpStatus);
        LoggerFactory.getLogger(RestControllerAspectLogging.class).trace(RestControllerAspectLogging.AUDIT_LOG, "Response: [{}]", (Object)responseEntity);
        return responseEntity;
    }
}

