/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.config;

import com.nimbusds.jwt.JWTClaimsSet;
import de.adorsys.multibanking.domain.UserSecret;
import de.adorsys.sts.filter.JWTAuthenticationFilter;
import de.adorsys.sts.keymanagement.service.DecryptionService;
import de.adorsys.sts.token.authentication.TokenAuthenticationService;
import de.adorsys.sts.tokenauth.BearerToken;
import de.adorsys.sts.tokenauth.BearerTokenValidator;
import java.security.Principal;
import java.util.Arrays;
import java.util.Collections;
import java.util.Optional;
import javax.servlet.Filter;
import javax.servlet.http.HttpServletRequest;
import net.minidev.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.context.annotation.Scope;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.core.env.Environment;
import org.springframework.core.env.Profiles;
import org.springframework.http.HttpMethod;
import org.springframework.security.config.annotation.method.configuration.EnableGlobalMethodSecurity;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.authentication.www.BasicAuthenticationFilter;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.cors.CorsConfigurationSource;
import org.springframework.web.cors.UrlBasedCorsConfigurationSource;

@Configuration
@EnableWebSecurity
@EnableGlobalMethodSecurity(prePostEnabled=true)
public class WebSecurityConfig
extends WebSecurityConfigurerAdapter {
    private static final Logger log = LoggerFactory.getLogger(WebSecurityConfig.class);
    private static final String RULES_ADMIN_ROLE = "rules_admin";
    private final Environment environment;
    @Value(value="${sts.audience_name:}")
    private String audience;
    @Value(value="${sts.secret_claim_property_key:}")
    private String secretClaimPropertyKey;
    @Autowired(required=false)
    private TokenAuthenticationService tokenAuthenticationService;
    @Autowired(required=false)
    private DecryptionService decryptionService;

    protected void configure(HttpSecurity http) throws Exception {
        ((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity)((HttpSecurity)http.csrf().disable()).sessionManagement().sessionCreationPolicy(SessionCreationPolicy.STATELESS).and()).authorizeRequests().antMatchers(new String[]{"/actuator/**"})).permitAll().antMatchers(new String[]{"/"})).permitAll().antMatchers(new String[]{"/pop"})).permitAll().antMatchers(new String[]{"/swagger-ui/**"})).permitAll().antMatchers(new String[]{"/swagger-ui.html"})).permitAll().antMatchers(new String[]{"/v3/api-docs/**"})).permitAll().antMatchers(new String[]{"/api/v1/direct/**"})).permitAll().antMatchers(new String[]{"/api/v2/direct/**"})).permitAll().antMatchers(HttpMethod.POST, new String[]{"/api/v1/consents/**"})).permitAll().antMatchers(HttpMethod.DELETE, new String[]{"/api/v1/consents/**"})).permitAll().antMatchers(HttpMethod.GET, new String[]{"/api/v1/consents/**"})).permitAll().antMatchers(new String[]{"/api/v1/consents/**/authorisations/**"})).permitAll().antMatchers(new String[]{"/status"})).permitAll().antMatchers(HttpMethod.GET, new String[]{"/api/v1/bank/**"})).permitAll().antMatchers(HttpMethod.GET, new String[]{"/api/v1/banks/**"})).permitAll().antMatchers(HttpMethod.POST, new String[]{"/api/v1/bank/**"})).hasAuthority(RULES_ADMIN_ROLE).antMatchers(HttpMethod.POST, new String[]{"/api/v1/banks/**"})).hasAuthority(RULES_ADMIN_ROLE).antMatchers(HttpMethod.GET, new String[]{"/api/v1/images/**"})).permitAll().antMatchers(HttpMethod.POST, new String[]{"/api/v1/images/**"})).hasAuthority(RULES_ADMIN_ROLE).antMatchers(HttpMethod.GET, new String[]{"/api/v1/config/booking-categories"})).authenticated().antMatchers(new String[]{"/api/v1/config/**"})).hasAuthority(RULES_ADMIN_ROLE).antMatchers(new String[]{"/api/v1/**"})).authenticated().anyRequest()).denyAll().and()).cors();
        if (this.environment.acceptsProfiles(Profiles.of((String[])new String[]{"sts-enable"}))) {
            http.addFilterBefore((Filter)new JWTAuthenticationFilter(this.tokenAuthenticationService), BasicAuthenticationFilter.class);
        }
    }

    @Bean
    @Scope(scopeName="request", proxyMode=ScopedProxyMode.TARGET_CLASS)
    public BearerToken getBearerToken(HttpServletRequest request, @Autowired(required=false) BearerTokenValidator bearerTokenValidator) {
        String token = request.getHeader("Authorization");
        return bearerTokenValidator.extract(token);
    }

    @Bean
    @Scope(scopeName="request", proxyMode=ScopedProxyMode.TARGET_CLASS)
    public Principal getPrincipal() {
        return SecurityContextHolder.getContext().getAuthentication();
    }

    @Bean
    @Primary
    @Scope(scopeName="request", proxyMode=ScopedProxyMode.TARGET_CLASS)
    public UserSecret getRequestScopeUserSecret() {
        return new UserSecret(this.decryptSecretClaim());
    }

    @Bean
    public CorsConfigurationSource corsConfigurationSource() {
        CorsConfiguration configuration = new CorsConfiguration();
        configuration.setAllowedOrigins(Collections.singletonList("*"));
        configuration.setAllowedMethods(Arrays.asList("HEAD", "GET", "POST", "PUT", "DELETE", "PATCH"));
        configuration.setAllowCredentials(Boolean.valueOf(true));
        configuration.setAllowedHeaders(Arrays.asList("Authorization", "Cache-Control", "Content-Type"));
        configuration.setExposedHeaders(Collections.singletonList("Location"));
        UrlBasedCorsConfigurationSource source = new UrlBasedCorsConfigurationSource();
        source.registerCorsConfiguration("/**", configuration);
        return source;
    }

    private String decryptSecretClaim() {
        return Optional.ofNullable(SecurityContextHolder.getContext().getAuthentication()).filter(authentication -> authentication.getCredentials() instanceof JWTClaimsSet).map(authentication -> {
            JWTClaimsSet credentials = (JWTClaimsSet)authentication.getCredentials();
            JSONObject encryptedSecretClaims = (JSONObject)credentials.getClaim(this.secretClaimPropertyKey);
            String encryptedSecretClaim = encryptedSecretClaims.getAsString(this.audience);
            if (encryptedSecretClaim == null) {
                log.warn("missing secret claim");
                return null;
            }
            return this.decryptionService.decrypt(encryptedSecretClaim);
        }).orElse(null);
    }

    public WebSecurityConfig(Environment environment) {
        this.environment = environment;
    }
}

