/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.web.model;

import de.adorsys.multibanking.web.model.BankAccountTO;
import de.adorsys.multibanking.web.model.BankApiTO;
import de.adorsys.multibanking.web.model.BookingCategoryTO;
import io.swagger.v3.oas.annotations.media.Schema;
import java.math.BigDecimal;
import java.time.LocalDate;
import org.springframework.hateoas.core.Relation;

@Relation(collectionRelation="bookingList")
@Schema(name="Booking", description="Single bank booking")
public class BookingTO {
    @Schema(description="Booking ID")
    private String id;
    @Schema(description="External ID of this booking")
    private String externalId;
    @Schema(description="Opposite bank account")
    private BankAccountTO otherAccount;
    @Schema(description="Date on which the transaction gets effective", example="2018-02-28")
    private LocalDate valutaDate;
    @Schema(description="Booking date", example="2018-02-28")
    private LocalDate bookingDate;
    @Schema(description="Target amount", example="-19.93")
    private BigDecimal amount;
    @Schema(description="Currency", example="EUR")
    private String currency;
    @Schema(description="Does this reverses a preexisting booking", example="false")
    private boolean reversal;
    @Schema(description="Account balance after this booking", example="1849.1")
    private BigDecimal balance;
    @Schema(description="Reference of the opposite party", example="NONREF")
    private String customerRef;
    @Schema(description="Reference of the corresponding institution")
    private String instRef;
    @Schema(description="Original value", example="-19.93")
    private BigDecimal origValue;
    @Schema(description="Charge value", example="-19.93")
    private BigDecimal chargeValue;
    @Schema(description="Transaction information", example="KARTENZAHLUNG")
    private String text;
    @Schema(description="Additional transaction information", example="KARTENZAHLUNG")
    private String additional;
    @Schema(description="Primanota")
    private String primanota;
    @Schema(description="Usage of this transaction", example="Svwz+2018-02-27t11.47.44 Karte3 2020-12 Abwa+6850 Edeka//Nuernberg/De")
    private String usage;
    private String addkey;
    @Schema(description="Is this a SEPA transaction", example="true")
    private boolean sepa;
    @Schema(description="Is this a standing order transaction", example="false")
    private boolean standingOrder;
    @Schema(description="Creditor ID", example="5aab866d31a02a0001f72cd5")
    private String creditorId;
    @Schema(description="Reference for the SEPA mandate")
    private String mandateReference;
    @Schema(description="Origin of this booking", example="MOCK")
    private BankApiTO bankApi;
    @Schema(description="Category of this booking")
    private BookingCategoryTO bookingCategory;
    @Schema(description="Transaction type as DTA Tx Key code", example="4")
    private String transactionCode;
    @Schema(description="Proprietary bank transaction code", example="NTRF+117+009000")
    private String proprietaryBankTransactionCode;

    public String getId() {
        return this.id;
    }

    public String getExternalId() {
        return this.externalId;
    }

    public BankAccountTO getOtherAccount() {
        return this.otherAccount;
    }

    public LocalDate getValutaDate() {
        return this.valutaDate;
    }

    public LocalDate getBookingDate() {
        return this.bookingDate;
    }

    public BigDecimal getAmount() {
        return this.amount;
    }

    public String getCurrency() {
        return this.currency;
    }

    public boolean isReversal() {
        return this.reversal;
    }

    public BigDecimal getBalance() {
        return this.balance;
    }

    public String getCustomerRef() {
        return this.customerRef;
    }

    public String getInstRef() {
        return this.instRef;
    }

    public BigDecimal getOrigValue() {
        return this.origValue;
    }

    public BigDecimal getChargeValue() {
        return this.chargeValue;
    }

    public String getText() {
        return this.text;
    }

    public String getAdditional() {
        return this.additional;
    }

    public String getPrimanota() {
        return this.primanota;
    }

    public String getUsage() {
        return this.usage;
    }

    public String getAddkey() {
        return this.addkey;
    }

    public boolean isSepa() {
        return this.sepa;
    }

    public boolean isStandingOrder() {
        return this.standingOrder;
    }

    public String getCreditorId() {
        return this.creditorId;
    }

    public String getMandateReference() {
        return this.mandateReference;
    }

    public BankApiTO getBankApi() {
        return this.bankApi;
    }

    public BookingCategoryTO getBookingCategory() {
        return this.bookingCategory;
    }

    public String getTransactionCode() {
        return this.transactionCode;
    }

    public String getProprietaryBankTransactionCode() {
        return this.proprietaryBankTransactionCode;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setExternalId(String externalId) {
        this.externalId = externalId;
    }

    public void setOtherAccount(BankAccountTO otherAccount) {
        this.otherAccount = otherAccount;
    }

    public void setValutaDate(LocalDate valutaDate) {
        this.valutaDate = valutaDate;
    }

    public void setBookingDate(LocalDate bookingDate) {
        this.bookingDate = bookingDate;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public void setReversal(boolean reversal) {
        this.reversal = reversal;
    }

    public void setBalance(BigDecimal balance) {
        this.balance = balance;
    }

    public void setCustomerRef(String customerRef) {
        this.customerRef = customerRef;
    }

    public void setInstRef(String instRef) {
        this.instRef = instRef;
    }

    public void setOrigValue(BigDecimal origValue) {
        this.origValue = origValue;
    }

    public void setChargeValue(BigDecimal chargeValue) {
        this.chargeValue = chargeValue;
    }

    public void setText(String text) {
        this.text = text;
    }

    public void setAdditional(String additional) {
        this.additional = additional;
    }

    public void setPrimanota(String primanota) {
        this.primanota = primanota;
    }

    public void setUsage(String usage) {
        this.usage = usage;
    }

    public void setAddkey(String addkey) {
        this.addkey = addkey;
    }

    public void setSepa(boolean sepa) {
        this.sepa = sepa;
    }

    public void setStandingOrder(boolean standingOrder) {
        this.standingOrder = standingOrder;
    }

    public void setCreditorId(String creditorId) {
        this.creditorId = creditorId;
    }

    public void setMandateReference(String mandateReference) {
        this.mandateReference = mandateReference;
    }

    public void setBankApi(BankApiTO bankApi) {
        this.bankApi = bankApi;
    }

    public void setBookingCategory(BookingCategoryTO bookingCategory) {
        this.bookingCategory = bookingCategory;
    }

    public void setTransactionCode(String transactionCode) {
        this.transactionCode = transactionCode;
    }

    public void setProprietaryBankTransactionCode(String proprietaryBankTransactionCode) {
        this.proprietaryBankTransactionCode = proprietaryBankTransactionCode;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BookingTO)) {
            return false;
        }
        BookingTO other = (BookingTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.isReversal() != other.isReversal()) {
            return false;
        }
        if (this.isSepa() != other.isSepa()) {
            return false;
        }
        if (this.isStandingOrder() != other.isStandingOrder()) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$externalId = this.getExternalId();
        String other$externalId = other.getExternalId();
        if (this$externalId == null ? other$externalId != null : !this$externalId.equals(other$externalId)) {
            return false;
        }
        BankAccountTO this$otherAccount = this.getOtherAccount();
        BankAccountTO other$otherAccount = other.getOtherAccount();
        if (this$otherAccount == null ? other$otherAccount != null : !this$otherAccount.equals(other$otherAccount)) {
            return false;
        }
        LocalDate this$valutaDate = this.getValutaDate();
        LocalDate other$valutaDate = other.getValutaDate();
        if (this$valutaDate == null ? other$valutaDate != null : !((Object)this$valutaDate).equals(other$valutaDate)) {
            return false;
        }
        LocalDate this$bookingDate = this.getBookingDate();
        LocalDate other$bookingDate = other.getBookingDate();
        if (this$bookingDate == null ? other$bookingDate != null : !((Object)this$bookingDate).equals(other$bookingDate)) {
            return false;
        }
        BigDecimal this$amount = this.getAmount();
        BigDecimal other$amount = other.getAmount();
        if (this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount)) {
            return false;
        }
        String this$currency = this.getCurrency();
        String other$currency = other.getCurrency();
        if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) {
            return false;
        }
        BigDecimal this$balance = this.getBalance();
        BigDecimal other$balance = other.getBalance();
        if (this$balance == null ? other$balance != null : !((Object)this$balance).equals(other$balance)) {
            return false;
        }
        String this$customerRef = this.getCustomerRef();
        String other$customerRef = other.getCustomerRef();
        if (this$customerRef == null ? other$customerRef != null : !this$customerRef.equals(other$customerRef)) {
            return false;
        }
        String this$instRef = this.getInstRef();
        String other$instRef = other.getInstRef();
        if (this$instRef == null ? other$instRef != null : !this$instRef.equals(other$instRef)) {
            return false;
        }
        BigDecimal this$origValue = this.getOrigValue();
        BigDecimal other$origValue = other.getOrigValue();
        if (this$origValue == null ? other$origValue != null : !((Object)this$origValue).equals(other$origValue)) {
            return false;
        }
        BigDecimal this$chargeValue = this.getChargeValue();
        BigDecimal other$chargeValue = other.getChargeValue();
        if (this$chargeValue == null ? other$chargeValue != null : !((Object)this$chargeValue).equals(other$chargeValue)) {
            return false;
        }
        String this$text = this.getText();
        String other$text = other.getText();
        if (this$text == null ? other$text != null : !this$text.equals(other$text)) {
            return false;
        }
        String this$additional = this.getAdditional();
        String other$additional = other.getAdditional();
        if (this$additional == null ? other$additional != null : !this$additional.equals(other$additional)) {
            return false;
        }
        String this$primanota = this.getPrimanota();
        String other$primanota = other.getPrimanota();
        if (this$primanota == null ? other$primanota != null : !this$primanota.equals(other$primanota)) {
            return false;
        }
        String this$usage = this.getUsage();
        String other$usage = other.getUsage();
        if (this$usage == null ? other$usage != null : !this$usage.equals(other$usage)) {
            return false;
        }
        String this$addkey = this.getAddkey();
        String other$addkey = other.getAddkey();
        if (this$addkey == null ? other$addkey != null : !this$addkey.equals(other$addkey)) {
            return false;
        }
        String this$creditorId = this.getCreditorId();
        String other$creditorId = other.getCreditorId();
        if (this$creditorId == null ? other$creditorId != null : !this$creditorId.equals(other$creditorId)) {
            return false;
        }
        String this$mandateReference = this.getMandateReference();
        String other$mandateReference = other.getMandateReference();
        if (this$mandateReference == null ? other$mandateReference != null : !this$mandateReference.equals(other$mandateReference)) {
            return false;
        }
        BankApiTO this$bankApi = this.getBankApi();
        BankApiTO other$bankApi = other.getBankApi();
        if (this$bankApi == null ? other$bankApi != null : !this$bankApi.equals(other$bankApi)) {
            return false;
        }
        BookingCategoryTO this$bookingCategory = this.getBookingCategory();
        BookingCategoryTO other$bookingCategory = other.getBookingCategory();
        if (this$bookingCategory == null ? other$bookingCategory != null : !this$bookingCategory.equals(other$bookingCategory)) {
            return false;
        }
        String this$transactionCode = this.getTransactionCode();
        String other$transactionCode = other.getTransactionCode();
        if (this$transactionCode == null ? other$transactionCode != null : !this$transactionCode.equals(other$transactionCode)) {
            return false;
        }
        String this$proprietaryBankTransactionCode = this.getProprietaryBankTransactionCode();
        String other$proprietaryBankTransactionCode = other.getProprietaryBankTransactionCode();
        return !(this$proprietaryBankTransactionCode == null ? other$proprietaryBankTransactionCode != null : !this$proprietaryBankTransactionCode.equals(other$proprietaryBankTransactionCode));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BookingTO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isReversal() ? 79 : 97);
        result = result * 59 + (this.isSepa() ? 79 : 97);
        result = result * 59 + (this.isStandingOrder() ? 79 : 97);
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $externalId = this.getExternalId();
        result = result * 59 + ($externalId == null ? 43 : $externalId.hashCode());
        BankAccountTO $otherAccount = this.getOtherAccount();
        result = result * 59 + ($otherAccount == null ? 43 : $otherAccount.hashCode());
        LocalDate $valutaDate = this.getValutaDate();
        result = result * 59 + ($valutaDate == null ? 43 : ((Object)$valutaDate).hashCode());
        LocalDate $bookingDate = this.getBookingDate();
        result = result * 59 + ($bookingDate == null ? 43 : ((Object)$bookingDate).hashCode());
        BigDecimal $amount = this.getAmount();
        result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
        String $currency = this.getCurrency();
        result = result * 59 + ($currency == null ? 43 : $currency.hashCode());
        BigDecimal $balance = this.getBalance();
        result = result * 59 + ($balance == null ? 43 : ((Object)$balance).hashCode());
        String $customerRef = this.getCustomerRef();
        result = result * 59 + ($customerRef == null ? 43 : $customerRef.hashCode());
        String $instRef = this.getInstRef();
        result = result * 59 + ($instRef == null ? 43 : $instRef.hashCode());
        BigDecimal $origValue = this.getOrigValue();
        result = result * 59 + ($origValue == null ? 43 : ((Object)$origValue).hashCode());
        BigDecimal $chargeValue = this.getChargeValue();
        result = result * 59 + ($chargeValue == null ? 43 : ((Object)$chargeValue).hashCode());
        String $text = this.getText();
        result = result * 59 + ($text == null ? 43 : $text.hashCode());
        String $additional = this.getAdditional();
        result = result * 59 + ($additional == null ? 43 : $additional.hashCode());
        String $primanota = this.getPrimanota();
        result = result * 59 + ($primanota == null ? 43 : $primanota.hashCode());
        String $usage = this.getUsage();
        result = result * 59 + ($usage == null ? 43 : $usage.hashCode());
        String $addkey = this.getAddkey();
        result = result * 59 + ($addkey == null ? 43 : $addkey.hashCode());
        String $creditorId = this.getCreditorId();
        result = result * 59 + ($creditorId == null ? 43 : $creditorId.hashCode());
        String $mandateReference = this.getMandateReference();
        result = result * 59 + ($mandateReference == null ? 43 : $mandateReference.hashCode());
        BankApiTO $bankApi = this.getBankApi();
        result = result * 59 + ($bankApi == null ? 43 : $bankApi.hashCode());
        BookingCategoryTO $bookingCategory = this.getBookingCategory();
        result = result * 59 + ($bookingCategory == null ? 43 : $bookingCategory.hashCode());
        String $transactionCode = this.getTransactionCode();
        result = result * 59 + ($transactionCode == null ? 43 : $transactionCode.hashCode());
        String $proprietaryBankTransactionCode = this.getProprietaryBankTransactionCode();
        result = result * 59 + ($proprietaryBankTransactionCode == null ? 43 : $proprietaryBankTransactionCode.hashCode());
        return result;
    }

    public String toString() {
        return "BookingTO(id=" + this.getId() + ", externalId=" + this.getExternalId() + ", otherAccount=" + this.getOtherAccount() + ", valutaDate=" + this.getValutaDate() + ", bookingDate=" + this.getBookingDate() + ", amount=" + this.getAmount() + ", currency=" + this.getCurrency() + ", reversal=" + this.isReversal() + ", balance=" + this.getBalance() + ", customerRef=" + this.getCustomerRef() + ", instRef=" + this.getInstRef() + ", origValue=" + this.getOrigValue() + ", chargeValue=" + this.getChargeValue() + ", text=" + this.getText() + ", additional=" + this.getAdditional() + ", primanota=" + this.getPrimanota() + ", usage=" + this.getUsage() + ", addkey=" + this.getAddkey() + ", sepa=" + this.isSepa() + ", standingOrder=" + this.isStandingOrder() + ", creditorId=" + this.getCreditorId() + ", mandateReference=" + this.getMandateReference() + ", bankApi=" + this.getBankApi() + ", bookingCategory=" + this.getBookingCategory() + ", transactionCode=" + this.getTransactionCode() + ", proprietaryBankTransactionCode=" + this.getProprietaryBankTransactionCode() + ")";
    }
}

