/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.web.mapper;

import de.adorsys.multibanking.domain.ContractEntity;
import de.adorsys.multibanking.domain.Frequency;
import de.adorsys.multibanking.web.mapper.ContractMapper;
import de.adorsys.multibanking.web.mapper.ContractMapperImpl;
import de.adorsys.multibanking.web.model.ContractTO;
import de.adorsys.multibanking.web.model.CycleTO;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class ContractMapperImpl
implements ContractMapper {
    public ContractTO toContractTO(ContractEntity contractEntity) {
        if (contractEntity == null) {
            return null;
        }
        ContractTO contractTO = new ContractTO();
        contractTO.setId(contractEntity.getId());
        contractTO.setLogo(contractEntity.getLogo());
        contractTO.setHomepage(contractEntity.getHomepage());
        contractTO.setHotline(contractEntity.getHotline());
        contractTO.setEmail(contractEntity.getEmail());
        contractTO.setMandateReference(contractEntity.getMandateReference());
        contractTO.setInterval(this.frequencyToCycleTO(contractEntity.getInterval()));
        contractTO.setCancelled(contractEntity.isCancelled());
        contractTO.setAmount(contractEntity.getAmount());
        contractTO.setMainCategory(contractEntity.getMainCategory());
        contractTO.setSubCategory(contractEntity.getSubCategory());
        contractTO.setSpecification(contractEntity.getSpecification());
        contractTO.setProvider(contractEntity.getProvider());
        return contractTO;
    }

    public List<ContractTO> toContractTOs(List<ContractEntity> contractEntities) {
        if (contractEntities == null) {
            return null;
        }
        ArrayList<ContractTO> list = new ArrayList<ContractTO>(contractEntities.size());
        for (ContractEntity contractEntity : contractEntities) {
            list.add(this.toContractTO(contractEntity));
        }
        return list;
    }

    protected CycleTO frequencyToCycleTO(Frequency frequency) {
        CycleTO cycleTO;
        if (frequency == null) {
            return null;
        }
        switch (1.$SwitchMap$de$adorsys$multibanking$domain$Frequency[frequency.ordinal()]) {
            case 1: {
                cycleTO = CycleTO.WEEKLY;
                break;
            }
            case 2: {
                cycleTO = CycleTO.TWO_WEEKLY;
                break;
            }
            case 3: {
                cycleTO = CycleTO.MONTHLY;
                break;
            }
            case 4: {
                cycleTO = CycleTO.TWO_MONTHLY;
                break;
            }
            case 5: {
                cycleTO = CycleTO.QUARTERLY;
                break;
            }
            case 6: {
                cycleTO = CycleTO.HALF_YEARLY;
                break;
            }
            case 7: {
                cycleTO = CycleTO.YEARLY;
                break;
            }
            case 8: {
                cycleTO = CycleTO.INVALID;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected enum constant: " + frequency);
            }
        }
        return cycleTO;
    }
}

