/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.web.mapper;

import de.adorsys.multibanking.domain.Balance;
import de.adorsys.multibanking.domain.BalancesReport;
import de.adorsys.multibanking.domain.BankAccount;
import de.adorsys.multibanking.domain.BankAccountEntity;
import de.adorsys.multibanking.domain.BankAccountType;
import de.adorsys.multibanking.web.mapper.BankAccountMapper;
import de.adorsys.multibanking.web.mapper.BankAccountMapperImpl;
import de.adorsys.multibanking.web.model.BalanceTO;
import de.adorsys.multibanking.web.model.BalancesReportTO;
import de.adorsys.multibanking.web.model.BankAccountTO;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class BankAccountMapperImpl
implements BankAccountMapper {
    public BankAccountTO toBankAccountTO(BankAccountEntity bankAccountEntity) {
        if (bankAccountEntity == null) {
            return null;
        }
        BankAccountTO bankAccountTO = new BankAccountTO();
        bankAccountTO.setId(bankAccountEntity.getId());
        bankAccountTO.setUserId(bankAccountEntity.getUserId());
        bankAccountTO.setBankAccessId(bankAccountEntity.getBankAccessId());
        bankAccountTO.setBalances(this.balancesReportToBalancesReportTO(bankAccountEntity.getBalances()));
        bankAccountTO.setOwner(bankAccountEntity.getOwner());
        bankAccountTO.setCountry(bankAccountEntity.getCountry());
        bankAccountTO.setBlz(bankAccountEntity.getBlz());
        bankAccountTO.setBankName(bankAccountEntity.getBankName());
        bankAccountTO.setAccountNumber(bankAccountEntity.getAccountNumber());
        bankAccountTO.setType(this.bankAccountTypeToBankAccountTypeTO(bankAccountEntity.getType()));
        bankAccountTO.setCurrency(bankAccountEntity.getCurrency());
        bankAccountTO.setName(bankAccountEntity.getName());
        bankAccountTO.setBic(bankAccountEntity.getBic());
        bankAccountTO.setIban(bankAccountEntity.getIban());
        bankAccountTO.setSyncStatus(this.syncStatusToSyncStatusTO(bankAccountEntity.getSyncStatus()));
        bankAccountTO.setLastSync(bankAccountEntity.getLastSync());
        return bankAccountTO;
    }

    public List<BankAccountTO> toBankAccountTOs(List<BankAccountEntity> bankAccountEntities) {
        if (bankAccountEntities == null) {
            return null;
        }
        ArrayList<BankAccountTO> list = new ArrayList<BankAccountTO>(bankAccountEntities.size());
        for (BankAccountEntity bankAccountEntity : bankAccountEntities) {
            list.add(this.toBankAccountTO(bankAccountEntity));
        }
        return list;
    }

    protected BalanceTO balanceToBalanceTO(Balance balance) {
        if (balance == null) {
            return null;
        }
        BalanceTO balanceTO = new BalanceTO();
        balanceTO.setDate(balance.getDate());
        balanceTO.setAmount(balance.getAmount());
        balanceTO.setCurrency(balance.getCurrency());
        return balanceTO;
    }

    protected BalancesReportTO balancesReportToBalancesReportTO(BalancesReport balancesReport) {
        if (balancesReport == null) {
            return null;
        }
        BalancesReportTO balancesReportTO = new BalancesReportTO();
        balancesReportTO.setReadyBalance(this.balanceToBalanceTO(balancesReport.getReadyBalance()));
        balancesReportTO.setUnreadyBalance(this.balanceToBalanceTO(balancesReport.getUnreadyBalance()));
        balancesReportTO.setCreditBalance(this.balanceToBalanceTO(balancesReport.getCreditBalance()));
        balancesReportTO.setAvailableBalance(this.balanceToBalanceTO(balancesReport.getAvailableBalance()));
        balancesReportTO.setUsedBalance(this.balanceToBalanceTO(balancesReport.getUsedBalance()));
        return balancesReportTO;
    }

    protected BankAccountTO.BankAccountTypeTO bankAccountTypeToBankAccountTypeTO(BankAccountType bankAccountType) {
        BankAccountTO.BankAccountTypeTO bankAccountTypeTO;
        if (bankAccountType == null) {
            return null;
        }
        switch (1.$SwitchMap$de$adorsys$multibanking$domain$BankAccountType[bankAccountType.ordinal()]) {
            case 1: {
                bankAccountTypeTO = BankAccountTO.BankAccountTypeTO.GIRO;
                break;
            }
            case 2: {
                bankAccountTypeTO = BankAccountTO.BankAccountTypeTO.SAVINGS;
                break;
            }
            case 3: {
                bankAccountTypeTO = BankAccountTO.BankAccountTypeTO.FIXEDTERMDEPOSIT;
                break;
            }
            case 4: {
                bankAccountTypeTO = BankAccountTO.BankAccountTypeTO.DEPOT;
                break;
            }
            case 5: {
                bankAccountTypeTO = BankAccountTO.BankAccountTypeTO.LOAN;
                break;
            }
            case 6: {
                bankAccountTypeTO = BankAccountTO.BankAccountTypeTO.CREDITCARD;
                break;
            }
            case 7: {
                bankAccountTypeTO = BankAccountTO.BankAccountTypeTO.BUIILDINGSAVING;
                break;
            }
            case 8: {
                bankAccountTypeTO = BankAccountTO.BankAccountTypeTO.INSURANCE;
                break;
            }
            case 9: {
                bankAccountTypeTO = BankAccountTO.BankAccountTypeTO.UNKNOWN;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected enum constant: " + bankAccountType);
            }
        }
        return bankAccountTypeTO;
    }

    protected BankAccountTO.SyncStatusTO syncStatusToSyncStatusTO(BankAccount.SyncStatus syncStatus) {
        BankAccountTO.SyncStatusTO syncStatusTO;
        if (syncStatus == null) {
            return null;
        }
        switch (1.$SwitchMap$de$adorsys$multibanking$domain$BankAccount$SyncStatus[syncStatus.ordinal()]) {
            case 1: {
                syncStatusTO = BankAccountTO.SyncStatusTO.PENDING;
                break;
            }
            case 2: {
                syncStatusTO = BankAccountTO.SyncStatusTO.SYNC;
                break;
            }
            case 3: {
                syncStatusTO = BankAccountTO.SyncStatusTO.READY;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected enum constant: " + syncStatus);
            }
        }
        return syncStatusTO;
    }
}

