/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.web;

import de.adorsys.multibanking.domain.BankAccessEntity;
import de.adorsys.multibanking.domain.BankAccount;
import de.adorsys.multibanking.domain.BankAccountEntity;
import de.adorsys.multibanking.domain.StandingOrderEntity;
import de.adorsys.multibanking.exception.ResourceNotFoundException;
import de.adorsys.multibanking.exception.SyncInProgressException;
import de.adorsys.multibanking.pers.spi.repository.BankAccessRepositoryIf;
import de.adorsys.multibanking.pers.spi.repository.BankAccountRepositoryIf;
import de.adorsys.multibanking.pers.spi.repository.StandingOrderRepositoryIf;
import de.adorsys.multibanking.web.UserResource;
import io.micrometer.core.annotation.Timed;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.security.Principal;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.Resources;
import org.springframework.hateoas.mvc.ControllerLinkBuilder;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Timed(value="standing-order")
@Tag(name="Standing order")
@UserResource
@RestController
@RequestMapping(path={"api/v1/bankaccesses/{accessId}/accounts/{accountId}/standingorders"})
public class StandingOrderController {
    private final StandingOrderRepositoryIf standingOrderRepository;
    private final BankAccessRepositoryIf bankAccessRepository;
    private final BankAccountRepositoryIf bankAccountRepository;
    private final Principal principal;

    @Operation(description="Read account standing orders", security={@SecurityRequirement(name="multibanking_auth", scopes={"openid"})})
    @GetMapping
    public Resources<StandingOrderEntity> getStandingOrders(@PathVariable String accessId, @PathVariable String accountId) {
        if (!this.bankAccessRepository.exists(accessId)) {
            throw new ResourceNotFoundException(BankAccessEntity.class, accessId);
        }
        if (!this.bankAccountRepository.exists(accountId)) {
            throw new ResourceNotFoundException(BankAccountEntity.class, accountId);
        }
        if (this.bankAccountRepository.getSyncStatus(accountId) == BankAccount.SyncStatus.SYNC) {
            throw new SyncInProgressException(accountId);
        }
        return new Resources((Iterable)this.standingOrderRepository.findByUserIdAndAccountId(this.principal.getName(), accountId), new Link[]{ControllerLinkBuilder.linkTo((Object)((StandingOrderController)ControllerLinkBuilder.methodOn(StandingOrderController.class, (Object[])new Object[0])).getStandingOrders(accessId, accountId)).withSelfRel()});
    }

    public StandingOrderController(StandingOrderRepositoryIf standingOrderRepository, BankAccessRepositoryIf bankAccessRepository, BankAccountRepositoryIf bankAccountRepository, Principal principal) {
        this.standingOrderRepository = standingOrderRepository;
        this.bankAccessRepository = bankAccessRepository;
        this.bankAccountRepository = bankAccountRepository;
        this.principal = principal;
    }
}

