/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.logging;

import java.util.Optional;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.MDC;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;
import org.springframework.web.util.UriTemplate;

@Component
public class LoggingRestInterceptor
extends HandlerInterceptorAdapter {
    private static final String CORRELATION_ID_HEADER = "Correlation-ID";
    private static final String CORRELATION_ID = "correlationId";
    private static final String BANK_ACCESS_ID = "accessId";

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        this.insertIntoMDC(request, handler);
        return super.preHandle(request, response, handler);
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {
        super.postHandle(request, response, handler, modelAndView);
        this.clearMDC();
    }

    private void insertIntoMDC(HttpServletRequest httpServletRequest, Object handler) {
        if (handler instanceof HandlerMethod) {
            String accessId = (String)new UriTemplate("api/v1/bankaccesses/{accessId}").match(httpServletRequest.getRequestURI()).get(BANK_ACCESS_ID);
            Optional.ofNullable(accessId).ifPresent(s -> MDC.put((String)BANK_ACCESS_ID, (String)s));
            Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
            Object userId = authentication == null || authentication.getName().equalsIgnoreCase("anonymousUser") ? "ANON-" + UUID.randomUUID() : authentication.getName();
            MDC.put((String)"user", (String)userId);
            MDC.put((String)CORRELATION_ID, (String)httpServletRequest.getHeader(CORRELATION_ID_HEADER));
            MDC.put((String)"req.remoteHost", (String)httpServletRequest.getRemoteHost());
            MDC.put((String)"req.requestURI", (String)httpServletRequest.getRequestURI());
            MDC.put((String)"req.method", (String)httpServletRequest.getMethod());
            MDC.put((String)"req.queryString", (String)httpServletRequest.getQueryString());
            MDC.put((String)"req.userAgent", (String)httpServletRequest.getHeader("User-Agent"));
            MDC.put((String)"req.xForwardedFor", (String)httpServletRequest.getHeader("X-Forwarded-For"));
            StringBuffer requestURL = httpServletRequest.getRequestURL();
            if (requestURL != null) {
                MDC.put((String)"req.requestURL", (String)requestURL.toString());
            }
        }
    }

    private void clearMDC() {
        MDC.remove((String)CORRELATION_ID);
        MDC.remove((String)BANK_ACCESS_ID);
        MDC.remove((String)"user");
        MDC.remove((String)"req.remoteHost");
        MDC.remove((String)"req.requestURI");
        MDC.remove((String)"req.queryString");
        MDC.remove((String)"req.requestURL");
        MDC.remove((String)"req.method");
        MDC.remove((String)"req.userAgent");
        MDC.remove((String)"req.xForwardedFor");
    }
}

