package de.adorsys.multibanking.service.analytics;

import de.adorsys.multibanking.domain.BankAccount;
import de.adorsys.multibanking.domain.BookingCategory;
import de.adorsys.multibanking.domain.BookingEntity;
import de.adorsys.multibanking.domain.BookingGroup.BookingGroupBuilder;
import de.adorsys.multibanking.domain.BookingGroup.Type;
import de.adorsys.multibanking.domain.BookingPeriod.BookingPeriodBuilder;
import de.adorsys.multibanking.domain.Contract;
import de.adorsys.multibanking.domain.ContractEntity;
import de.adorsys.multibanking.domain.Frequency;
import de.adorsys.smartanalytics.api.Booking;
import de.adorsys.smartanalytics.api.BookingGroup;
import de.adorsys.smartanalytics.api.BookingPeriod;
import de.adorsys.smartanalytics.api.Cycle;
import de.adorsys.smartanalytics.api.ExecutedBooking;
import de.adorsys.smartanalytics.api.WrappedBooking;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.Generated;
import org.springframework.stereotype.Component;

@Generated(
    value = "org.mapstruct.ap.MappingProcessor",
    date = "2021-10-25T09:25:22+0000",
    comments = "version: 1.4.1.Final, compiler: javac, environment: Java 11.0.13 (Azul Systems, Inc.)"
)
@Component
public class SmartAnalyticsMapperImpl extends SmartAnalyticsMapper {

    @Override
    BookingCategory toBookingcategory(WrappedBooking wrappedBooking) {
        if ( wrappedBooking == null ) {
            return null;
        }

        BookingCategory bookingCategory = new BookingCategory();

        bookingCategory.setInterval( cycleToFrequency( wrappedBooking.getCycle() ) );
        bookingCategory.setReceiver( wrappedBooking.getOtherAccount() );
        Set<String> set = wrappedBooking.getRuleIds();
        if ( set != null ) {
            bookingCategory.setRules( new HashSet<String>( set ) );
        }
        bookingCategory.setLogo( wrappedBooking.getLogo() );
        bookingCategory.setHomepage( wrappedBooking.getHomepage() );
        bookingCategory.setHotline( wrappedBooking.getHotline() );
        bookingCategory.setEmail( wrappedBooking.getEmail() );
        bookingCategory.setMandateReference( wrappedBooking.getMandateReference() );
        bookingCategory.setAmount( wrappedBooking.getAmount() );
        bookingCategory.setMainCategory( wrappedBooking.getMainCategory() );
        bookingCategory.setSubCategory( wrappedBooking.getSubCategory() );
        bookingCategory.setSpecification( wrappedBooking.getSpecification() );
        Map<String, String> map = wrappedBooking.getCustom();
        if ( map != null ) {
            bookingCategory.setCustom( new HashMap<String, String>( map ) );
        }

        return bookingCategory;
    }

    @Override
    List<de.adorsys.multibanking.domain.BookingGroup> mapBookingGroups(List<BookingGroup> bookingGroups) {
        if ( bookingGroups == null ) {
            return null;
        }

        List<de.adorsys.multibanking.domain.BookingGroup> list = new ArrayList<de.adorsys.multibanking.domain.BookingGroup>( bookingGroups.size() );
        for ( BookingGroup bookingGroup : bookingGroups ) {
            list.add( mapBookingGroup( bookingGroup ) );
        }

        return list;
    }

    @Override
    de.adorsys.multibanking.domain.BookingGroup mapBookingGroup(BookingGroup bookingGroup) {
        if ( bookingGroup == null ) {
            return null;
        }

        BookingGroupBuilder bookingGroup1 = de.adorsys.multibanking.domain.BookingGroup.builder();

        bookingGroup1.type( typeToType( bookingGroup.getGroupType() ) );
        bookingGroup1.contract( toContract( bookingGroup ) );
        bookingGroup1.name( bookingGroup.getName() );
        bookingGroup1.salaryWage( bookingGroup.isSalaryWage() );
        bookingGroup1.mainCategory( bookingGroup.getMainCategory() );
        bookingGroup1.subCategory( bookingGroup.getSubCategory() );
        bookingGroup1.specification( bookingGroup.getSpecification() );
        bookingGroup1.amount( bookingGroup.getAmount() );
        bookingGroup1.bookingPeriods( bookingPeriodListToBookingPeriodList( bookingGroup.getBookingPeriods() ) );

        mapBookingGroupAfterMapping( bookingGroup, bookingGroup1 );

        return bookingGroup1.build();
    }

    @Override
    Contract toContract(BookingGroup bookingsGroup) {
        if ( bookingsGroup == null ) {
            return null;
        }

        Contract contract = new Contract();

        contract.setMandateReference( bookingsGroup.getMandatreference() );
        contract.setInterval( cycleToFrequency( bookingsGroup.getCycle() ) );
        contract.setLogo( bookingsGroup.getLogo() );
        contract.setHomepage( bookingsGroup.getHomepage() );
        contract.setHotline( bookingsGroup.getHotline() );
        contract.setEmail( bookingsGroup.getEmail() );
        contract.setCancelled( bookingsGroup.isCancelled() );
        contract.setAmount( bookingsGroup.getAmount() );
        contract.setMainCategory( bookingsGroup.getMainCategory() );
        contract.setSubCategory( bookingsGroup.getSubCategory() );
        contract.setSpecification( bookingsGroup.getSpecification() );

        return contract;
    }

    @Override
    ContractEntity toContractEntity(String userId, String accountId, BookingGroup bookingGroup) {
        if ( userId == null && accountId == null && bookingGroup == null ) {
            return null;
        }

        ContractEntity contractEntity = new ContractEntity();

        if ( userId != null ) {
            contractEntity.setUserId( userId );
        }
        if ( accountId != null ) {
            contractEntity.setAccountId( accountId );
        }
        if ( bookingGroup != null ) {
            contractEntity.setMandateReference( bookingGroup.getMandatreference() );
            contractEntity.setInterval( cycleToFrequency( bookingGroup.getCycle() ) );
            contractEntity.setProvider( bookingGroup.getOtherAccount() );
            contractEntity.setLogo( bookingGroup.getLogo() );
            contractEntity.setHomepage( bookingGroup.getHomepage() );
            contractEntity.setHotline( bookingGroup.getHotline() );
            contractEntity.setEmail( bookingGroup.getEmail() );
            contractEntity.setCancelled( bookingGroup.isCancelled() );
            contractEntity.setAmount( bookingGroup.getAmount() );
            contractEntity.setMainCategory( bookingGroup.getMainCategory() );
            contractEntity.setSubCategory( bookingGroup.getSubCategory() );
            contractEntity.setSpecification( bookingGroup.getSpecification() );
        }

        return contractEntity;
    }

    @Override
    List<Booking> toSmartAnalyticsBookings(Collection<BookingEntity> bookings) {
        if ( bookings == null ) {
            return null;
        }

        List<Booking> list = new ArrayList<Booking>( bookings.size() );
        for ( BookingEntity bookingEntity : bookings ) {
            list.add( toSmartAnalyticsBooking( bookingEntity ) );
        }

        return list;
    }

    @Override
    Booking toSmartAnalyticsBooking(BookingEntity booking) {
        if ( booking == null ) {
            return null;
        }

        Booking booking1 = new Booking();

        booking1.setBookingId( booking.getExternalId() );
        booking1.setPurpose( booking.getUsage() );
        booking1.setExecutionDate( booking.getValutaDate() );
        booking1.setIban( bookingOtherAccountIban( booking ) );
        booking1.setAccountNumber( bookingOtherAccountAccountNumber( booking ) );
        booking1.setBankCode( bookingOtherAccountBlz( booking ) );
        booking1.setAmount( booking.getAmount() );
        booking1.setCreditorId( booking.getCreditorId() );
        booking1.setStandingOrder( booking.isStandingOrder() );
        booking1.setMandateReference( booking.getMandateReference() );

        toSmartAnalyticsBookingAfterMapping( booking, booking1 );

        return booking1;
    }

    protected Frequency cycleToFrequency(Cycle cycle) {
        if ( cycle == null ) {
            return null;
        }

        Frequency frequency;

        switch ( cycle ) {
            case WEEKLY: frequency = Frequency.WEEKLY;
            break;
            case MONTHLY: frequency = Frequency.MONTHLY;
            break;
            case TWO_MONTHLY: frequency = Frequency.TWO_MONTHLY;
            break;
            case QUARTERLY: frequency = Frequency.QUARTERLY;
            break;
            case HALF_YEARLY: frequency = Frequency.HALF_YEARLY;
            break;
            case YEARLY: frequency = Frequency.YEARLY;
            break;
            default: throw new IllegalArgumentException( "Unexpected enum constant: " + cycle );
        }

        return frequency;
    }

    protected Type typeToType(de.adorsys.smartanalytics.api.config.Group.Type type) {
        if ( type == null ) {
            return null;
        }

        Type type1;

        switch ( type ) {
            case STANDING_ORDER: type1 = Type.STANDING_ORDER;
            break;
            case RECURRENT_INCOME: type1 = Type.RECURRENT_INCOME;
            break;
            case RECURRENT_SEPA: type1 = Type.RECURRENT_SEPA;
            break;
            case RECURRENT_NONSEPA: type1 = Type.RECURRENT_NONSEPA;
            break;
            case CUSTOM: type1 = Type.CUSTOM;
            break;
            case OTHER_INCOME: type1 = Type.OTHER_INCOME;
            break;
            case OTHER_EXPENSES: type1 = Type.OTHER_EXPENSES;
            break;
            default: throw new IllegalArgumentException( "Unexpected enum constant: " + type );
        }

        return type1;
    }

    protected de.adorsys.multibanking.domain.ExecutedBooking executedBookingToExecutedBooking(ExecutedBooking executedBooking) {
        if ( executedBooking == null ) {
            return null;
        }

        de.adorsys.multibanking.domain.ExecutedBooking executedBooking1 = new de.adorsys.multibanking.domain.ExecutedBooking();

        executedBooking1.setBookingId( executedBooking.getBookingId() );
        executedBooking1.setExecutionDate( executedBooking.getExecutionDate() );
        executedBooking1.setExecuted( executedBooking.isExecuted() );

        return executedBooking1;
    }

    protected List<de.adorsys.multibanking.domain.ExecutedBooking> executedBookingListToExecutedBookingList(List<ExecutedBooking> list) {
        if ( list == null ) {
            return null;
        }

        List<de.adorsys.multibanking.domain.ExecutedBooking> list1 = new ArrayList<de.adorsys.multibanking.domain.ExecutedBooking>( list.size() );
        for ( ExecutedBooking executedBooking : list ) {
            list1.add( executedBookingToExecutedBooking( executedBooking ) );
        }

        return list1;
    }

    protected de.adorsys.multibanking.domain.BookingPeriod bookingPeriodToBookingPeriod(BookingPeriod bookingPeriod) {
        if ( bookingPeriod == null ) {
            return null;
        }

        BookingPeriodBuilder bookingPeriod1 = de.adorsys.multibanking.domain.BookingPeriod.builder();

        bookingPeriod1.start( bookingPeriod.getStart() );
        bookingPeriod1.end( bookingPeriod.getEnd() );
        bookingPeriod1.amount( bookingPeriod.getAmount() );
        bookingPeriod1.bookings( executedBookingListToExecutedBookingList( bookingPeriod.getBookings() ) );

        return bookingPeriod1.build();
    }

    protected List<de.adorsys.multibanking.domain.BookingPeriod> bookingPeriodListToBookingPeriodList(List<BookingPeriod> list) {
        if ( list == null ) {
            return null;
        }

        List<de.adorsys.multibanking.domain.BookingPeriod> list1 = new ArrayList<de.adorsys.multibanking.domain.BookingPeriod>( list.size() );
        for ( BookingPeriod bookingPeriod : list ) {
            list1.add( bookingPeriodToBookingPeriod( bookingPeriod ) );
        }

        return list1;
    }

    private String bookingOtherAccountIban(BookingEntity bookingEntity) {
        if ( bookingEntity == null ) {
            return null;
        }
        BankAccount otherAccount = bookingEntity.getOtherAccount();
        if ( otherAccount == null ) {
            return null;
        }
        String iban = otherAccount.getIban();
        if ( iban == null ) {
            return null;
        }
        return iban;
    }

    private String bookingOtherAccountAccountNumber(BookingEntity bookingEntity) {
        if ( bookingEntity == null ) {
            return null;
        }
        BankAccount otherAccount = bookingEntity.getOtherAccount();
        if ( otherAccount == null ) {
            return null;
        }
        String accountNumber = otherAccount.getAccountNumber();
        if ( accountNumber == null ) {
            return null;
        }
        return accountNumber;
    }

    private String bookingOtherAccountBlz(BookingEntity bookingEntity) {
        if ( bookingEntity == null ) {
            return null;
        }
        BankAccount otherAccount = bookingEntity.getOtherAccount();
        if ( otherAccount == null ) {
            return null;
        }
        String blz = otherAccount.getBlz();
        if ( blz == null ) {
            return null;
        }
        return blz;
    }
}
