package de.adorsys.multibanking.web.mapper;

import de.adorsys.multibanking.domain.AccountReference;
import de.adorsys.multibanking.domain.BankApi;
import de.adorsys.multibanking.domain.Consent;
import de.adorsys.multibanking.domain.ConsentEntity;
import de.adorsys.multibanking.domain.ConsentStatus;
import de.adorsys.multibanking.domain.ScaApproach;
import de.adorsys.multibanking.domain.response.CreateConsentResponse;
import de.adorsys.multibanking.web.model.AccountReferenceTO;
import de.adorsys.multibanking.web.model.ConsentStatusTO;
import de.adorsys.multibanking.web.model.ConsentTO;
import de.adorsys.multibanking.web.model.CreateConsentResponseTO;
import de.adorsys.multibanking.web.model.ScaApproachTO;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.processing.Generated;
import org.springframework.stereotype.Component;

@Generated(
    value = "org.mapstruct.ap.MappingProcessor",
    date = "2021-08-06T12:57:18+0000",
    comments = "version: 1.4.1.Final, compiler: javac, environment: Java 11.0.12 (Azul Systems, Inc.)"
)
@Component
public class MultibankingConsentMapperImpl implements ConsentMapper {

    @Override
    public ConsentTO toConsentTO(Consent consent) {
        if ( consent == null ) {
            return null;
        }

        ConsentTO consentTO = new ConsentTO();

        consentTO.setId( consent.getConsentId() );
        consentTO.setTemporary( consent.isTemporary() );
        consentTO.setRedirectId( consent.getRedirectId() );
        consentTO.setPsuId( consent.getPsuId() );
        consentTO.setPsuAccountIban( consent.getPsuAccountIban() );
        consentTO.setAccounts( accountReferenceListToAccountReferenceTOList( consent.getAccounts() ) );
        consentTO.setBalances( accountReferenceListToAccountReferenceTOList( consent.getBalances() ) );
        consentTO.setTransactions( accountReferenceListToAccountReferenceTOList( consent.getTransactions() ) );
        consentTO.setRecurringIndicator( consent.isRecurringIndicator() );
        consentTO.setValidUntil( consent.getValidUntil() );
        consentTO.setFrequencyPerDay( consent.getFrequencyPerDay() );

        return consentTO;
    }

    @Override
    public Consent toConsent(ConsentTO consent) {
        if ( consent == null ) {
            return null;
        }

        Consent consent1 = new Consent();

        consent1.setConsentId( consent.getId() );
        consent1.setRedirectId( consent.getRedirectId() );
        consent1.setPsuId( consent.getPsuId() );
        consent1.setPsuAccountIban( consent.getPsuAccountIban() );
        consent1.setAccounts( accountReferenceTOListToAccountReferenceList( consent.getAccounts() ) );
        consent1.setBalances( accountReferenceTOListToAccountReferenceList( consent.getBalances() ) );
        consent1.setTransactions( accountReferenceTOListToAccountReferenceList( consent.getTransactions() ) );
        consent1.setRecurringIndicator( consent.isRecurringIndicator() );
        consent1.setValidUntil( consent.getValidUntil() );
        consent1.setFrequencyPerDay( consent.getFrequencyPerDay() );

        return consent1;
    }

    @Override
    public ConsentStatusTO toConsentStatusTO(ConsentStatus consentStatus) {
        if ( consentStatus == null ) {
            return null;
        }

        ConsentStatusTO consentStatusTO;

        switch ( consentStatus ) {
            case RECEIVED: consentStatusTO = ConsentStatusTO.RECEIVED;
            break;
            case REJECTED: consentStatusTO = ConsentStatusTO.REJECTED;
            break;
            case VALID: consentStatusTO = ConsentStatusTO.VALID;
            break;
            case REVOKEDBYPSU: consentStatusTO = ConsentStatusTO.REVOKEDBYPSU;
            break;
            case EXPIRED: consentStatusTO = ConsentStatusTO.EXPIRED;
            break;
            case TERMINATEDBYTPP: consentStatusTO = ConsentStatusTO.TERMINATEDBYTPP;
            break;
            case TERMINATED_BY_ASPSP: consentStatusTO = ConsentStatusTO.TERMINATED_BY_ASPSP;
            break;
            case PARTIALLY_AUTHORISED: consentStatusTO = ConsentStatusTO.PARTIALLY_AUTHORISED;
            break;
            default: throw new IllegalArgumentException( "Unexpected enum constant: " + consentStatus );
        }

        return consentStatusTO;
    }

    @Override
    public Consent toConsent(ConsentEntity consent) {
        if ( consent == null ) {
            return null;
        }

        Consent consent1 = new Consent();

        consent1.setConsentId( consent.getId() );
        consent1.setTemporary( consent.isTemporary() );
        consent1.setRedirectId( consent.getRedirectId() );
        consent1.setPsuAccountIban( consent.getPsuAccountIban() );

        return consent1;
    }

    @Override
    public CreateConsentResponseTO toCreateConsentResponseTO(CreateConsentResponse createConsentResponse) {
        if ( createConsentResponse == null ) {
            return null;
        }

        CreateConsentResponseTO createConsentResponseTO = new CreateConsentResponseTO();

        createConsentResponseTO.setScaApproach( scaApproachToScaApproachTO( createConsentResponse.getScaApproach() ) );
        createConsentResponseTO.setConsentId( createConsentResponse.getConsentId() );
        createConsentResponseTO.setAuthorisationId( createConsentResponse.getAuthorisationId() );

        return createConsentResponseTO;
    }

    @Override
    public ConsentEntity toConsentEntity(CreateConsentResponse createConsentResponse, String redirectId, String psuAccountIban, BankApi bankApi) {
        if ( createConsentResponse == null && redirectId == null && psuAccountIban == null && bankApi == null ) {
            return null;
        }

        ConsentEntity consentEntity = new ConsentEntity();

        if ( createConsentResponse != null ) {
            consentEntity.setId( createConsentResponse.getConsentId() );
            consentEntity.setAuthorisationId( createConsentResponse.getAuthorisationId() );
            consentEntity.setBankApiConsentData( createConsentResponse.getBankApiConsentData() );
            consentEntity.setRedirectId( createConsentResponse.getRedirectId() );
        }
        if ( psuAccountIban != null ) {
            consentEntity.setPsuAccountIban( psuAccountIban );
        }
        if ( bankApi != null ) {
            consentEntity.setBankApi( bankApi );
        }

        return consentEntity;
    }

    protected AccountReferenceTO accountReferenceToAccountReferenceTO(AccountReference accountReference) {
        if ( accountReference == null ) {
            return null;
        }

        AccountReferenceTO accountReferenceTO = new AccountReferenceTO();

        accountReferenceTO.setIban( accountReference.getIban() );
        accountReferenceTO.setCurrency( accountReference.getCurrency() );

        return accountReferenceTO;
    }

    protected List<AccountReferenceTO> accountReferenceListToAccountReferenceTOList(List<AccountReference> list) {
        if ( list == null ) {
            return null;
        }

        List<AccountReferenceTO> list1 = new ArrayList<AccountReferenceTO>( list.size() );
        for ( AccountReference accountReference : list ) {
            list1.add( accountReferenceToAccountReferenceTO( accountReference ) );
        }

        return list1;
    }

    protected AccountReference accountReferenceTOToAccountReference(AccountReferenceTO accountReferenceTO) {
        if ( accountReferenceTO == null ) {
            return null;
        }

        AccountReference accountReference = new AccountReference();

        accountReference.setIban( accountReferenceTO.getIban() );
        accountReference.setCurrency( accountReferenceTO.getCurrency() );

        return accountReference;
    }

    protected List<AccountReference> accountReferenceTOListToAccountReferenceList(List<AccountReferenceTO> list) {
        if ( list == null ) {
            return null;
        }

        List<AccountReference> list1 = new ArrayList<AccountReference>( list.size() );
        for ( AccountReferenceTO accountReferenceTO : list ) {
            list1.add( accountReferenceTOToAccountReference( accountReferenceTO ) );
        }

        return list1;
    }

    protected ScaApproachTO scaApproachToScaApproachTO(ScaApproach scaApproach) {
        if ( scaApproach == null ) {
            return null;
        }

        ScaApproachTO scaApproachTO;

        switch ( scaApproach ) {
            case EMBEDDED: scaApproachTO = ScaApproachTO.EMBEDDED;
            break;
            case REDIRECT: scaApproachTO = ScaApproachTO.REDIRECT;
            break;
            case DECOUPLED: scaApproachTO = ScaApproachTO.DECOUPLED;
            break;
            case OAUTH: scaApproachTO = ScaApproachTO.OAUTH;
            break;
            case OAUTH_PRESTEP: scaApproachTO = ScaApproachTO.OAUTH_PRESTEP;
            break;
            default: throw new IllegalArgumentException( "Unexpected enum constant: " + scaApproach );
        }

        return scaApproachTO;
    }
}
