package de.adorsys.multibanking.web.mapper;

import de.adorsys.multibanking.domain.Balance;
import de.adorsys.multibanking.domain.BalancesReport;
import de.adorsys.multibanking.domain.BankAccount;
import de.adorsys.multibanking.domain.BankAccount.SyncStatus;
import de.adorsys.multibanking.domain.BankAccountType;
import de.adorsys.multibanking.domain.BankApi;
import de.adorsys.multibanking.domain.BookingCategory;
import de.adorsys.multibanking.domain.BookingEntity;
import de.adorsys.multibanking.domain.Frequency;
import de.adorsys.multibanking.web.model.BalanceTO;
import de.adorsys.multibanking.web.model.BalancesReportTO;
import de.adorsys.multibanking.web.model.BankAccountTO;
import de.adorsys.multibanking.web.model.BankAccountTO.BankAccountTypeTO;
import de.adorsys.multibanking.web.model.BankAccountTO.SyncStatusTO;
import de.adorsys.multibanking.web.model.BankApiTO;
import de.adorsys.multibanking.web.model.BookingCategoryTO;
import de.adorsys.multibanking.web.model.BookingTO;
import de.adorsys.multibanking.web.model.CycleTO;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Generated;
import org.springframework.stereotype.Component;

@Generated(
    value = "org.mapstruct.ap.MappingProcessor",
    date = "2020-02-06T08:58:17+0000",
    comments = "version: 1.3.0.Final, compiler: javac, environment: Java 1.8.0_222 (Private Build)"
)
@Component
public class BookingMapperImpl implements BookingMapper {

    @Override
    public BookingTO toBookingTO(BookingEntity bookingEntity) {
        if ( bookingEntity == null ) {
            return null;
        }

        BookingTO bookingTO = new BookingTO();

        bookingTO.setId( bookingEntity.getId() );
        bookingTO.setExternalId( bookingEntity.getExternalId() );
        bookingTO.setOtherAccount( bankAccountToBankAccountTO( bookingEntity.getOtherAccount() ) );
        bookingTO.setValutaDate( bookingEntity.getValutaDate() );
        bookingTO.setBookingDate( bookingEntity.getBookingDate() );
        bookingTO.setAmount( bookingEntity.getAmount() );
        bookingTO.setCurrency( bookingEntity.getCurrency() );
        bookingTO.setReversal( bookingEntity.isReversal() );
        bookingTO.setBalance( bookingEntity.getBalance() );
        bookingTO.setCustomerRef( bookingEntity.getCustomerRef() );
        bookingTO.setInstRef( bookingEntity.getInstRef() );
        bookingTO.setOrigValue( bookingEntity.getOrigValue() );
        bookingTO.setChargeValue( bookingEntity.getChargeValue() );
        bookingTO.setText( bookingEntity.getText() );
        bookingTO.setAdditional( bookingEntity.getAdditional() );
        bookingTO.setPrimanota( bookingEntity.getPrimanota() );
        bookingTO.setUsage( bookingEntity.getUsage() );
        bookingTO.setAddkey( bookingEntity.getAddkey() );
        bookingTO.setSepa( bookingEntity.isSepa() );
        bookingTO.setStandingOrder( bookingEntity.isStandingOrder() );
        bookingTO.setCreditorId( bookingEntity.getCreditorId() );
        bookingTO.setMandateReference( bookingEntity.getMandateReference() );
        bookingTO.setBankApi( bankApiToBankApiTO( bookingEntity.getBankApi() ) );
        bookingTO.setBookingCategory( bookingCategoryToBookingCategoryTO( bookingEntity.getBookingCategory() ) );
        bookingTO.setTransactionCode( bookingEntity.getTransactionCode() );

        return bookingTO;
    }

    @Override
    public List<BookingTO> toBookingTOs(Iterable<BookingEntity> bookingEntities) {
        if ( bookingEntities == null ) {
            return null;
        }

        List<BookingTO> list = new ArrayList<BookingTO>();
        for ( BookingEntity bookingEntity : bookingEntities ) {
            list.add( toBookingTO( bookingEntity ) );
        }

        return list;
    }

    protected BalanceTO balanceToBalanceTO(Balance balance) {
        if ( balance == null ) {
            return null;
        }

        BalanceTO balanceTO = new BalanceTO();

        balanceTO.setDate( balance.getDate() );
        balanceTO.setAmount( balance.getAmount() );
        balanceTO.setCurrency( balance.getCurrency() );

        return balanceTO;
    }

    protected BalancesReportTO balancesReportToBalancesReportTO(BalancesReport balancesReport) {
        if ( balancesReport == null ) {
            return null;
        }

        BalancesReportTO balancesReportTO = new BalancesReportTO();

        balancesReportTO.setReadyBalance( balanceToBalanceTO( balancesReport.getReadyBalance() ) );
        balancesReportTO.setUnreadyBalance( balanceToBalanceTO( balancesReport.getUnreadyBalance() ) );
        balancesReportTO.setCreditBalance( balanceToBalanceTO( balancesReport.getCreditBalance() ) );
        balancesReportTO.setAvailableBalance( balanceToBalanceTO( balancesReport.getAvailableBalance() ) );
        balancesReportTO.setUsedBalance( balanceToBalanceTO( balancesReport.getUsedBalance() ) );

        return balancesReportTO;
    }

    protected BankAccountTypeTO bankAccountTypeToBankAccountTypeTO(BankAccountType bankAccountType) {
        if ( bankAccountType == null ) {
            return null;
        }

        BankAccountTypeTO bankAccountTypeTO;

        switch ( bankAccountType ) {
            case GIRO: bankAccountTypeTO = BankAccountTypeTO.GIRO;
            break;
            case SAVINGS: bankAccountTypeTO = BankAccountTypeTO.SAVINGS;
            break;
            case FIXEDTERMDEPOSIT: bankAccountTypeTO = BankAccountTypeTO.FIXEDTERMDEPOSIT;
            break;
            case DEPOT: bankAccountTypeTO = BankAccountTypeTO.DEPOT;
            break;
            case LOAN: bankAccountTypeTO = BankAccountTypeTO.LOAN;
            break;
            case CREDITCARD: bankAccountTypeTO = BankAccountTypeTO.CREDITCARD;
            break;
            case BUIILDINGSAVING: bankAccountTypeTO = BankAccountTypeTO.BUIILDINGSAVING;
            break;
            case INSURANCE: bankAccountTypeTO = BankAccountTypeTO.INSURANCE;
            break;
            case UNKNOWN: bankAccountTypeTO = BankAccountTypeTO.UNKNOWN;
            break;
            default: throw new IllegalArgumentException( "Unexpected enum constant: " + bankAccountType );
        }

        return bankAccountTypeTO;
    }

    protected SyncStatusTO syncStatusToSyncStatusTO(SyncStatus syncStatus) {
        if ( syncStatus == null ) {
            return null;
        }

        SyncStatusTO syncStatusTO;

        switch ( syncStatus ) {
            case PENDING: syncStatusTO = SyncStatusTO.PENDING;
            break;
            case SYNC: syncStatusTO = SyncStatusTO.SYNC;
            break;
            case READY: syncStatusTO = SyncStatusTO.READY;
            break;
            default: throw new IllegalArgumentException( "Unexpected enum constant: " + syncStatus );
        }

        return syncStatusTO;
    }

    protected BankAccountTO bankAccountToBankAccountTO(BankAccount bankAccount) {
        if ( bankAccount == null ) {
            return null;
        }

        BankAccountTO bankAccountTO = new BankAccountTO();

        bankAccountTO.setBalances( balancesReportToBalancesReportTO( bankAccount.getBalances() ) );
        bankAccountTO.setOwner( bankAccount.getOwner() );
        bankAccountTO.setCountry( bankAccount.getCountry() );
        bankAccountTO.setBlz( bankAccount.getBlz() );
        bankAccountTO.setBankName( bankAccount.getBankName() );
        bankAccountTO.setAccountNumber( bankAccount.getAccountNumber() );
        bankAccountTO.setType( bankAccountTypeToBankAccountTypeTO( bankAccount.getType() ) );
        bankAccountTO.setCurrency( bankAccount.getCurrency() );
        bankAccountTO.setName( bankAccount.getName() );
        bankAccountTO.setBic( bankAccount.getBic() );
        bankAccountTO.setIban( bankAccount.getIban() );
        bankAccountTO.setSyncStatus( syncStatusToSyncStatusTO( bankAccount.getSyncStatus() ) );
        bankAccountTO.setLastSync( bankAccount.getLastSync() );

        return bankAccountTO;
    }

    protected BankApiTO bankApiToBankApiTO(BankApi bankApi) {
        if ( bankApi == null ) {
            return null;
        }

        BankApiTO bankApiTO;

        switch ( bankApi ) {
            case HBCI: bankApiTO = BankApiTO.HBCI;
            break;
            case FIGO: bankApiTO = BankApiTO.FIGO;
            break;
            case FINAPI: bankApiTO = BankApiTO.FINAPI;
            break;
            case XS2A: bankApiTO = BankApiTO.XS2A;
            break;
            case ING: bankApiTO = BankApiTO.ING;
            break;
            case FIGO_ALTERNATIVE: bankApiTO = BankApiTO.FIGO_ALTERNATIVE;
            break;
            default: throw new IllegalArgumentException( "Unexpected enum constant: " + bankApi );
        }

        return bankApiTO;
    }

    protected CycleTO frequencyToCycleTO(Frequency frequency) {
        if ( frequency == null ) {
            return null;
        }

        CycleTO cycleTO;

        switch ( frequency ) {
            case WEEKLY: cycleTO = CycleTO.WEEKLY;
            break;
            case TWO_WEEKLY: cycleTO = CycleTO.TWO_WEEKLY;
            break;
            case MONTHLY: cycleTO = CycleTO.MONTHLY;
            break;
            case TWO_MONTHLY: cycleTO = CycleTO.TWO_MONTHLY;
            break;
            case QUARTERLY: cycleTO = CycleTO.QUARTERLY;
            break;
            case HALF_YEARLY: cycleTO = CycleTO.HALF_YEARLY;
            break;
            case YEARLY: cycleTO = CycleTO.YEARLY;
            break;
            case INVALID: cycleTO = CycleTO.INVALID;
            break;
            default: throw new IllegalArgumentException( "Unexpected enum constant: " + frequency );
        }

        return cycleTO;
    }

    protected BookingCategoryTO bookingCategoryToBookingCategoryTO(BookingCategory bookingCategory) {
        if ( bookingCategory == null ) {
            return null;
        }

        BookingCategoryTO bookingCategoryTO = new BookingCategoryTO();

        bookingCategoryTO.setLogo( bookingCategory.getLogo() );
        bookingCategoryTO.setHomepage( bookingCategory.getHomepage() );
        bookingCategoryTO.setHotline( bookingCategory.getHotline() );
        bookingCategoryTO.setEmail( bookingCategory.getEmail() );
        bookingCategoryTO.setMandateReference( bookingCategory.getMandateReference() );
        bookingCategoryTO.setInterval( frequencyToCycleTO( bookingCategory.getInterval() ) );
        bookingCategoryTO.setCancelled( bookingCategory.isCancelled() );
        bookingCategoryTO.setAmount( bookingCategory.getAmount() );
        bookingCategoryTO.setMainCategory( bookingCategory.getMainCategory() );
        bookingCategoryTO.setSubCategory( bookingCategory.getSubCategory() );
        bookingCategoryTO.setSpecification( bookingCategory.getSpecification() );
        bookingCategoryTO.setProvider( bookingCategory.getProvider() );
        Set<String> set = bookingCategory.getRules();
        if ( set != null ) {
            bookingCategoryTO.setRules( new HashSet<String>( set ) );
        }
        bookingCategoryTO.setReceiver( bookingCategory.getReceiver() );
        Map<String, String> map = bookingCategory.getCustom();
        if ( map != null ) {
            bookingCategoryTO.setCustom( new HashMap<String, String>( map ) );
        }

        return bookingCategoryTO;
    }
}
