package de.adorsys.multibanking.web.mapper;

import de.adorsys.multibanking.domain.BankApi;
import de.adorsys.multibanking.domain.BankEntity;
import de.adorsys.multibanking.domain.BankLoginCredentialInfo;
import de.adorsys.multibanking.domain.BankLoginSettings;
import de.adorsys.multibanking.web.model.BankApiTO;
import de.adorsys.multibanking.web.model.BankLoginCredentialInfoTO;
import de.adorsys.multibanking.web.model.BankLoginSettingsTO;
import de.adorsys.multibanking.web.model.BankTO;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Generated;
import org.springframework.stereotype.Component;

@Generated(
    value = "org.mapstruct.ap.MappingProcessor",
    date = "2020-02-06T08:58:17+0000",
    comments = "version: 1.3.0.Final, compiler: javac, environment: Java 1.8.0_222 (Private Build)"
)
@Component
public class BankMapperImpl implements BankMapper {

    @Override
    public BankTO toBankTO(BankEntity bankEntity) {
        if ( bankEntity == null ) {
            return null;
        }

        BankTO bankTO = new BankTO();

        bankTO.setBankingUrl( bankEntity.getBankingUrl() );
        bankTO.setBankCode( bankEntity.getBankCode() );
        bankTO.setBic( bankEntity.getBic() );
        bankTO.setName( bankEntity.getName() );
        bankTO.setLoginSettings( bankLoginSettingsToBankLoginSettingsTO( bankEntity.getLoginSettings() ) );
        bankTO.setBankApi( bankApiToBankApiTO( bankEntity.getBankApi() ) );

        return bankTO;
    }

    protected BankLoginCredentialInfoTO bankLoginCredentialInfoToBankLoginCredentialInfoTO(BankLoginCredentialInfo bankLoginCredentialInfo) {
        if ( bankLoginCredentialInfo == null ) {
            return null;
        }

        BankLoginCredentialInfoTO bankLoginCredentialInfoTO = new BankLoginCredentialInfoTO();

        bankLoginCredentialInfoTO.setLabel( bankLoginCredentialInfo.getLabel() );
        bankLoginCredentialInfoTO.setFieldName( bankLoginCredentialInfo.getFieldName() );
        bankLoginCredentialInfoTO.setMasked( bankLoginCredentialInfo.isMasked() );
        bankLoginCredentialInfoTO.setOptional( bankLoginCredentialInfo.isOptional() );

        return bankLoginCredentialInfoTO;
    }

    protected List<BankLoginCredentialInfoTO> bankLoginCredentialInfoListToBankLoginCredentialInfoTOList(List<BankLoginCredentialInfo> list) {
        if ( list == null ) {
            return null;
        }

        List<BankLoginCredentialInfoTO> list1 = new ArrayList<BankLoginCredentialInfoTO>( list.size() );
        for ( BankLoginCredentialInfo bankLoginCredentialInfo : list ) {
            list1.add( bankLoginCredentialInfoToBankLoginCredentialInfoTO( bankLoginCredentialInfo ) );
        }

        return list1;
    }

    protected BankLoginSettingsTO bankLoginSettingsToBankLoginSettingsTO(BankLoginSettings bankLoginSettings) {
        if ( bankLoginSettings == null ) {
            return null;
        }

        BankLoginSettingsTO bankLoginSettingsTO = new BankLoginSettingsTO();

        bankLoginSettingsTO.setIcon( bankLoginSettings.getIcon() );
        bankLoginSettingsTO.setCredentials( bankLoginCredentialInfoListToBankLoginCredentialInfoTOList( bankLoginSettings.getCredentials() ) );
        bankLoginSettingsTO.setAuth_type( bankLoginSettings.getAuth_type() );
        bankLoginSettingsTO.setAdvice( bankLoginSettings.getAdvice() );

        return bankLoginSettingsTO;
    }

    protected BankApiTO bankApiToBankApiTO(BankApi bankApi) {
        if ( bankApi == null ) {
            return null;
        }

        BankApiTO bankApiTO;

        switch ( bankApi ) {
            case HBCI: bankApiTO = BankApiTO.HBCI;
            break;
            case FIGO: bankApiTO = BankApiTO.FIGO;
            break;
            case FINAPI: bankApiTO = BankApiTO.FINAPI;
            break;
            case XS2A: bankApiTO = BankApiTO.XS2A;
            break;
            case ING: bankApiTO = BankApiTO.ING;
            break;
            case FIGO_ALTERNATIVE: bankApiTO = BankApiTO.FIGO_ALTERNATIVE;
            break;
            default: throw new IllegalArgumentException( "Unexpected enum constant: " + bankApi );
        }

        return bankApiTO;
    }
}
