package de.adorsys.multibanking.web.mapper;

import de.adorsys.multibanking.domain.AuthenticationType;
import de.adorsys.multibanking.domain.BankEntity;
import de.adorsys.multibanking.domain.ChallengeData;
import de.adorsys.multibanking.domain.ConsentEntity;
import de.adorsys.multibanking.domain.Credentials;
import de.adorsys.multibanking.domain.Credentials.CredentialsBuilder;
import de.adorsys.multibanking.domain.ScaApproach;
import de.adorsys.multibanking.domain.ScaStatus;
import de.adorsys.multibanking.domain.TanTransportType;
import de.adorsys.multibanking.domain.request.SelectPsuAuthenticationMethodRequest;
import de.adorsys.multibanking.domain.request.TransactionAuthorisationRequest;
import de.adorsys.multibanking.domain.request.UpdatePsuAuthenticationRequest;
import de.adorsys.multibanking.domain.response.UpdateAuthResponse;
import de.adorsys.multibanking.web.model.AuthenticationTypeTO;
import de.adorsys.multibanking.web.model.ChallengeDataTO;
import de.adorsys.multibanking.web.model.ScaApproachTO;
import de.adorsys.multibanking.web.model.ScaStatusTO;
import de.adorsys.multibanking.web.model.SelectPsuAuthenticationMethodRequestTO;
import de.adorsys.multibanking.web.model.TanTransportTypeTO;
import de.adorsys.multibanking.web.model.TransactionAuthorisationRequestTO;
import de.adorsys.multibanking.web.model.UpdateAuthResponseTO;
import de.adorsys.multibanking.web.model.UpdatePsuAuthenticationRequestTO;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.processing.Generated;
import org.springframework.stereotype.Component;

@Generated(
    value = "org.mapstruct.ap.MappingProcessor",
    date = "2021-07-12T12:49:42+0000",
    comments = "version: 1.4.1.Final, compiler: javac, environment: Java 11.0.11 (Azul Systems, Inc.)"
)
@Component
public class ConsentAuthorisationMapperImpl implements ConsentAuthorisationMapper {

    @Override
    public UpdatePsuAuthenticationRequest toUpdatePsuAuthenticationRequest(UpdatePsuAuthenticationRequestTO updatePsuAuthenticationRequest, ConsentEntity consentEntity, BankEntity bank) {
        if ( updatePsuAuthenticationRequest == null && consentEntity == null && bank == null ) {
            return null;
        }

        UpdatePsuAuthenticationRequest updatePsuAuthenticationRequest1 = new UpdatePsuAuthenticationRequest();

        if ( updatePsuAuthenticationRequest != null ) {
            updatePsuAuthenticationRequest1.setCredentials( updatePsuAuthenticationRequestTOToCredentials( updatePsuAuthenticationRequest ) );
        }
        if ( consentEntity != null ) {
            updatePsuAuthenticationRequest1.setConsentId( consentEntity.getId() );
            updatePsuAuthenticationRequest1.setAuthorisationId( consentEntity.getAuthorisationId() );
            updatePsuAuthenticationRequest1.setPsuAccountIban( consentEntity.getPsuAccountIban() );
            updatePsuAuthenticationRequest1.setBankApiConsentData( consentEntity.getBankApiConsentData() );
        }
        if ( bank != null ) {
            updatePsuAuthenticationRequest1.setBank( bank );
        }

        return updatePsuAuthenticationRequest1;
    }

    @Override
    public UpdateAuthResponseTO toUpdateAuthResponseTO(UpdateAuthResponse updateAuthResponse) {
        if ( updateAuthResponse == null ) {
            return null;
        }

        UpdateAuthResponseTO updateAuthResponseTO = new UpdateAuthResponseTO();

        updateAuthResponseTO.setScaMethods( tanTransportTypeListToTanTransportTypeTOList( updateAuthResponse.getScaMethods() ) );
        updateAuthResponseTO.setScaStatus( scaStatusToScaStatusTO( updateAuthResponse.getScaStatus() ) );
        updateAuthResponseTO.setChallenge( challengeDataToChallengeDataTO( updateAuthResponse.getChallenge() ) );
        updateAuthResponseTO.setPsuMessage( updateAuthResponse.getPsuMessage() );
        updateAuthResponseTO.setScaApproach( scaApproachToScaApproachTO( updateAuthResponse.getScaApproach() ) );

        return updateAuthResponseTO;
    }

    @Override
    public SelectPsuAuthenticationMethodRequest toSelectPsuAuthenticationMethodRequest(SelectPsuAuthenticationMethodRequestTO selectPsuAuthenticationMethodRequest, ConsentEntity consentEntity) {
        if ( selectPsuAuthenticationMethodRequest == null && consentEntity == null ) {
            return null;
        }

        SelectPsuAuthenticationMethodRequest selectPsuAuthenticationMethodRequest1 = new SelectPsuAuthenticationMethodRequest();

        if ( selectPsuAuthenticationMethodRequest != null ) {
            selectPsuAuthenticationMethodRequest1.setAuthenticationMethodId( selectPsuAuthenticationMethodRequest.getAuthenticationMethodId() );
            selectPsuAuthenticationMethodRequest1.setTanMediaName( selectPsuAuthenticationMethodRequest.getTanMediaName() );
        }
        if ( consentEntity != null ) {
            selectPsuAuthenticationMethodRequest1.setConsentId( consentEntity.getId() );
            selectPsuAuthenticationMethodRequest1.setBankApiConsentData( consentEntity.getBankApiConsentData() );
            selectPsuAuthenticationMethodRequest1.setAuthorisationId( consentEntity.getAuthorisationId() );
            selectPsuAuthenticationMethodRequest1.setPsuAccountIban( consentEntity.getPsuAccountIban() );
        }

        return selectPsuAuthenticationMethodRequest1;
    }

    @Override
    public TransactionAuthorisationRequest toTransactionAuthorisationRequest(TransactionAuthorisationRequestTO transactionAuthorisationRequest, ConsentEntity consentEntity) {
        if ( transactionAuthorisationRequest == null && consentEntity == null ) {
            return null;
        }

        TransactionAuthorisationRequest transactionAuthorisationRequest1 = new TransactionAuthorisationRequest();

        if ( transactionAuthorisationRequest != null ) {
            transactionAuthorisationRequest1.setScaAuthenticationData( transactionAuthorisationRequest.getScaAuthenticationData() );
        }
        if ( consentEntity != null ) {
            transactionAuthorisationRequest1.setConsentId( consentEntity.getId() );
            transactionAuthorisationRequest1.setBankApiConsentData( consentEntity.getBankApiConsentData() );
            transactionAuthorisationRequest1.setAuthorisationId( consentEntity.getAuthorisationId() );
            transactionAuthorisationRequest1.setPsuAccountIban( consentEntity.getPsuAccountIban() );
        }

        return transactionAuthorisationRequest1;
    }

    protected Credentials updatePsuAuthenticationRequestTOToCredentials(UpdatePsuAuthenticationRequestTO updatePsuAuthenticationRequestTO) {
        if ( updatePsuAuthenticationRequestTO == null ) {
            return null;
        }

        CredentialsBuilder credentials = Credentials.builder();

        credentials.customerId( updatePsuAuthenticationRequestTO.getPsuId() );
        credentials.userId( updatePsuAuthenticationRequestTO.getPsuCorporateId() );
        credentials.pin( updatePsuAuthenticationRequestTO.getPassword() );

        return credentials.build();
    }

    protected AuthenticationTypeTO authenticationTypeToAuthenticationTypeTO(AuthenticationType authenticationType) {
        if ( authenticationType == null ) {
            return null;
        }

        AuthenticationTypeTO authenticationTypeTO;

        switch ( authenticationType ) {
            case SMS_OTP: authenticationTypeTO = AuthenticationTypeTO.SMS_OTP;
            break;
            case CHIP_OTP: authenticationTypeTO = AuthenticationTypeTO.CHIP_OTP;
            break;
            case PHOTO_OTP: authenticationTypeTO = AuthenticationTypeTO.PHOTO_OTP;
            break;
            case PUSH_OTP: authenticationTypeTO = AuthenticationTypeTO.PUSH_OTP;
            break;
            case EMAIL: authenticationTypeTO = AuthenticationTypeTO.EMAIL;
            break;
            case APP_OTP: authenticationTypeTO = AuthenticationTypeTO.APP_OTP;
            break;
            default: throw new IllegalArgumentException( "Unexpected enum constant: " + authenticationType );
        }

        return authenticationTypeTO;
    }

    protected TanTransportTypeTO tanTransportTypeToTanTransportTypeTO(TanTransportType tanTransportType) {
        if ( tanTransportType == null ) {
            return null;
        }

        TanTransportTypeTO tanTransportTypeTO = new TanTransportTypeTO();

        tanTransportTypeTO.setId( tanTransportType.getId() );
        tanTransportTypeTO.setName( tanTransportType.getName() );
        tanTransportTypeTO.setMedium( tanTransportType.getMedium() );
        tanTransportTypeTO.setInputInfo( tanTransportType.getInputInfo() );
        tanTransportTypeTO.setType( authenticationTypeToAuthenticationTypeTO( tanTransportType.getType() ) );

        return tanTransportTypeTO;
    }

    protected List<TanTransportTypeTO> tanTransportTypeListToTanTransportTypeTOList(List<TanTransportType> list) {
        if ( list == null ) {
            return null;
        }

        List<TanTransportTypeTO> list1 = new ArrayList<TanTransportTypeTO>( list.size() );
        for ( TanTransportType tanTransportType : list ) {
            list1.add( tanTransportTypeToTanTransportTypeTO( tanTransportType ) );
        }

        return list1;
    }

    protected ScaStatusTO scaStatusToScaStatusTO(ScaStatus scaStatus) {
        if ( scaStatus == null ) {
            return null;
        }

        ScaStatusTO scaStatusTO;

        switch ( scaStatus ) {
            case RECEIVED: scaStatusTO = ScaStatusTO.RECEIVED;
            break;
            case STARTED: scaStatusTO = ScaStatusTO.STARTED;
            break;
            case PSUIDENTIFIED: scaStatusTO = ScaStatusTO.PSUIDENTIFIED;
            break;
            case PSUAUTHENTICATED: scaStatusTO = ScaStatusTO.PSUAUTHENTICATED;
            break;
            case SCAMETHODSELECTED: scaStatusTO = ScaStatusTO.SCAMETHODSELECTED;
            break;
            case FINALISED: scaStatusTO = ScaStatusTO.FINALISED;
            break;
            case FAILED: scaStatusTO = ScaStatusTO.FAILED;
            break;
            case EXEMPTED: scaStatusTO = ScaStatusTO.EXEMPTED;
            break;
            default: throw new IllegalArgumentException( "Unexpected enum constant: " + scaStatus );
        }

        return scaStatusTO;
    }

    protected ChallengeDataTO challengeDataToChallengeDataTO(ChallengeData challengeData) {
        if ( challengeData == null ) {
            return null;
        }

        ChallengeDataTO challengeDataTO = new ChallengeDataTO();

        challengeDataTO.setImage( challengeData.getImage() );
        List<String> list = challengeData.getData();
        if ( list != null ) {
            challengeDataTO.setData( new ArrayList<String>( list ) );
        }
        challengeDataTO.setImageLink( challengeData.getImageLink() );
        challengeDataTO.setOtpMaxLength( challengeData.getOtpMaxLength() );
        challengeDataTO.setOtpFormat( challengeData.getOtpFormat() );
        challengeDataTO.setAdditionalInformation( challengeData.getAdditionalInformation() );

        return challengeDataTO;
    }

    protected ScaApproachTO scaApproachToScaApproachTO(ScaApproach scaApproach) {
        if ( scaApproach == null ) {
            return null;
        }

        ScaApproachTO scaApproachTO;

        switch ( scaApproach ) {
            case EMBEDDED: scaApproachTO = ScaApproachTO.EMBEDDED;
            break;
            case REDIRECT: scaApproachTO = ScaApproachTO.REDIRECT;
            break;
            case DECOUPLED: scaApproachTO = ScaApproachTO.DECOUPLED;
            break;
            case OAUTH: scaApproachTO = ScaApproachTO.OAUTH;
            break;
            case OAUTH_PRESTEP: scaApproachTO = ScaApproachTO.OAUTH_PRESTEP;
            break;
            default: throw new IllegalArgumentException( "Unexpected enum constant: " + scaApproach );
        }

        return scaApproachTO;
    }
}
