package de.adorsys.multibanking.web.mapper;

import de.adorsys.multibanking.domain.BankAccessEntity;
import de.adorsys.multibanking.web.model.BankAccessTO;
import javax.annotation.processing.Generated;
import org.springframework.stereotype.Component;

@Generated(
    value = "org.mapstruct.ap.MappingProcessor",
    date = "2021-07-01T09:18:21+0000",
    comments = "version: 1.4.1.Final, compiler: javac, environment: Java 11.0.11 (Azul Systems, Inc.)"
)
@Component
public class BankAccessMapperImpl implements BankAccessMapper {

    @Override
    public BankAccessTO toBankAccessTO(BankAccessEntity bankAccessEntity) {
        if ( bankAccessEntity == null ) {
            return null;
        }

        BankAccessTO bankAccessTO = new BankAccessTO();

        bankAccessTO.setId( bankAccessEntity.getId() );
        bankAccessTO.setConsentId( bankAccessEntity.getConsentId() );
        bankAccessTO.setIban( bankAccessEntity.getIban() );
        bankAccessTO.setBankName( bankAccessEntity.getBankName() );
        bankAccessTO.setStoreBookings( bankAccessEntity.isStoreBookings() );
        bankAccessTO.setCategorizeBookings( bankAccessEntity.isCategorizeBookings() );
        bankAccessTO.setStoreAnalytics( bankAccessEntity.isStoreAnalytics() );
        bankAccessTO.setStoreAnonymizedBookings( bankAccessEntity.isStoreAnonymizedBookings() );
        bankAccessTO.setProvideDataForMachineLearning( bankAccessEntity.isProvideDataForMachineLearning() );

        return bankAccessTO;
    }

    @Override
    public BankAccessEntity toBankAccessEntity(BankAccessTO bankAccessTO, String userId, boolean temporary, String iban) {
        if ( bankAccessTO == null && userId == null && iban == null ) {
            return null;
        }

        BankAccessEntity bankAccessEntity = new BankAccessEntity();

        if ( bankAccessTO != null ) {
            bankAccessEntity.setConsentId( bankAccessTO.getConsentId() );
            bankAccessEntity.setBankName( bankAccessTO.getBankName() );
            bankAccessEntity.setId( bankAccessTO.getId() );
            bankAccessEntity.setStoreBookings( bankAccessTO.isStoreBookings() );
            bankAccessEntity.setCategorizeBookings( bankAccessTO.isCategorizeBookings() );
            bankAccessEntity.setStoreAnalytics( bankAccessTO.isStoreAnalytics() );
            bankAccessEntity.setStoreAnonymizedBookings( bankAccessTO.isStoreAnonymizedBookings() );
            bankAccessEntity.setProvideDataForMachineLearning( bankAccessTO.isProvideDataForMachineLearning() );
        }
        if ( userId != null ) {
            bankAccessEntity.setUserId( userId );
        }
        if ( iban != null ) {
            bankAccessEntity.setIban( iban );
        }
        bankAccessEntity.setTemporary( temporary );
        bankAccessEntity.setBankCode( iban != null ? org.iban4j.Iban.valueOf(iban).getBankCode() : null );

        return bankAccessEntity;
    }
}
