package de.adorsys.multibanking.web.mapper;

import de.adorsys.multibanking.domain.AccountAnalyticsEntity;
import de.adorsys.multibanking.domain.BookingGroup;
import de.adorsys.multibanking.domain.BookingGroup.Type;
import de.adorsys.multibanking.domain.BookingPeriod;
import de.adorsys.multibanking.domain.Contract;
import de.adorsys.multibanking.domain.ExecutedBooking;
import de.adorsys.multibanking.domain.Frequency;
import de.adorsys.multibanking.web.model.AnalyticsTO;
import de.adorsys.multibanking.web.model.BookingGroupTO;
import de.adorsys.multibanking.web.model.BookingPeriodTO;
import de.adorsys.multibanking.web.model.ContractTO;
import de.adorsys.multibanking.web.model.CycleTO;
import de.adorsys.multibanking.web.model.ExecutedBookingTO;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.processing.Generated;
import org.springframework.stereotype.Component;

@Generated(
    value = "org.mapstruct.ap.MappingProcessor",
    date = "2021-07-01T09:18:21+0000",
    comments = "version: 1.4.1.Final, compiler: javac, environment: Java 11.0.11 (Azul Systems, Inc.)"
)
@Component
public class AnalyticsMapperImpl implements AnalyticsMapper {

    @Override
    public AnalyticsTO toAnalyticsTO(AccountAnalyticsEntity analyticsEntity) {
        if ( analyticsEntity == null ) {
            return null;
        }

        AnalyticsTO analyticsTO = new AnalyticsTO();

        analyticsTO.setAnalyticsDate( analyticsEntity.getAnalyticsDate() );
        analyticsTO.setBookingGroups( bookingGroupListToBookingGroupTOList( analyticsEntity.getBookingGroups() ) );

        return analyticsTO;
    }

    @Override
    public ContractTO toContractTO(Contract contract) {
        if ( contract == null ) {
            return null;
        }

        ContractTO contractTO = new ContractTO();

        contractTO.setLogo( contract.getLogo() );
        contractTO.setHomepage( contract.getHomepage() );
        contractTO.setHotline( contract.getHotline() );
        contractTO.setEmail( contract.getEmail() );
        contractTO.setMandateReference( contract.getMandateReference() );
        contractTO.setInterval( frequencyToCycleTO( contract.getInterval() ) );
        contractTO.setCancelled( contract.isCancelled() );
        contractTO.setAmount( contract.getAmount() );
        contractTO.setMainCategory( contract.getMainCategory() );
        contractTO.setSubCategory( contract.getSubCategory() );
        contractTO.setSpecification( contract.getSpecification() );
        contractTO.setProvider( contract.getProvider() );

        return contractTO;
    }

    protected de.adorsys.multibanking.web.model.BookingGroupTO.Type typeToType(Type type) {
        if ( type == null ) {
            return null;
        }

        de.adorsys.multibanking.web.model.BookingGroupTO.Type type1;

        switch ( type ) {
            case STANDING_ORDER: type1 = de.adorsys.multibanking.web.model.BookingGroupTO.Type.STANDING_ORDER;
            break;
            case RECURRENT_INCOME: type1 = de.adorsys.multibanking.web.model.BookingGroupTO.Type.RECURRENT_INCOME;
            break;
            case RECURRENT_SEPA: type1 = de.adorsys.multibanking.web.model.BookingGroupTO.Type.RECURRENT_SEPA;
            break;
            case RECURRENT_NONSEPA: type1 = de.adorsys.multibanking.web.model.BookingGroupTO.Type.RECURRENT_NONSEPA;
            break;
            case CUSTOM: type1 = de.adorsys.multibanking.web.model.BookingGroupTO.Type.CUSTOM;
            break;
            case OTHER_INCOME: type1 = de.adorsys.multibanking.web.model.BookingGroupTO.Type.OTHER_INCOME;
            break;
            case OTHER_EXPENSES: type1 = de.adorsys.multibanking.web.model.BookingGroupTO.Type.OTHER_EXPENSES;
            break;
            default: throw new IllegalArgumentException( "Unexpected enum constant: " + type );
        }

        return type1;
    }

    protected ExecutedBookingTO executedBookingToExecutedBookingTO(ExecutedBooking executedBooking) {
        if ( executedBooking == null ) {
            return null;
        }

        ExecutedBookingTO executedBookingTO = new ExecutedBookingTO();

        executedBookingTO.setBookingId( executedBooking.getBookingId() );
        executedBookingTO.setExecutionDate( executedBooking.getExecutionDate() );
        executedBookingTO.setExecuted( executedBooking.isExecuted() );

        return executedBookingTO;
    }

    protected List<ExecutedBookingTO> executedBookingListToExecutedBookingTOList(List<ExecutedBooking> list) {
        if ( list == null ) {
            return null;
        }

        List<ExecutedBookingTO> list1 = new ArrayList<ExecutedBookingTO>( list.size() );
        for ( ExecutedBooking executedBooking : list ) {
            list1.add( executedBookingToExecutedBookingTO( executedBooking ) );
        }

        return list1;
    }

    protected BookingPeriodTO bookingPeriodToBookingPeriodTO(BookingPeriod bookingPeriod) {
        if ( bookingPeriod == null ) {
            return null;
        }

        BookingPeriodTO bookingPeriodTO = new BookingPeriodTO();

        bookingPeriodTO.setStart( bookingPeriod.getStart() );
        bookingPeriodTO.setEnd( bookingPeriod.getEnd() );
        bookingPeriodTO.setAmount( bookingPeriod.getAmount() );
        bookingPeriodTO.setBookings( executedBookingListToExecutedBookingTOList( bookingPeriod.getBookings() ) );

        return bookingPeriodTO;
    }

    protected List<BookingPeriodTO> bookingPeriodListToBookingPeriodTOList(List<BookingPeriod> list) {
        if ( list == null ) {
            return null;
        }

        List<BookingPeriodTO> list1 = new ArrayList<BookingPeriodTO>( list.size() );
        for ( BookingPeriod bookingPeriod : list ) {
            list1.add( bookingPeriodToBookingPeriodTO( bookingPeriod ) );
        }

        return list1;
    }

    protected BookingGroupTO bookingGroupToBookingGroupTO(BookingGroup bookingGroup) {
        if ( bookingGroup == null ) {
            return null;
        }

        BookingGroupTO bookingGroupTO = new BookingGroupTO();

        bookingGroupTO.setType( typeToType( bookingGroup.getType() ) );
        bookingGroupTO.setName( bookingGroup.getName() );
        bookingGroupTO.setSalaryWage( bookingGroup.isSalaryWage() );
        bookingGroupTO.setMainCategory( bookingGroup.getMainCategory() );
        bookingGroupTO.setSubCategory( bookingGroup.getSubCategory() );
        bookingGroupTO.setSpecification( bookingGroup.getSpecification() );
        bookingGroupTO.setOtherAccount( bookingGroup.getOtherAccount() );
        bookingGroupTO.setAmount( bookingGroup.getAmount() );
        bookingGroupTO.setBookingPeriods( bookingPeriodListToBookingPeriodTOList( bookingGroup.getBookingPeriods() ) );
        bookingGroupTO.setContract( toContractTO( bookingGroup.getContract() ) );

        return bookingGroupTO;
    }

    protected List<BookingGroupTO> bookingGroupListToBookingGroupTOList(List<BookingGroup> list) {
        if ( list == null ) {
            return null;
        }

        List<BookingGroupTO> list1 = new ArrayList<BookingGroupTO>( list.size() );
        for ( BookingGroup bookingGroup : list ) {
            list1.add( bookingGroupToBookingGroupTO( bookingGroup ) );
        }

        return list1;
    }

    protected CycleTO frequencyToCycleTO(Frequency frequency) {
        if ( frequency == null ) {
            return null;
        }

        CycleTO cycleTO;

        switch ( frequency ) {
            case WEEKLY: cycleTO = CycleTO.WEEKLY;
            break;
            case TWO_WEEKLY: cycleTO = CycleTO.TWO_WEEKLY;
            break;
            case MONTHLY: cycleTO = CycleTO.MONTHLY;
            break;
            case TWO_MONTHLY: cycleTO = CycleTO.TWO_MONTHLY;
            break;
            case QUARTERLY: cycleTO = CycleTO.QUARTERLY;
            break;
            case HALF_YEARLY: cycleTO = CycleTO.HALF_YEARLY;
            break;
            case YEARLY: cycleTO = CycleTO.YEARLY;
            break;
            case INVALID: cycleTO = CycleTO.INVALID;
            break;
            default: throw new IllegalArgumentException( "Unexpected enum constant: " + frequency );
        }

        return cycleTO;
    }
}
