/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.config;

import com.mongodb.ConnectionString;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientOptions;
import com.mongodb.MongoClientSettings;
import com.mongodb.MongoCredential;
import com.mongodb.ReadPreference;
import com.mongodb.ServerAddress;
import com.mongodb.WriteConcern;
import com.mongodb.client.MongoClients;
import de.adorsys.smartanalytics.config.EnableSmartanalyticsMongoPersistence;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import org.springframework.context.annotation.PropertySource;
import org.springframework.core.env.Environment;
import org.springframework.data.mongodb.MongoDbFactory;
import org.springframework.data.mongodb.config.AbstractMongoClientConfiguration;
import org.springframework.data.mongodb.core.SimpleMongoClientDbFactory;
import org.springframework.data.mongodb.core.convert.MongoConverter;
import org.springframework.data.mongodb.gridfs.GridFsTemplate;
import org.springframework.data.mongodb.repository.config.EnableMongoRepositories;
import org.springframework.lang.NonNull;

@Profile(value={"mongo"})
@Configuration
@EnableMongoRepositories(basePackages={"de.adorsys.multibanking.mongo.repository"})
@EnableSmartanalyticsMongoPersistence
@PropertySource(value={"${mongo.properties.url}"}, ignoreResourceNotFound=true)
public class MongoConfig
extends AbstractMongoClientConfiguration {
    private final Environment env;

    @NonNull
    protected String getDatabaseName() {
        return Optional.ofNullable(this.env.getProperty("mongo.databaseName")).orElseThrow(() -> new IllegalStateException("missing env property mongo.databaseName"));
    }

    @Bean
    public GridFsTemplate gridFsTemplate() throws Exception {
        return new GridFsTemplate(this.mongoDbFactory(), (MongoConverter)this.mappingMongoConverter());
    }

    private MongoCredential createMongoCredential() {
        String userName = Optional.ofNullable(this.env.getProperty("mongo.userName")).orElseThrow(() -> new IllegalStateException("missing env property mongo.userName"));
        String databaseName = Optional.ofNullable(this.env.getProperty("mongo.databaseName")).orElseThrow(() -> new IllegalStateException("missing env property mongo.databaseName"));
        String password = Optional.ofNullable(this.env.getProperty("mongo.password")).orElseThrow(() -> new IllegalStateException("missing env property mongo.password"));
        return MongoCredential.createCredential((String)userName, (String)databaseName, (char[])password.toCharArray());
    }

    private ConnectionString getConnectionString() {
        return Optional.ofNullable(this.env.getProperty("mongo.server")).map(server -> server.startsWith("mongodb://") ? server : "mongodb://" + server).map(ConnectionString::new).orElseThrow(() -> new IllegalStateException("missing env property mongo.server"));
    }

    @Bean
    @NonNull
    public com.mongodb.client.MongoClient mongoClient() {
        MongoClientSettings.Builder mongoClientSettingsBuilder = MongoClientSettings.builder().applyConnectionString(this.getConnectionString()).writeConcern(WriteConcern.JOURNALED).readPreference(ReadPreference.secondaryPreferred());
        if (StringUtils.isEmpty((CharSequence)this.env.getProperty("mongo.userName"))) {
            return MongoClients.create((MongoClientSettings)mongoClientSettingsBuilder.build());
        }
        return MongoClients.create((MongoClientSettings)mongoClientSettingsBuilder.credential(this.createMongoCredential()).build());
    }

    @Deprecated
    @Bean
    public MongoClient mongoClientOld() {
        MongoClientOptions mongoClientOptions = new MongoClientOptions.Builder().connectionsPerHost(50).writeConcern(WriteConcern.JOURNALED).readPreference(ReadPreference.secondaryPreferred()).build();
        ServerAddress serverAddress = Optional.ofNullable(this.env.getProperty("mongo.server")).map(server -> server.replace("mongodb://", "").split(":")).map(serverParts -> new ServerAddress(serverParts[0], 1 < ((String[])serverParts).length ? Integer.parseInt(serverParts[1]) : ServerAddress.defaultPort())).orElseThrow(() -> new IllegalStateException("missing env property mongo.server"));
        if (StringUtils.isEmpty((CharSequence)this.env.getProperty("mongo.userName"))) {
            return new MongoClient(serverAddress, mongoClientOptions);
        }
        MongoCredential mongoCredential = this.createMongoCredential();
        return new MongoClient(serverAddress, mongoCredential, mongoClientOptions);
    }

    @NonNull
    public MongoDbFactory mongoDbFactory() {
        return (MongoDbFactory)Optional.ofNullable(this.env.getProperty("mongo.databaseName")).map(databaseName -> new SimpleMongoClientDbFactory(this.mongoClient(), databaseName)).orElseThrow(() -> new IllegalStateException("missing env property mongo.databaseName"));
    }

    public MongoConfig(Environment env) {
        this.env = env;
    }
}

