/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.config;

import de.adorsys.multibanking.bg.BankingGatewayAdapter;
import de.adorsys.multibanking.domain.BankApi;
import de.adorsys.multibanking.figo.FigoBanking;
import de.adorsys.multibanking.finapi.FinapiBanking;
import de.adorsys.multibanking.hbci.HbciBanking;
import de.adorsys.multibanking.ing.IngAdapter;
import javax.annotation.PostConstruct;
import org.kapott.hbci.manager.HBCIProduct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.StringUtils;

@Configuration
public class AdapterConfig {
    private static final Logger log = LoggerFactory.getLogger(AdapterConfig.class);
    @Value(value="${bankinggateway.b2c.url}")
    private String bankingGatewayBaseUrl;
    @Value(value="${bankinggateway.adapter.url}")
    private String bankingAdapterBaseUrl;
    @Value(value="${ing.url}")
    private String ingBaseUrl;
    @Value(value="${pkcs12.keyStore.url}")
    private String keyStoreUrl;
    @Value(value="${pkcs12.keyStore.password}")
    private String keyStorePassword;
    @Value(value="${ing.qwac.alias}")
    private String ingQwacAlias;
    @Value(value="${ing.qseal.alias}")
    private String ingQsealAlias;
    @Value(value="${fints.id:}")
    private String fintsProduct;
    @Value(value="${fints.version:}")
    private String fintsProductVersion;
    @Value(value="${fints.sysIdCacheExpirationMs:0}")
    private long fintsSysIdCacheExpirationMs;
    @Value(value="${fints.sysUpdCacheExpirationMs:0}")
    private long fintsUpdCacheExpirationMs;
    private IngAdapter ingAdapter;
    private BankingGatewayAdapter bankingGatewayAdapter;
    private HbciBanking hbci4JavaBanking;
    private FigoBanking figoBanking = new FigoBanking(BankApi.FIGO);
    private FigoBanking figoBankingAlternative = new FigoBanking(BankApi.FIGO_ALTERNATIVE);
    private FinapiBanking finapiBanking = new FinapiBanking();

    @PostConstruct
    public void postConstruct() {
        this.ingAdapter = new IngAdapter(this.ingBaseUrl, this.keyStoreUrl, this.keyStorePassword, this.ingQwacAlias, this.ingQsealAlias);
        this.bankingGatewayAdapter = new BankingGatewayAdapter(this.bankingGatewayBaseUrl, this.bankingAdapterBaseUrl);
        if (StringUtils.isEmpty((Object)this.fintsProduct)) {
            log.warn("missing FinTS product configuration");
            this.hbci4JavaBanking = new HbciBanking(null, this.fintsSysIdCacheExpirationMs, this.fintsUpdCacheExpirationMs);
        } else {
            this.hbci4JavaBanking = new HbciBanking(new HBCIProduct(this.fintsProduct, this.fintsProductVersion), this.fintsSysIdCacheExpirationMs, this.fintsUpdCacheExpirationMs);
        }
    }

    @Bean
    public IngAdapter ingAdapter() {
        return this.ingAdapter;
    }

    @Bean
    public BankingGatewayAdapter bankingGatewayAdapter() {
        return this.bankingGatewayAdapter;
    }

    @Bean
    public HbciBanking hbci4JavaBanking() {
        return this.hbci4JavaBanking;
    }

    @Bean
    public FigoBanking figoBanking() {
        return this.figoBanking;
    }

    @Bean
    public FigoBanking figoBankingAlternative() {
        return this.figoBankingAlternative;
    }

    @Bean
    public FinapiBanking finapiBanking() {
        return this.finapiBanking;
    }
}

