/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.web;

import de.adorsys.multibanking.domain.BankEntity;
import de.adorsys.multibanking.service.BankService;
import de.adorsys.multibanking.web.UserResource;
import de.adorsys.multibanking.web.mapper.BankMapper;
import de.adorsys.multibanking.web.model.BankTO;
import de.adorsys.smartanalytics.exception.FileUploadException;
import io.micrometer.core.annotation.Timed;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.Resource;
import org.springframework.hateoas.Resources;
import org.springframework.hateoas.mvc.ControllerLinkBuilder;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@Timed(value="bank")
@Tag(name="Bank")
@UserResource
@RestController
@RequestMapping(path={"api/v1/bank", "api/v1/banks"})
public class BankController {
    private final BankMapper bankMapper;
    private final BankService bankService;

    @Operation(description="get bank by bank code")
    @GetMapping(value={"/{bankCode}"})
    public Resource<BankTO> getBank(@PathVariable String bankCode) {
        return this.mapToResource(this.bankService.findBank(bankCode));
    }

    @Operation(description="find bank")
    @GetMapping
    public Resources<Resource<BankTO>> searchBank(@RequestParam String query) {
        return new Resources((Iterable)this.mapToResources(this.bankService.search(query)), new Link[0]);
    }

    @Operation(description="Upload banks configuration file", security={@SecurityRequirement(name="multibanking_auth", scopes={"openid"})})
    @PostMapping(value={"/upload"})
    public HttpEntity<Void> uploadBanks(@RequestParam MultipartFile banksFile) {
        if (!banksFile.isEmpty()) {
            this.bankService.importBanks(banksFile);
            return new ResponseEntity(HttpStatus.CREATED);
        }
        throw new FileUploadException("File is empty");
    }

    private List<Resource<BankTO>> mapToResources(List<BankEntity> entities) {
        return entities.stream().map(arg_0 -> this.mapToResource(arg_0)).collect(Collectors.toList());
    }

    private Resource<BankTO> mapToResource(BankEntity entity) {
        return new Resource((Object)this.bankMapper.toBankTO(entity), new Link[]{ControllerLinkBuilder.linkTo((Object)((BankController)ControllerLinkBuilder.methodOn(BankController.class, (Object[])new Object[0])).getBank(entity.getBankCode())).withSelfRel()});
    }

    public BankController(BankMapper bankMapper, BankService bankService) {
        this.bankMapper = bankMapper;
        this.bankService = bankService;
    }
}

