/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.web;

import de.adorsys.multibanking.domain.BankAccessEntity;
import de.adorsys.multibanking.domain.BankAccount;
import de.adorsys.multibanking.domain.BankAccountEntity;
import de.adorsys.multibanking.domain.ScaStatus;
import de.adorsys.multibanking.exception.ResourceNotFoundException;
import de.adorsys.multibanking.exception.SyncInProgressException;
import de.adorsys.multibanking.exception.TransactionAuthorisationRequiredException;
import de.adorsys.multibanking.exception.domain.Messages;
import de.adorsys.multibanking.pers.spi.repository.BankAccessRepositoryIf;
import de.adorsys.multibanking.pers.spi.repository.BankAccountRepositoryIf;
import de.adorsys.multibanking.service.BankAccountService;
import de.adorsys.multibanking.service.BookingService;
import de.adorsys.multibanking.web.BankAccessController;
import de.adorsys.multibanking.web.BankAccountAnalyticsController;
import de.adorsys.multibanking.web.BookingController;
import de.adorsys.multibanking.web.ConsentAuthorisationController;
import de.adorsys.multibanking.web.UserResource;
import de.adorsys.multibanking.web.mapper.BankAccountMapper;
import de.adorsys.multibanking.web.mapper.ConsentAuthorisationMapper;
import de.adorsys.multibanking.web.model.BankAccountTO;
import io.micrometer.core.annotation.Timed;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.security.Principal;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.Resource;
import org.springframework.hateoas.Resources;
import org.springframework.hateoas.mvc.ControllerLinkBuilder;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Timed(value="bank-account")
@Tag(name="Bankaccount")
@UserResource
@RestController
@RequestMapping(path={"api/v1/bankaccesses/{accessId}/accounts"})
public class BankAccountController {
    private static final Logger log = LoggerFactory.getLogger(BankAccountController.class);
    private final BankAccountMapper bankAccountMapper;
    private final BankAccountService bankAccountService;
    private final BookingService bookingService;
    private final BankAccountRepositoryIf bankAccountRepository;
    private final BankAccessRepositoryIf bankAccessRepository;
    private final ConsentAuthorisationMapper consentAuthorisationMapper;
    private final Principal principal;

    @Operation(description="Read bank accounts", security={@SecurityRequirement(name="multibanking_auth", scopes={"openid"})})
    @ApiResponse(responseCode="400", description="Consent authorisation required", content={@Content(schema=@Schema(implementation=Messages.class))})
    @GetMapping
    public Resources<Resource<BankAccountTO>> getBankAccounts(@PathVariable String accessId) {
        List bankAccounts = this.bankAccountService.getBankAccounts(this.principal.getName(), accessId);
        return new Resources((Iterable)this.mapToResources(bankAccounts, accessId), new Link[0]);
    }

    @Operation(description="Read bank account", security={@SecurityRequirement(name="multibanking_auth", scopes={"openid"})})
    @GetMapping(value={"/{accountId}"})
    public Resource<BankAccountTO> getBankAccount(@PathVariable String accessId, @PathVariable(value="accountId") String accountId) {
        if (!this.bankAccessRepository.exists(accessId)) {
            throw new ResourceNotFoundException(BankAccessEntity.class, accessId);
        }
        BankAccountEntity bankAccountEntity = (BankAccountEntity)this.bankAccountRepository.findByUserIdAndId(this.principal.getName(), accountId).orElseThrow(() -> new ResourceNotFoundException(BankAccountEntity.class, accountId));
        return this.mapToResource(bankAccountEntity, accessId);
    }

    @Operation(description="Trigger account sync", security={@SecurityRequirement(name="multibanking_auth", scopes={"openid"})})
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Sync started", content={@Content(schema=@Schema(implementation=void.class))}), @ApiResponse(responseCode="202", description="Challenge response", content={@Content(schema=@Schema(ref="#/components/schemas/ResourceConsentAuthorisationResponse"))})})
    @PutMapping(value={"/{accountId}/sync"})
    public ResponseEntity syncBookings(@PathVariable String accessId, @PathVariable String accountId) {
        BankAccessEntity bankAccess = (BankAccessEntity)this.bankAccessRepository.findByUserIdAndId(this.principal.getName(), accessId).orElseThrow(() -> new ResourceNotFoundException(BankAccessEntity.class, accessId));
        BankAccountEntity bankAccount = (BankAccountEntity)this.bankAccountRepository.findByUserIdAndId(this.principal.getName(), accountId).orElseThrow(() -> new ResourceNotFoundException(BankAccountEntity.class, accountId));
        if (bankAccount.getSyncStatus() == BankAccount.SyncStatus.SYNC) {
            throw new SyncInProgressException(bankAccount.getId());
        }
        try {
            this.bookingService.syncBookings(ScaStatus.FINALISED, null, bankAccess, bankAccount, null);
            return new ResponseEntity(HttpStatus.NO_CONTENT);
        }
        catch (TransactionAuthorisationRequiredException e) {
            ArrayList<Link> links = new ArrayList<Link>();
            links.add(ControllerLinkBuilder.linkTo((Object)((ConsentAuthorisationController)ControllerLinkBuilder.methodOn(ConsentAuthorisationController.class, (Object[])new Object[0])).getConsentAuthorisationStatus(e.getConsentId(), e.getAuthorisationId())).withSelfRel());
            links.add(ControllerLinkBuilder.linkTo((Object)((ConsentAuthorisationController)ControllerLinkBuilder.methodOn(ConsentAuthorisationController.class, (Object[])new Object[0])).transactionAuthorisation(e.getConsentId(), e.getAuthorisationId(), null)).withRel("transactionAuthorisation"));
            return ResponseEntity.accepted().body((Object)new Resource((Object)this.consentAuthorisationMapper.toUpdateAuthResponseTO(e.getResponse()), links));
        }
    }

    private List<Resource<BankAccountTO>> mapToResources(List<BankAccountEntity> accountEntities, String accessId) {
        return accountEntities.stream().map(accountEntity -> this.mapToResource(accountEntity, accessId)).collect(Collectors.toList());
    }

    private Resource<BankAccountTO> mapToResource(BankAccountEntity accountEntity, String accessId) {
        return new Resource((Object)this.bankAccountMapper.toBankAccountTO(accountEntity), new Link[]{ControllerLinkBuilder.linkTo((Object)((BankAccountController)ControllerLinkBuilder.methodOn(BankAccountController.class, (Object[])new Object[0])).getBankAccount(accessId, accountEntity.getId())).withSelfRel(), ControllerLinkBuilder.linkTo((Object)((BankAccessController)ControllerLinkBuilder.methodOn(BankAccessController.class, (Object[])new Object[0])).getBankAccess(accessId)).withRel("bankAccess"), ControllerLinkBuilder.linkTo((Object)((BankAccountAnalyticsController)ControllerLinkBuilder.methodOn(BankAccountAnalyticsController.class, (Object[])new Object[0])).getAccountAnalytics(accessId, accountEntity.getId())).withRel("analytics"), ControllerLinkBuilder.linkTo((Object)((BankAccountController)ControllerLinkBuilder.methodOn(BankAccountController.class, (Object[])new Object[0])).syncBookings(accessId, accountEntity.getId())).withRel("sync"), ControllerLinkBuilder.linkTo((Object)((BookingController)ControllerLinkBuilder.methodOn(BookingController.class, (Object[])new Object[0])).getBookings(accessId, accountEntity.getId(), null, null, null, null)).withRel("bookings")});
    }

    public BankAccountController(BankAccountMapper bankAccountMapper, BankAccountService bankAccountService, BookingService bookingService, BankAccountRepositoryIf bankAccountRepository, BankAccessRepositoryIf bankAccessRepository, ConsentAuthorisationMapper consentAuthorisationMapper, Principal principal) {
        this.bankAccountMapper = bankAccountMapper;
        this.bankAccountService = bankAccountService;
        this.bookingService = bookingService;
        this.bankAccountRepository = bankAccountRepository;
        this.bankAccessRepository = bankAccessRepository;
        this.consentAuthorisationMapper = consentAuthorisationMapper;
        this.principal = principal;
    }
}

