/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.metrics;

import de.adorsys.multibanking.domain.BankApi;
import de.adorsys.multibanking.domain.exception.MultibankingException;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import org.springframework.boot.actuate.metrics.web.servlet.WebMvcTags;
import org.springframework.stereotype.Component;

@Component
public class MetricsCollector {
    private final MeterRegistry meterRegistry;

    public void count(String tag, String bankCode, BankApi bankApi) {
        this.count(tag, bankCode, bankApi, null);
    }

    public void count(String tag, String bankCode, BankApi bankApi, Throwable exception) {
        this.meterRegistry.counter(tag, (Iterable)Tags.of((Tag[])new Tag[]{Tag.of((String)"bank_code", (String)bankCode), Tag.of((String)"bank_api", (String)(bankApi == null ? "undefined" : bankApi.toString())), Tag.of((String)"outcome", (String)(exception == null ? "SUCCESS" : "ERROR")), this.getExceptionTag(exception)})).increment();
    }

    private Tag getExceptionTag(Throwable exception) {
        if (exception instanceof MultibankingException) {
            return Tag.of((String)"exception", (String)((MultibankingException)exception).getMultibankingError().toString());
        }
        return WebMvcTags.exception((Throwable)exception);
    }

    public MetricsCollector(MeterRegistry meterRegistry) {
        this.meterRegistry = meterRegistry;
    }
}

