/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.web.model;

import de.adorsys.multibanking.web.model.BalancesReportTO;
import de.adorsys.multibanking.web.model.BankAccountTO;
import io.swagger.v3.oas.annotations.media.Schema;
import java.time.LocalDateTime;
import javax.validation.constraints.NotNull;
import org.springframework.hateoas.core.Relation;

@Relation(collectionRelation="bankAccountList")
@Schema(name="BankAccount", description="The bank account object")
public class BankAccountTO {
    @NotNull
    @Schema(description="Account ID")
    private String id;
    @Schema(description="User ID")
    private String userId;
    @NotNull
    @Schema(description="Bank Access Id")
    private String bankAccessId;
    @Schema(description="Bank account balances")
    private BalancesReportTO balances;
    @Schema(description="Name of the account owner", example="EDEKA")
    private String owner;
    @Schema(description="ISO-2 country of this bank account", example="DE")
    private String country;
    @Schema(description="Bank code", example="29999999")
    private String blz;
    @Schema(description="Bank name", example="Mock Bank")
    private String bankName;
    @Schema(description="Account number", example="1234567890")
    private String accountNumber;
    @Schema(description="Type of this bank account", example="GIRO")
    private BankAccountTypeTO type;
    @Schema(description="Currency of this bank account", example="EURO")
    private String currency;
    @Schema(description="Name of this bank account")
    private String name;
    @Schema(description="Bank identification code", example="EDEKDEHHXXX")
    private String bic;
    @Schema(description="International bank account number", example="DE50200907003443582071", required=true)
    private String iban;
    @Schema(description="Synchronisation status", example="PENDING")
    private SyncStatusTO syncStatus;
    @Schema(description="Last Synchronisation date", example="2017-12-01")
    private LocalDateTime lastSync;

    public String getId() {
        return this.id;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getBankAccessId() {
        return this.bankAccessId;
    }

    public BalancesReportTO getBalances() {
        return this.balances;
    }

    public String getOwner() {
        return this.owner;
    }

    public String getCountry() {
        return this.country;
    }

    public String getBlz() {
        return this.blz;
    }

    public String getBankName() {
        return this.bankName;
    }

    public String getAccountNumber() {
        return this.accountNumber;
    }

    public BankAccountTypeTO getType() {
        return this.type;
    }

    public String getCurrency() {
        return this.currency;
    }

    public String getName() {
        return this.name;
    }

    public String getBic() {
        return this.bic;
    }

    public String getIban() {
        return this.iban;
    }

    public SyncStatusTO getSyncStatus() {
        return this.syncStatus;
    }

    public LocalDateTime getLastSync() {
        return this.lastSync;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public void setBankAccessId(String bankAccessId) {
        this.bankAccessId = bankAccessId;
    }

    public void setBalances(BalancesReportTO balances) {
        this.balances = balances;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public void setBlz(String blz) {
        this.blz = blz;
    }

    public void setBankName(String bankName) {
        this.bankName = bankName;
    }

    public void setAccountNumber(String accountNumber) {
        this.accountNumber = accountNumber;
    }

    public void setType(BankAccountTypeTO type) {
        this.type = type;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setBic(String bic) {
        this.bic = bic;
    }

    public void setIban(String iban) {
        this.iban = iban;
    }

    public void setSyncStatus(SyncStatusTO syncStatus) {
        this.syncStatus = syncStatus;
    }

    public void setLastSync(LocalDateTime lastSync) {
        this.lastSync = lastSync;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BankAccountTO)) {
            return false;
        }
        BankAccountTO other = (BankAccountTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$userId = this.getUserId();
        String other$userId = other.getUserId();
        if (this$userId == null ? other$userId != null : !this$userId.equals(other$userId)) {
            return false;
        }
        String this$bankAccessId = this.getBankAccessId();
        String other$bankAccessId = other.getBankAccessId();
        if (this$bankAccessId == null ? other$bankAccessId != null : !this$bankAccessId.equals(other$bankAccessId)) {
            return false;
        }
        BalancesReportTO this$balances = this.getBalances();
        BalancesReportTO other$balances = other.getBalances();
        if (this$balances == null ? other$balances != null : !this$balances.equals(other$balances)) {
            return false;
        }
        String this$owner = this.getOwner();
        String other$owner = other.getOwner();
        if (this$owner == null ? other$owner != null : !this$owner.equals(other$owner)) {
            return false;
        }
        String this$country = this.getCountry();
        String other$country = other.getCountry();
        if (this$country == null ? other$country != null : !this$country.equals(other$country)) {
            return false;
        }
        String this$blz = this.getBlz();
        String other$blz = other.getBlz();
        if (this$blz == null ? other$blz != null : !this$blz.equals(other$blz)) {
            return false;
        }
        String this$bankName = this.getBankName();
        String other$bankName = other.getBankName();
        if (this$bankName == null ? other$bankName != null : !this$bankName.equals(other$bankName)) {
            return false;
        }
        String this$accountNumber = this.getAccountNumber();
        String other$accountNumber = other.getAccountNumber();
        if (this$accountNumber == null ? other$accountNumber != null : !this$accountNumber.equals(other$accountNumber)) {
            return false;
        }
        BankAccountTypeTO this$type = this.getType();
        BankAccountTypeTO other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$currency = this.getCurrency();
        String other$currency = other.getCurrency();
        if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$bic = this.getBic();
        String other$bic = other.getBic();
        if (this$bic == null ? other$bic != null : !this$bic.equals(other$bic)) {
            return false;
        }
        String this$iban = this.getIban();
        String other$iban = other.getIban();
        if (this$iban == null ? other$iban != null : !this$iban.equals(other$iban)) {
            return false;
        }
        SyncStatusTO this$syncStatus = this.getSyncStatus();
        SyncStatusTO other$syncStatus = other.getSyncStatus();
        if (this$syncStatus == null ? other$syncStatus != null : !this$syncStatus.equals(other$syncStatus)) {
            return false;
        }
        LocalDateTime this$lastSync = this.getLastSync();
        LocalDateTime other$lastSync = other.getLastSync();
        return !(this$lastSync == null ? other$lastSync != null : !((Object)this$lastSync).equals(other$lastSync));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BankAccountTO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $userId = this.getUserId();
        result = result * 59 + ($userId == null ? 43 : $userId.hashCode());
        String $bankAccessId = this.getBankAccessId();
        result = result * 59 + ($bankAccessId == null ? 43 : $bankAccessId.hashCode());
        BalancesReportTO $balances = this.getBalances();
        result = result * 59 + ($balances == null ? 43 : $balances.hashCode());
        String $owner = this.getOwner();
        result = result * 59 + ($owner == null ? 43 : $owner.hashCode());
        String $country = this.getCountry();
        result = result * 59 + ($country == null ? 43 : $country.hashCode());
        String $blz = this.getBlz();
        result = result * 59 + ($blz == null ? 43 : $blz.hashCode());
        String $bankName = this.getBankName();
        result = result * 59 + ($bankName == null ? 43 : $bankName.hashCode());
        String $accountNumber = this.getAccountNumber();
        result = result * 59 + ($accountNumber == null ? 43 : $accountNumber.hashCode());
        BankAccountTypeTO $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $currency = this.getCurrency();
        result = result * 59 + ($currency == null ? 43 : $currency.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $bic = this.getBic();
        result = result * 59 + ($bic == null ? 43 : $bic.hashCode());
        String $iban = this.getIban();
        result = result * 59 + ($iban == null ? 43 : $iban.hashCode());
        SyncStatusTO $syncStatus = this.getSyncStatus();
        result = result * 59 + ($syncStatus == null ? 43 : $syncStatus.hashCode());
        LocalDateTime $lastSync = this.getLastSync();
        result = result * 59 + ($lastSync == null ? 43 : ((Object)$lastSync).hashCode());
        return result;
    }

    public String toString() {
        return "BankAccountTO(id=" + this.getId() + ", userId=" + this.getUserId() + ", bankAccessId=" + this.getBankAccessId() + ", balances=" + this.getBalances() + ", owner=" + this.getOwner() + ", country=" + this.getCountry() + ", blz=" + this.getBlz() + ", bankName=" + this.getBankName() + ", accountNumber=" + this.getAccountNumber() + ", type=" + this.getType() + ", currency=" + this.getCurrency() + ", name=" + this.getName() + ", bic=" + this.getBic() + ", iban=" + this.getIban() + ", syncStatus=" + this.getSyncStatus() + ", lastSync=" + this.getLastSync() + ")";
    }
}

