/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.web;

import de.adorsys.multibanking.domain.BankAccessEntity;
import de.adorsys.multibanking.domain.BankAccount;
import de.adorsys.multibanking.domain.BankAccountEntity;
import de.adorsys.multibanking.exception.ResourceNotFoundException;
import de.adorsys.multibanking.exception.SyncInProgressException;
import de.adorsys.multibanking.pers.spi.repository.BankAccessRepositoryIf;
import de.adorsys.multibanking.pers.spi.repository.BankAccountRepositoryIf;
import de.adorsys.multibanking.pers.spi.repository.ContractRepositoryIf;
import de.adorsys.multibanking.web.UserResource;
import de.adorsys.multibanking.web.mapper.ContractMapper;
import de.adorsys.multibanking.web.model.ContractTO;
import io.micrometer.core.annotation.Timed;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.security.Principal;
import java.util.List;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.Resources;
import org.springframework.hateoas.mvc.ControllerLinkBuilder;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Timed(value="contract")
@Tag(name="Contract")
@UserResource
@RestController
@RequestMapping(path={"api/v1/bankaccesses/{accessId}/accounts/{accountId}/contracts"})
public class ContractController {
    private final ContractMapper contractMapper;
    private final ContractRepositoryIf contractRepository;
    private final BankAccessRepositoryIf bankAccessRepository;
    private final BankAccountRepositoryIf bankAccountRepository;
    private final Principal principal;

    @Operation(description="Read account contracts", security={@SecurityRequirement(name="multibanking_auth", scopes={"openid"})})
    @GetMapping
    public Resources<ContractTO> getContracts(@PathVariable String accessId, @PathVariable String accountId) {
        if (!this.bankAccessRepository.exists(accessId)) {
            throw new ResourceNotFoundException(BankAccessEntity.class, accessId);
        }
        if (!this.bankAccountRepository.exists(accountId)) {
            throw new ResourceNotFoundException(BankAccountEntity.class, accountId);
        }
        if (this.bankAccountRepository.getSyncStatus(accountId) == BankAccount.SyncStatus.SYNC) {
            throw new SyncInProgressException(accountId);
        }
        List contractEntities = this.contractRepository.findByUserIdAndAccountId(this.principal.getName(), accountId);
        return new Resources((Iterable)this.contractMapper.toContractTOs(contractEntities), new Link[]{ControllerLinkBuilder.linkTo((Object)((ContractController)ControllerLinkBuilder.methodOn(ContractController.class, (Object[])new Object[0])).getContracts(accessId, accountId)).withSelfRel()});
    }

    public ContractController(ContractMapper contractMapper, ContractRepositoryIf contractRepository, BankAccessRepositoryIf bankAccessRepository, BankAccountRepositoryIf bankAccountRepository, Principal principal) {
        this.contractMapper = contractMapper;
        this.contractRepository = contractRepository;
        this.bankAccessRepository = bankAccessRepository;
        this.bankAccountRepository = bankAccountRepository;
        this.principal = principal;
    }
}

