/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.service.analytics;

import de.adorsys.multibanking.domain.BookingCategory;
import de.adorsys.multibanking.domain.BookingEntity;
import de.adorsys.multibanking.domain.BookingGroup;
import de.adorsys.multibanking.domain.Contract;
import de.adorsys.multibanking.domain.ContractEntity;
import de.adorsys.smartanalytics.api.AnalyticsResult;
import de.adorsys.smartanalytics.api.Booking;
import de.adorsys.smartanalytics.api.WrappedBooking;
import de.adorsys.smartanalytics.api.config.Group;
import java.util.Collection;
import java.util.List;
import org.mapstruct.AfterMapping;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.MappingTarget;
import org.mapstruct.Mappings;

@Mapper(componentModel="spring")
public abstract class SmartAnalyticsMapper {
    public void applyCategories(List<BookingEntity> bookingEntities, AnalyticsResult result) {
        result.getBookings().forEach(categorizedBooking -> bookingEntities.stream().filter(bookingEntity -> categorizedBooking.getBooking().getBookingId().equals(bookingEntity.getExternalId())).findFirst().ifPresent(bookingEntity -> {
            if (categorizedBooking.getMainCategory() != null) {
                bookingEntity.setBookingCategory(this.toBookingcategory(categorizedBooking));
            }
        }));
    }

    @Mappings(value={@Mapping(source="cycle", target="interval"), @Mapping(source="otherAccount", target="receiver"), @Mapping(source="ruleIds", target="rules"), @Mapping(target="cancelled", ignore=true), @Mapping(target="provider", ignore=true)})
    abstract BookingCategory toBookingcategory(WrappedBooking var1);

    abstract List<BookingGroup> mapBookingGroups(List<de.adorsys.smartanalytics.api.BookingGroup> var1);

    @Mappings(value={@Mapping(target="otherAccount", ignore=true), @Mapping(source="groupType", target="type"), @Mapping(source=".", target="contract")})
    abstract BookingGroup mapBookingGroup(de.adorsys.smartanalytics.api.BookingGroup var1);

    @AfterMapping
    public void mapBookingGroupAfterMapping(de.adorsys.smartanalytics.api.BookingGroup bookingsGroup, @MappingTarget BookingGroup.BookingGroupBuilder bookingGroup) {
        if (bookingsGroup.getGroupType() == Group.Type.CUSTOM || bookingsGroup.getGroupType() == Group.Type.OTHER_INCOME || bookingsGroup.getGroupType() == Group.Type.OTHER_EXPENSES) {
            bookingGroup.otherAccount("");
        } else {
            bookingGroup.otherAccount(bookingsGroup.getOtherAccount());
        }
    }

    @Mappings(value={@Mapping(source="mandatreference", target="mandateReference"), @Mapping(source="cycle", target="interval"), @Mapping(target="provider", ignore=true)})
    abstract Contract toContract(de.adorsys.smartanalytics.api.BookingGroup var1);

    @Mappings(value={@Mapping(source="bookingGroup.mandatreference", target="mandateReference"), @Mapping(source="bookingGroup.cycle", target="interval"), @Mapping(source="bookingGroup.otherAccount", target="provider"), @Mapping(target="id", ignore=true)})
    abstract ContractEntity toContractEntity(String var1, String var2, de.adorsys.smartanalytics.api.BookingGroup var3);

    abstract List<Booking> toSmartAnalyticsBookings(Collection<BookingEntity> var1);

    @Mappings(value={@Mapping(target="referenceName", ignore=true), @Mapping(source="externalId", target="bookingId"), @Mapping(source="usage", target="purpose"), @Mapping(source="valutaDate", target="executionDate"), @Mapping(source="otherAccount.iban", target="iban"), @Mapping(source="otherAccount.accountNumber", target="accountNumber"), @Mapping(source="otherAccount.blz", target="bankCode")})
    abstract Booking toSmartAnalyticsBooking(BookingEntity var1);

    @AfterMapping
    void toSmartAnalyticsBookingAfterMapping(BookingEntity bookingEntity, @MappingTarget Booking booking) {
        if (bookingEntity.getOtherAccount() != null) {
            if (bookingEntity.getOtherAccount().getOwner() != null) {
                booking.setReferenceName(bookingEntity.getOtherAccount().getOwner());
            } else {
                booking.setReferenceName(bookingEntity.getOtherAccount().getName());
            }
        }
    }
}

