/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.service.analytics;

import de.adorsys.multibanking.domain.AccountAnalyticsEntity;
import de.adorsys.multibanking.domain.BankAccountEntity;
import de.adorsys.multibanking.domain.BookingEntity;
import de.adorsys.multibanking.domain.Rule;
import de.adorsys.multibanking.domain.RuleEntity;
import de.adorsys.multibanking.pers.spi.repository.AnalyticsRepositoryIf;
import de.adorsys.multibanking.pers.spi.repository.BookingRuleRepositoryIf;
import de.adorsys.multibanking.pers.spi.repository.ContractRepositoryIf;
import de.adorsys.multibanking.pers.spi.repository.UserRepositoryIf;
import de.adorsys.multibanking.service.analytics.SmartAnalyticsIf;
import de.adorsys.multibanking.service.analytics.SmartAnalyticsMapper;
import de.adorsys.smartanalytics.api.AnalyticsResult;
import de.adorsys.smartanalytics.api.BookingGroup;
import de.adorsys.smartanalytics.api.Rule;
import java.security.Principal;
import java.time.LocalDateTime;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class AnalyticsService {
    private final UserRepositoryIf userRepository;
    private final BookingRuleRepositoryIf rulesRepository;
    private final AnalyticsRepositoryIf analyticsRepository;
    private final ContractRepositoryIf contractRepository;
    private final SmartAnalyticsIf smartAnalyticsService;
    private final SmartAnalyticsMapper smartAnalyticsMapper;
    private final Principal principal;

    private static String normalize(String s) {
        if (s == null) {
            return null;
        }
        return s.toLowerCase().replace("\u00fc", "ue").replace("\u00f6", "oe").replace("\u00e4", "ae").replace("\u00df", "ss").replaceAll("[^a-z ]+", " ");
    }

    @Transactional
    public void createCustomRule(RuleEntity ruleEntity) {
        ruleEntity.setUserId(this.principal.getName());
        ruleEntity.setRuleType("STOP");
        ruleEntity.setRuleId("custom-" + UUID.randomUUID().toString());
        ruleEntity.setId(ruleEntity.getRuleId());
        if (ruleEntity.getSimilarityMatchType() == Rule.SIMILARITY_MATCH_TYPE.PURPOSE) {
            ruleEntity.setExpression(AnalyticsService.normalize((String)ruleEntity.getExpression()));
        } else if (ruleEntity.getSimilarityMatchType() == Rule.SIMILARITY_MATCH_TYPE.REFERENCE_NAME) {
            ruleEntity.setExpression(ruleEntity.getExpression().toLowerCase());
        }
        this.rulesRepository.createOrUpdateRule(ruleEntity);
        this.userRepository.setRulesLastChangeDate(this.principal.getName(), LocalDateTime.now());
    }

    @Transactional
    public void updateCustomRule(RuleEntity ruleEntity) {
        ruleEntity.setUserId(this.principal.getName());
        this.rulesRepository.createOrUpdateRule(ruleEntity);
        this.userRepository.setRulesLastChangeDate(this.principal.getName(), LocalDateTime.now());
    }

    private List<Rule> loadUserRules(String userId) {
        return this.rulesRepository.findByUserId(userId).stream().map(customRuleEntity -> {
            Rule smartanalyticsRule = new Rule();
            BeanUtils.copyProperties((Object)customRuleEntity, (Object)smartanalyticsRule);
            if (customRuleEntity.getSimilarityMatchType() != null) {
                smartanalyticsRule.setSimilarityMatchType(Rule.SIMILARITY_MATCH_TYPE.valueOf((String)customRuleEntity.getSimilarityMatchType().toString()));
            }
            smartanalyticsRule.setStop(customRuleEntity.getRuleType() == null || customRuleEntity.getRuleType().equalsIgnoreCase("stop"));
            return smartanalyticsRule;
        }).collect(Collectors.toList());
    }

    @Transactional
    public void deleteRule(String ruleId) {
        this.rulesRepository.deleteRule(ruleId);
        this.userRepository.setRulesLastChangeDate(this.principal.getName(), LocalDateTime.now());
    }

    public void saveAccountAnalytics(BankAccountEntity bankAccountEntity, List<BookingGroup> bookingGroups) {
        AccountAnalyticsEntity accountAnalyticsEntity = new AccountAnalyticsEntity();
        accountAnalyticsEntity.setUserId(bankAccountEntity.getUserId());
        accountAnalyticsEntity.setAccountId(bankAccountEntity.getId());
        accountAnalyticsEntity.setAnalyticsDate(LocalDateTime.now());
        accountAnalyticsEntity.setBookingGroups(this.smartAnalyticsMapper.mapBookingGroups(bookingGroups));
        this.analyticsRepository.deleteByAccountId(bankAccountEntity.getId());
        this.analyticsRepository.save(accountAnalyticsEntity);
    }

    public void identifyAndStoreContracts(String userId, String accountId, List<BookingGroup> bookingGroups) {
        List contractEntities = bookingGroups.stream().filter(BookingGroup::isContract).map(category -> this.smartAnalyticsMapper.toContractEntity(userId, accountId, category)).collect(Collectors.toList());
        this.contractRepository.deleteByAccountId(accountId);
        this.contractRepository.save(contractEntities);
    }

    public AnalyticsResult analyzeBookings(String userId, List<BookingEntity> bookingEntities) {
        bookingEntities.forEach(bookingEntity -> bookingEntity.setBookingCategory(null));
        return this.smartAnalyticsService.analyzeBookings(this.loadUserRules(userId), this.smartAnalyticsMapper.toSmartAnalyticsBookings(bookingEntities));
    }

    public AnalyticsService(UserRepositoryIf userRepository, BookingRuleRepositoryIf rulesRepository, AnalyticsRepositoryIf analyticsRepository, ContractRepositoryIf contractRepository, SmartAnalyticsIf smartAnalyticsService, SmartAnalyticsMapper smartAnalyticsMapper, Principal principal) {
        this.userRepository = userRepository;
        this.rulesRepository = rulesRepository;
        this.analyticsRepository = analyticsRepository;
        this.contractRepository = contractRepository;
        this.smartAnalyticsService = smartAnalyticsService;
        this.smartAnalyticsMapper = smartAnalyticsMapper;
        this.principal = principal;
    }
}

